/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.impl;

import znaishaded.io.netty.handler.codec.http.cookie.DefaultCookie;
import znaishaded.io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import znaishaded.io.vertx.ext.web.Cookie;

public class CookieImpl
implements Cookie {
    private final znaishaded.io.netty.handler.codec.http.cookie.Cookie nettyCookie;
    private boolean changed;
    private boolean fromUserAgent;

    public CookieImpl(String name, String value) {
        this.nettyCookie = new DefaultCookie(name, value);
        this.changed = true;
    }

    public CookieImpl(znaishaded.io.netty.handler.codec.http.cookie.Cookie nettyCookie) {
        this.nettyCookie = nettyCookie;
        this.fromUserAgent = true;
    }

    @Override
    public String getValue() {
        return this.nettyCookie.value();
    }

    @Override
    public Cookie setValue(String value) {
        this.nettyCookie.setValue(value);
        this.changed = true;
        return this;
    }

    @Override
    public String getName() {
        return this.nettyCookie.name();
    }

    @Override
    public Cookie setDomain(String domain) {
        this.nettyCookie.setDomain(domain);
        this.changed = true;
        return this;
    }

    @Override
    public String getDomain() {
        return this.nettyCookie.domain();
    }

    @Override
    public Cookie setPath(String path2) {
        this.nettyCookie.setPath(path2);
        this.changed = true;
        return this;
    }

    @Override
    public String getPath() {
        return this.nettyCookie.path();
    }

    @Override
    public Cookie setMaxAge(long maxAge) {
        this.nettyCookie.setMaxAge(maxAge);
        this.changed = true;
        return this;
    }

    @Override
    public Cookie setSecure(boolean secure) {
        this.nettyCookie.setSecure(secure);
        this.changed = true;
        return this;
    }

    @Override
    public Cookie setHttpOnly(boolean httpOnly) {
        this.nettyCookie.setHttpOnly(httpOnly);
        this.changed = true;
        return this;
    }

    @Override
    public String encode() {
        return ServerCookieEncoder.STRICT.encode(this.nettyCookie);
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    @Override
    public boolean isFromUserAgent() {
        return this.fromUserAgent;
    }
}

