/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole;

import java.util.Arrays;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.EmbededDiagram;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.creole.Atom;
import znaishaded.net.sourceforge.plantuml.creole.AtomEmbededSystem;
import znaishaded.net.sourceforge.plantuml.creole.CreoleContext;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.CreoleStripeSimpleParser;
import znaishaded.net.sourceforge.plantuml.creole.Sheet;
import znaishaded.net.sourceforge.plantuml.creole.Stripe;
import znaishaded.net.sourceforge.plantuml.creole.StripeTable;
import znaishaded.net.sourceforge.plantuml.creole.StripeTree;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;

public class CreoleParser {
    private final FontConfiguration fontConfiguration;
    private final ISkinSimple skinParam;
    private final HorizontalAlignment horizontalAlignment;
    private final CreoleMode modeSimpleLine;

    public CreoleParser(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple iSkinSimple, CreoleMode creoleMode) {
        this.modeSimpleLine = creoleMode;
        this.fontConfiguration = fontConfiguration;
        this.skinParam = iSkinSimple;
        if (iSkinSimple == null) {
            throw new IllegalArgumentException();
        }
        this.horizontalAlignment = horizontalAlignment;
    }

    private Stripe createStripe(String string, CreoleContext creoleContext, Stripe stripe) {
        if (stripe instanceof StripeTable && CreoleParser.isTableLine(string)) {
            StripeTable stripeTable = (StripeTable)stripe;
            stripeTable.analyzeAndAddNormal(string);
            return null;
        }
        if (stripe instanceof StripeTree && CreoleParser.isTreeStart(StringUtils.trinNoTrace(string))) {
            StripeTree stripeTree = (StripeTree)stripe;
            stripeTree.analyzeAndAdd(string);
            return null;
        }
        if (CreoleParser.isTableLine(string)) {
            return new StripeTable(this.fontConfiguration, this.skinParam, string);
        }
        if (CreoleParser.isTreeStart(string)) {
            return new StripeTree(this.fontConfiguration, this.skinParam, string);
        }
        return new CreoleStripeSimpleParser(string, creoleContext, this.fontConfiguration, this.skinParam, this.modeSimpleLine).createStripe(creoleContext);
    }

    private static boolean isTableLine(String string) {
        return string.matches("^(\\<#\\w+\\>)?\\|(\\=)?.*\\|$");
    }

    public static boolean doesStartByColor(String string) {
        return string.matches("^(\\<#\\w+\\>).*");
    }

    public static boolean isTreeStart(String string) {
        return string.startsWith("|_");
    }

    public Sheet createSheet(Display display) {
        Sheet sheet = new Sheet(this.horizontalAlignment);
        if (!Display.isNull(display)) {
            CreoleContext creoleContext = new CreoleContext();
            for (CharSequence charSequence : display) {
                Stripe stripe;
                if (charSequence instanceof EmbededDiagram) {
                    final AtomEmbededSystem atomEmbededSystem = new AtomEmbededSystem((EmbededDiagram)charSequence);
                    stripe = new Stripe(){

                        @Override
                        public List<Atom> getAtoms() {
                            return Arrays.asList(atomEmbededSystem);
                        }
                    };
                } else {
                    stripe = this.createStripe(charSequence.toString(), creoleContext, sheet.getLastStripe());
                }
                if (stripe == null) continue;
                sheet.add(stripe);
            }
        }
        return sheet;
    }
}

