/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.creole.Atom;
import znaishaded.net.sourceforge.plantuml.creole.AtomText;
import znaishaded.net.sourceforge.plantuml.creole.Stripe;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fission {
    private final Stripe stripe;
    private final LineBreakStrategy maxWidth;

    public Fission(Stripe stripe, LineBreakStrategy lineBreakStrategy) {
        this.stripe = stripe;
        this.maxWidth = lineBreakStrategy;
        if (lineBreakStrategy == null) {
            throw new IllegalArgumentException();
        }
    }

    public List<Stripe> getSplitted(StringBounder stringBounder) {
        double d = this.maxWidth.getMathWidth();
        if (d == 0.0) {
            return Arrays.asList(this.stripe);
        }
        ArrayList<StripeSimple> arrayList = new ArrayList<StripeSimple>();
        StripeSimple stripeSimple = new StripeSimple();
        for (Atom atom : this.stripe.getAtoms()) {
            for (Atom atom2 : this.getSplitted(stringBounder, atom)) {
                double d2 = atom2.calculateDimension(stringBounder).getWidth();
                if (stripeSimple.totalWidth + d2 > d) {
                    arrayList.add(stripeSimple);
                    stripeSimple = new StripeSimple();
                }
                stripeSimple.addAtom(atom2, d2);
            }
        }
        if (stripeSimple.totalWidth > 0.0) {
            arrayList.add(stripeSimple);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private Collection<? extends Atom> getSplitted(StringBounder stringBounder, Atom atom) {
        if (atom instanceof AtomText) {
            return ((AtomText)atom).getSplitted(stringBounder, this.maxWidth);
        }
        return Collections.singleton(atom);
    }

    private List<Stripe> getSplittedSimple() {
        StripeSimple stripeSimple = new StripeSimple();
        for (Atom atom : this.stripe.getAtoms()) {
            stripeSimple.addAtom(atom, 0.0);
        }
        return Arrays.asList(stripeSimple);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StripeSimple
    implements Stripe {
        private final List<Atom> atoms = new ArrayList<Atom>();
        private double totalWidth;

        StripeSimple() {
        }

        @Override
        public List<Atom> getAtoms() {
            return Collections.unmodifiableList(this.atoms);
        }

        private void addAtom(Atom atom, double d) {
            this.atoms.add(atom);
            this.totalWidth += d;
        }
    }
}

