/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram.dot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.Pragma;
import znaishaded.net.sourceforge.plantuml.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.EntityPortion;
import znaishaded.net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IGroup;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Link;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkDecor;
import znaishaded.net.sourceforge.plantuml.cucadiagram.PortionShower;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.Neighborhood;
import znaishaded.net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;
import znaishaded.net.sourceforge.plantuml.svek.DotMode;
import znaishaded.net.sourceforge.plantuml.ugraphic.ColorMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DotData
implements PortionShower {
    private final List<Link> links;
    private final Collection<ILeaf> leafs;
    private final UmlDiagramType umlDiagramType;
    private final ISkinParam skinParam;
    private final GroupHierarchy groupHierarchy;
    private final IGroup topParent;
    private final PortionShower portionShower;
    private final boolean isHideEmptyDescriptionForState;
    private final DotMode dotMode;
    private final String namespaceSeparator;
    private final Pragma pragma;
    private final ColorMapper colorMapper;
    private final EntityFactory entityFactory;

    public DotData(IGroup iGroup, List<Link> list, Collection<ILeaf> collection, UmlDiagramType umlDiagramType, ISkinParam iSkinParam, GroupHierarchy groupHierarchy, PortionShower portionShower, ColorMapper colorMapper, EntityFactory entityFactory, boolean bl, DotMode dotMode, String string, Pragma pragma) {
        this.namespaceSeparator = string;
        this.pragma = pragma;
        this.topParent = iGroup;
        if (iGroup == null) {
            throw new IllegalArgumentException();
        }
        this.dotMode = dotMode;
        this.isHideEmptyDescriptionForState = bl;
        this.colorMapper = colorMapper;
        this.links = list;
        this.leafs = collection;
        this.umlDiagramType = umlDiagramType;
        this.skinParam = iSkinParam;
        this.groupHierarchy = groupHierarchy;
        this.portionShower = portionShower;
        this.entityFactory = entityFactory;
    }

    public DotData(IGroup iGroup, List<Link> list, Collection<ILeaf> collection, UmlDiagramType umlDiagramType, ISkinParam iSkinParam, GroupHierarchy groupHierarchy, ColorMapper colorMapper, EntityFactory entityFactory, boolean bl, DotMode dotMode, String string, Pragma pragma) {
        this(iGroup, list, collection, umlDiagramType, iSkinParam, groupHierarchy, new PortionShower(){

            public boolean showPortion(EntityPortion entityPortion, IEntity iEntity) {
                return true;
            }
        }, colorMapper, entityFactory, bl, dotMode, string, pragma);
    }

    public UmlDiagramType getUmlDiagramType() {
        return this.umlDiagramType;
    }

    public ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public GroupHierarchy getGroupHierarchy() {
        return this.groupHierarchy;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public Collection<ILeaf> getLeafs() {
        return this.leafs;
    }

    public final IGroup getTopParent() {
        return this.topParent;
    }

    public boolean isEmpty(IGroup iGroup) {
        return this.groupHierarchy.isEmpty(iGroup);
    }

    @Override
    public boolean showPortion(EntityPortion entityPortion, IEntity iEntity) {
        return this.portionShower.showPortion(entityPortion, iEntity);
    }

    public final ColorMapper getColorMapper() {
        return this.colorMapper;
    }

    public IGroup getRootGroup() {
        return this.entityFactory.getRootGroup();
    }

    public final boolean isHideEmptyDescriptionForState() {
        return this.isHideEmptyDescriptionForState;
    }

    public final DotMode getDotMode() {
        return this.dotMode;
    }

    public final String getNamespaceSeparator() {
        return this.namespaceSeparator;
    }

    public Pragma getPragma() {
        return this.pragma;
    }

    public void removeIrrelevantSametail() {
        String string;
        HashMap<Iterator<Link>, Integer> hashMap = new HashMap<Iterator<Link>, Integer>();
        for (Link link : this.links) {
            Iterator<Link> iterator;
            if (link.getType().getDecor2() == LinkDecor.EXTENDS) {
                link.setSametail(link.getEntity1().getUid());
            }
            if ((iterator = link.getSametail()) == null) continue;
            Integer object = (Integer)hashMap.get(iterator);
            hashMap.put(iterator, object == null ? 1 : object + 1);
        }
        HashSet hashSet = new HashSet();
        int n = this.skinParam.groupInheritance();
        for (Map.Entry entry : hashMap.entrySet()) {
            string = (String)entry.getKey();
            if ((Integer)entry.getValue() < n) {
                hashSet.add(string);
                continue;
            }
            ArrayList<Link> arrayList = new ArrayList<Link>();
            for (Link link : this.links) {
                if (!string.equals(link.getSametail())) continue;
                arrayList.add(link);
            }
            ILeaf iLeaf = this.getLeaf(string);
            Neighborhood neighborhood = new Neighborhood(iLeaf, arrayList, this.getLinksOfThisLeaf(iLeaf));
            iLeaf.setNeighborhood(neighborhood);
        }
        for (Link link : this.links) {
            string = link.getSametail();
            if (string == null || !hashSet.contains(string)) continue;
            link.setSametail(null);
        }
    }

    private List<Link> getLinksOfThisLeaf(ILeaf iLeaf) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : this.links) {
            if (!link.contains(iLeaf)) continue;
            arrayList.add(link);
        }
        return arrayList;
    }

    private ILeaf getLeaf(String string) {
        for (ILeaf iLeaf : this.leafs) {
            if (!iLeaf.getUid().equals(string)) continue;
            return iLeaf;
        }
        return null;
    }
}

