/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graph;

import java.util.Random;
import znaishaded.net.sourceforge.plantuml.graph.Board;
import znaishaded.net.sourceforge.plantuml.graph.CostComputer;
import znaishaded.net.sourceforge.plantuml.graph.Move;

public class Oven {
    private final double temp;
    private final CostComputer costComputer;

    public Oven(double d, CostComputer costComputer) {
        this.temp = d;
        this.costComputer = costComputer;
    }

    public Board longTic(int n, Board board, Random random) {
        double d = this.costComputer.getCost(board);
        Board board2 = board.copy();
        for (int i = 0; i < n; ++i) {
            double d2 = this.tic(board, random);
            if (!(d2 < d)) continue;
            d = d2;
            board2 = board.copy();
        }
        return board2;
    }

    public double tic(Board board, Random random) {
        double d = this.costComputer.getCost(board);
        Move move = null;
        board.applyMove(move);
        double d2 = this.costComputer.getCost(board);
        double d3 = d2 - d;
        if (d3 <= 0.0) {
            return d2;
        }
        assert (d3 > 0.0);
        assert (d2 > d);
        if (this.temp > 0.0) {
            double d4 = Math.exp(-d3 / this.temp);
            double d5 = random.nextDouble();
            if (d5 < d4) {
                return d2;
            }
        }
        board.applyMove(move.getBackMove());
        assert (d == this.costComputer.getCost(board));
        return d;
    }
}

