/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.hector;

import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.geom.LineSegmentDouble;
import znaishaded.net.sourceforge.plantuml.hector.HectorPath;
import znaishaded.net.sourceforge.plantuml.hector.UnlinearCompression;

class UnlinarCompressedPlan {
    private final UnlinearCompression compX;
    private final UnlinearCompression compY;

    public UnlinarCompressedPlan(double d, double d2) {
        this(d, d2, d, d2);
    }

    public UnlinarCompressedPlan(double d, double d2, double d3, double d4) {
        this.compX = new UnlinearCompression(d, d2);
        this.compY = new UnlinearCompression(d3, d4);
    }

    public double getInnerX() {
        return this.compX.innerSize();
    }

    public double getInnerY() {
        return this.compY.innerSize();
    }

    public HectorPath uncompressSegmentSimple(Point2D point2D, Point2D point2D2) {
        HectorPath hectorPath = new HectorPath();
        hectorPath.add(new LineSegmentDouble(this.uncompress(point2D, UnlinearCompression.Rounding.CENTRAL), this.uncompress(point2D2, UnlinearCompression.Rounding.CENTRAL)));
        return hectorPath;
    }

    public HectorPath uncompressSegment(Point2D point2D, Point2D point2D2) {
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = point2D2.getX();
        double d4 = point2D2.getY();
        HectorPath hectorPath = new HectorPath();
        double[] dArray = this.compY.encounteredSingularities(d2, d4);
        if (dArray.length == 0 || d == d3) {
            hectorPath.add(new LineSegmentDouble(this.uncompress(point2D, UnlinearCompression.Rounding.CENTRAL), this.uncompress(point2D2, UnlinearCompression.Rounding.CENTRAL)));
            return hectorPath;
        }
        System.err.println("len=" + dArray.length);
        LineSegmentDouble lineSegmentDouble = new LineSegmentDouble(point2D, point2D2);
        for (int i = 0; i < dArray.length; ++i) {
            double d5 = lineSegmentDouble.getIntersectionHorizontal(dArray[i]);
            UnlinearCompression.Rounding rounding = i == 0 ? UnlinearCompression.Rounding.CENTRAL : UnlinearCompression.Rounding.BORDER_2;
            hectorPath.add(this.uncompress(d, d2, rounding), this.uncompress(d5, dArray[i], UnlinearCompression.Rounding.BORDER_1));
            d = d5;
            d2 = dArray[i];
        }
        hectorPath.add(this.uncompress(d, d2, UnlinearCompression.Rounding.BORDER_2), this.uncompress(d3, d4, UnlinearCompression.Rounding.CENTRAL));
        return hectorPath;
    }

    public HectorPath uncompress(LineSegmentDouble lineSegmentDouble) {
        double d = lineSegmentDouble.getX1();
        double d2 = lineSegmentDouble.getY1();
        double d3 = lineSegmentDouble.getX2();
        double d4 = lineSegmentDouble.getY2();
        HectorPath hectorPath = new HectorPath();
        double[] dArray = this.compX.encounteredSingularities(d, d3);
        if (dArray.length == 0) {
            hectorPath.add(this.getUncompressedSegment(d, d2, d3, d4, UnlinearCompression.Rounding.BORDER_2));
            return hectorPath;
        }
        for (int i = 0; i < dArray.length; ++i) {
            double d5 = lineSegmentDouble.getIntersectionVertical(dArray[i]);
            hectorPath.add(this.getUncompressedSegment(d, d2, dArray[i], d5, UnlinearCompression.Rounding.BORDER_2));
            d = dArray[i];
            d2 = d5;
        }
        hectorPath.add(this.getUncompressedSegment(d, d2, d3, d4, UnlinearCompression.Rounding.BORDER_2));
        return hectorPath;
    }

    public Point2D uncompress(Point2D point2D, UnlinearCompression.Rounding rounding) {
        return this.uncompress(point2D.getX(), point2D.getY(), rounding);
    }

    public Point2D uncompress(double d, double d2, UnlinearCompression.Rounding rounding) {
        return new Point2D.Double(this.compX.uncompress(d, rounding), this.compY.uncompress(d2, rounding));
    }

    private LineSegmentDouble getUncompressedSegment(double d, double d2, double d3, double d4, UnlinearCompression.Rounding rounding) {
        LineSegmentDouble lineSegmentDouble = new LineSegmentDouble(this.compX.uncompress(d, rounding), this.compY.uncompress(d2, rounding), this.compX.uncompress(d3, rounding), this.compY.uncompress(d4, rounding));
        return lineSegmentDouble;
    }
}

