/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.png;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.SplitParam;
import znaishaded.net.sourceforge.plantuml.SuggestedFile;
import znaishaded.net.sourceforge.plantuml.png.PngIO;
import znaishaded.net.sourceforge.plantuml.png.PngSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PngSplitter {
    private final List<File> files = new ArrayList<File>();

    public PngSplitter(SuggestedFile suggestedFile, int n, int n2, String string, int n3, boolean bl, SplitParam splitParam) throws IOException {
        if (n == 1 && n2 == 1) {
            this.files.add(suggestedFile.getFile(0));
            return;
        }
        Log.info("Splitting " + n + " x " + n2);
        File file = suggestedFile.getTmpFile();
        file.delete();
        boolean bl2 = suggestedFile.getFile(0).renameTo(file);
        if (!bl2) {
            throw new IOException("Cannot rename");
        }
        BufferedImage bufferedImage = ImageIO.read(file);
        PngSegment pngSegment = new PngSegment(bufferedImage.getWidth(), n);
        PngSegment pngSegment2 = new PngSegment(bufferedImage.getHeight(), n2);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                File file2 = suggestedFile.getFile(n4++);
                this.files.add(file2);
                int n5 = pngSegment.getLen(i);
                int n6 = pngSegment2.getLen(j);
                BufferedImage bufferedImage2 = bufferedImage.getSubimage(pngSegment.getStart(i), pngSegment2.getStart(j), n5, n6);
                if (splitParam.isSet()) {
                    BufferedImage bufferedImage3 = new BufferedImage(n5 + 2 * splitParam.getExternalMargin(), n6 + 2 * splitParam.getExternalMargin(), 2);
                    Graphics2D graphics2D = bufferedImage3.createGraphics();
                    if (splitParam.getExternalColor() != null) {
                        graphics2D.setColor(splitParam.getExternalColor());
                        graphics2D.fillRect(0, 0, bufferedImage3.getWidth(), bufferedImage3.getHeight());
                    }
                    graphics2D.drawImage((Image)bufferedImage2, splitParam.getExternalMargin(), splitParam.getExternalMargin(), null);
                    if (splitParam.getBorderColor() != null) {
                        graphics2D.setColor(splitParam.getBorderColor());
                        graphics2D.drawRect(splitParam.getExternalMargin() - 1, splitParam.getExternalMargin() - 1, bufferedImage2.getWidth() + 1, bufferedImage2.getHeight() + 1);
                    }
                    bufferedImage2 = bufferedImage3;
                    graphics2D.dispose();
                }
                PngIO.write((RenderedImage)bufferedImage2, file2, bl ? string : null, n3);
            }
        }
        file.delete();
        Log.info("End of splitting");
    }

    public List<File> getFiles() {
        return Collections.unmodifiableList(this.files);
    }
}

