/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.posimo;

import java.awt.geom.Dimension2D;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frame
implements Component {
    private final List<? extends CharSequence> name;
    private final ISkinParam skinParam;
    private final Rose rose = new Rose();

    public Frame(List<? extends CharSequence> list, ISkinParam iSkinParam) {
        this.name = list;
        this.skinParam = iSkinParam;
    }

    @Override
    public void drawU(UGraphic uGraphic, Area area, Context2D context2D) {
        Dimension2D dimension2D = area.getDimensionToUse();
        HtmlColor htmlColor = this.rose.getHtmlColor(this.skinParam, ColorParam.packageBorder);
        uGraphic = uGraphic.apply(new UChangeColor(htmlColor));
        uGraphic = uGraphic.apply(new UChangeBackColor(null));
        uGraphic.apply(new UStroke(1.4)).draw(new URectangle(dimension2D.getWidth(), dimension2D.getHeight()));
        TextBlock textBlock = this.createTextBloc();
        textBlock.drawU(uGraphic.apply(new UTranslate(2.0, 2.0)));
        Dimension2D dimension2D2 = this.getTextDim(uGraphic.getStringBounder());
        double d = dimension2D2.getWidth() + 6.0;
        double d2 = dimension2D2.getHeight() + 6.0;
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(d, 0.0);
        uPolygon.addPoint(d, d2 - 6.0);
        uPolygon.addPoint(d - 6.0, d2);
        uPolygon.addPoint(0.0, d2);
        uPolygon.addPoint(0.0, 0.0);
        uGraphic.apply(new UStroke(1.4)).draw(uPolygon);
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Dimension2D dimension2D = this.getTextDim(stringBounder);
        return dimension2D.getHeight() + 8.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        Dimension2D dimension2D = this.getTextDim(stringBounder);
        return dimension2D.getWidth() + 8.0;
    }

    public Dimension2D getTextDim(StringBounder stringBounder) {
        TextBlock textBlock = this.createTextBloc();
        return textBlock.calculateDimension(stringBounder);
    }

    private TextBlock createTextBloc() {
        UFont uFont = this.skinParam.getFont(null, false, FontParam.PACKAGE);
        HtmlColor htmlColor = this.skinParam.getFontHtmlColor(null, FontParam.PACKAGE);
        throw new UnsupportedOperationException();
    }

    @Override
    public final Dimension2D getPreferredDimension(StringBounder stringBounder) {
        double d = this.getPreferredWidth(stringBounder);
        double d2 = this.getPreferredHeight(stringBounder);
        return new Dimension2DDouble(d, d2);
    }
}

