/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project3;

import znaishaded.net.sourceforge.plantuml.project3.Complement;
import znaishaded.net.sourceforge.plantuml.project3.DayOfWeek;
import znaishaded.net.sourceforge.plantuml.project3.Month;

public class DayAsDate
implements Complement {
    private final int year;
    private final int dayOfMonth;
    private final Month month;

    public static DayAsDate create(int n, String string, int n2) {
        return new DayAsDate(n, Month.fromString(string), n2);
    }

    public static DayAsDate create(int n, int n2, int n3) {
        return new DayAsDate(n, Month.values()[n2 - 1], n3);
    }

    private DayAsDate(int n, Month month, int n2) {
        this.year = n;
        this.dayOfMonth = n2;
        this.month = month;
    }

    public String toString() {
        return "" + this.year + "/" + (Object)((Object)this.month) + "/" + this.dayOfMonth;
    }

    public final int getDayOfMonth() {
        return this.dayOfMonth;
    }

    private int daysPerMonth() {
        return this.month.getDaysPerMonth(this.year);
    }

    public DayAsDate next() {
        int n = this.dayOfMonth + 1;
        if (n <= this.daysPerMonth()) {
            return new DayAsDate(this.year, this.month, n);
        }
        assert (n > this.daysPerMonth());
        n = 1;
        Month month = this.month.next();
        int n2 = month == Month.JANUARY ? this.year + 1 : this.year;
        return new DayAsDate(n2, month, n);
    }

    public Month getMonth() {
        return this.month;
    }

    public DayOfWeek getDayOfWeek() {
        int n = this.dayOfMonth;
        int n2 = this.month.m();
        int n3 = n2 >= 13 ? this.year - 1 : this.year;
        int n4 = n3 % 100;
        int n5 = n3 / 100;
        int n6 = (n + 13 * (n2 + 1) / 5 + n4 + n4 / 4 + n5 / 4 + 5 * n5) % 7;
        return DayOfWeek.fromH(n6);
    }
}

