/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.project3.TaskCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskCodeSimpleOrder
implements Comparator<TaskCode> {
    private final List<TaskCode> order;
    private final int hierarchySize;

    public TaskCodeSimpleOrder(Collection<TaskCode> collection, int n) {
        this.order = new ArrayList<TaskCode>(collection);
        this.hierarchySize = n;
        for (TaskCode taskCode : collection) {
            if (taskCode.getHierarchySize() == n) continue;
            throw new IllegalArgumentException();
        }
    }

    @Override
    public int compare(TaskCode taskCode, TaskCode taskCode2) {
        if (taskCode.getHierarchySize() < this.hierarchySize) {
            throw new IllegalArgumentException();
        }
        if (taskCode2.getHierarchySize() < this.hierarchySize) {
            throw new IllegalArgumentException();
        }
        taskCode = taskCode.truncateHierarchy(this.hierarchySize);
        taskCode2 = taskCode2.truncateHierarchy(this.hierarchySize);
        int n = this.order.indexOf(taskCode);
        int n2 = this.order.indexOf(taskCode2);
        return n - n2;
    }
}

