/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.stats;

import java.io.PrintStream;
import java.util.Date;
import znaishaded.net.sourceforge.plantuml.stats.StatsUtils;
import znaishaded.net.sourceforge.plantuml.stats.TextTable;
import znaishaded.net.sourceforge.plantuml.stats.api.Stats;
import znaishaded.net.sourceforge.plantuml.stats.api.StatsColumn;
import znaishaded.net.sourceforge.plantuml.stats.api.StatsLine;

public class TextConverter {
    private final Stats stats;
    private int linesUsed;

    public TextConverter(Stats stats) {
        this.stats = stats;
    }

    public void printMe(PrintStream printStream) {
        TextTable textTable = new TextTable();
        textTable.addSeparator();
        textTable.addLine("ID", "Start", "Duration", "Generated", "Mean(ms)");
        textTable.addSeparator();
        for (StatsLine statsLine : this.stats.getLastSessions().getLines()) {
            Object object = (Long)statsLine.getValue(StatsColumn.SESSION_ID);
            if (object == null) {
                object = "";
            }
            Date date = (Date)statsLine.getValue(StatsColumn.STARTING);
            String string = statsLine.getValue(StatsColumn.DURATION_STRING).toString();
            Long l = (Long)statsLine.getValue(StatsColumn.GENERATED_COUNT);
            Long l2 = (Long)statsLine.getValue(StatsColumn.GENERATED_MEAN_TIME);
            textTable.addLine(object, date, string, l, l2);
        }
        textTable.addSeparator();
        this.linesUsed = textTable.getLines();
        textTable.printMe(printStream);
    }

    public int getLinesUsed() {
        return this.linesUsed;
    }

    public static void main(String[] stringArray) {
        StatsUtils.dumpStats();
    }
}

