/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import znaishaded.net.sourceforge.plantuml.cucadiagram.EntityUtils;
import znaishaded.net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import znaishaded.net.sourceforge.plantuml.cucadiagram.GroupType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IGroup;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Link;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.DotData;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.svek.DotDataImageBuilder;
import znaishaded.net.sourceforge.plantuml.svek.DotMode;
import znaishaded.net.sourceforge.plantuml.svek.IEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.InnerActivity;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageState;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroupPngMakerActivity {
    private final CucaDiagram diagram;
    private final IGroup group;
    private final StringBounder stringBounder;
    private final Rose rose = new Rose();

    public GroupPngMakerActivity(CucaDiagram cucaDiagram, IGroup iGroup, StringBounder stringBounder) {
        this.diagram = cucaDiagram;
        this.group = iGroup;
        this.stringBounder = stringBounder;
    }

    private List<Link> getPureInnerLinks() {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : this.diagram.getLinks()) {
            IEntity iEntity = link.getEntity1();
            IEntity iEntity2 = link.getEntity2();
            if (iEntity.getParentContainer() != this.group || iEntity.isGroup() || iEntity2.getParentContainer() != this.group || iEntity2.isGroup()) continue;
            arrayList.add(link);
        }
        return arrayList;
    }

    public IEntityImage getImage() throws IOException, InterruptedException {
        if (this.group.size() == 0) {
            return new EntityImageState(this.group, this.diagram.getSkinParam());
        }
        List<Link> list = this.getPureInnerLinks();
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        DotData dotData = new DotData(this.group, list, this.group.getLeafsDirect(), this.diagram.getUmlDiagramType(), iSkinParam, new InnerGroupHierarchy(), this.diagram.getColorMapper(), this.diagram.getEntityFactory(), false, DotMode.NORMAL, this.diagram.getNamespaceSeparator(), this.diagram.getPragma());
        DotDataImageBuilder dotDataImageBuilder = new DotDataImageBuilder(dotData, this.diagram.getEntityFactory(), this.diagram.getSource(), this.diagram.getPragma(), this.stringBounder);
        if (this.group.getGroupType() == GroupType.INNER_ACTIVITY) {
            Stereotype stereotype = this.group.getStereotype();
            HtmlColor htmlColor = this.getColor(ColorParam.activityBorder, stereotype);
            HtmlColor htmlColor2 = this.group.getColors(iSkinParam).getColor(ColorType.BACK) == null ? this.getColor(ColorParam.background, stereotype) : this.group.getColors(iSkinParam).getColor(ColorType.BACK);
            return new InnerActivity(dotDataImageBuilder.buildImage(null, new String[0]), htmlColor, htmlColor2, iSkinParam.shadowing());
        }
        throw new UnsupportedOperationException(this.group.getGroupType().toString());
    }

    private UFont getFont(FontParam fontParam) {
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        return iSkinParam.getFont(null, false, fontParam);
    }

    protected final HtmlColor getColor(ColorParam colorParam, Stereotype stereotype) {
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        return this.rose.getHtmlColor(iSkinParam, colorParam, stereotype);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InnerGroupHierarchy
    implements GroupHierarchy {
        InnerGroupHierarchy() {
        }

        @Override
        public Collection<IGroup> getChildrenGroups(IGroup iGroup) {
            if (EntityUtils.groupRoot(iGroup)) {
                return GroupPngMakerActivity.this.diagram.getChildrenGroups(GroupPngMakerActivity.this.group);
            }
            return GroupPngMakerActivity.this.diagram.getChildrenGroups(iGroup);
        }

        @Override
        public boolean isEmpty(IGroup iGroup) {
            return GroupPngMakerActivity.this.diagram.isEmpty(iGroup);
        }
    }
}

