/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImagePseudoState
extends AbstractEntityImage {
    private static final int SIZE = 22;
    private final TextBlock desc;

    public EntityImagePseudoState(ILeaf iLeaf, ISkinParam iSkinParam) {
        super(iLeaf, iSkinParam);
        Stereotype stereotype = iLeaf.getStereotype();
        this.desc = Display.create("H").create(new FontConfiguration(this.getSkinParam(), FontParam.STATE, stereotype), HorizontalAlignment.CENTER, iSkinParam);
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(22.0, 22.0);
    }

    public final void drawU(UGraphic uGraphic) {
        UEllipse uEllipse = new UEllipse(22.0, 22.0);
        if (this.getSkinParam().shadowing()) {
            uEllipse.setDeltaShadow(4.0);
        }
        uGraphic = uGraphic.apply(new UStroke(1.5));
        uGraphic = uGraphic.apply(new UChangeBackColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stateBackground, this.getStereo()))).apply(new UChangeColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stateBorder, this.getStereo())));
        uGraphic.draw(uEllipse);
        uGraphic = uGraphic.apply(new UStroke());
        Dimension2D dimension2D = this.desc.calculateDimension(uGraphic.getStringBounder());
        double d = dimension2D.getWidth();
        double d2 = dimension2D.getHeight();
        double d3 = (22.0 - d) / 2.0;
        double d4 = (22.0 - d2) / 2.0;
        this.desc.drawU(uGraphic.apply(new UTranslate(d3, d4)));
    }

    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }
}

