/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.tikz;

import java.awt.Color;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.eps.EpsGraphics;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.USegment;
import znaishaded.net.sourceforge.plantuml.ugraphic.USegmentType;
import znaishaded.net.sourceforge.plantuml.version.Version;

public class TikzGraphics {
    private final List<String> cmd = new ArrayList<String>();
    private final boolean withPreamble;
    private Color color = Color.BLACK;
    private Color fillcolor = Color.BLACK;
    private double thickness = 1.0;
    private final double scale;
    private String dash = null;
    private final Map<Color, String> colornames = new LinkedHashMap<Color, String>();
    private String pendingUrl = null;
    private boolean urlIgnoreText = false;
    private boolean hasUrl = false;

    public TikzGraphics(double d, boolean bl) {
        this.withPreamble = bl;
        this.scale = d;
    }

    private String getColorName(Color color) {
        if (color.equals(Color.WHITE)) {
            return "white";
        }
        if (color.equals(Color.BLACK)) {
            return "black";
        }
        String string = this.colornames.get(color);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return string;
    }

    public void createData(OutputStream outputStream) throws IOException {
        if (this.withPreamble) {
            this.out(outputStream, "\\documentclass{article}");
            this.out(outputStream, "\\usepackage{tikz}");
            this.out(outputStream, "\\usepackage{aeguill}");
            if (this.hasUrl) {
                this.out(outputStream, "\\usetikzlibrary{calc}");
                this.out(outputStream, "\\usepackage{hyperref}");
            }
            this.out(outputStream, "\\begin{document}");
        }
        this.out(outputStream, "% generated by Plantuml " + Version.versionString(15));
        if (this.hasUrl && this.withPreamble) {
            this.out(outputStream, "\\tikzset{");
            this.out(outputStream, "    href node/.style={");
            this.out(outputStream, "        alias=sourcenode,");
            this.out(outputStream, "        append after command={");
            this.out(outputStream, "            let \\p1 = (sourcenode.north west),");
            this.out(outputStream, "                \\p2=(sourcenode.south east),");
            this.out(outputStream, "                \\n1={\\x2-\\x1},");
            this.out(outputStream, "                \\n2={\\y2-\\y1} in");
            this.out(outputStream, "            node [inner sep=0pt, outer sep=0pt,anchor=north west,at=(\\p1)] {\\href{#1}{\\XeTeXLinkBox{\\phantom{\\rule{\\n1}{\\n2}}}}}");
            this.out(outputStream, "                    %xelatex needs \\XeTeXLinkBox, won't create a link unless it");
            this.out(outputStream, "                    %finds text --- rules don't work without \\XeTeXLinkBox.");
            this.out(outputStream, "                    %Still builds correctly with pdflatex and lualatex");
            this.out(outputStream, "        }");
            this.out(outputStream, "    }");
            this.out(outputStream, "}");
            this.out(outputStream, "\\tikzset{");
            this.out(outputStream, "    hyperref node/.style={");
            this.out(outputStream, "        alias=sourcenode,");
            this.out(outputStream, "        append after command={");
            this.out(outputStream, "            let \\p1 = (sourcenode.north west),");
            this.out(outputStream, "                \\p2=(sourcenode.south east),");
            this.out(outputStream, "                \\n1={\\x2-\\x1},");
            this.out(outputStream, "                \\n2={\\y2-\\y1} in");
            this.out(outputStream, "            node [inner sep=0pt, outer sep=0pt,anchor=north west,at=(\\p1)] {\\hyperref [#1]{\\XeTeXLinkBox{\\phantom{\\rule{\\n1}{\\n2}}}}}");
            this.out(outputStream, "                    %xelatex needs \\XeTeXLinkBox, won't create a link unless it");
            this.out(outputStream, "                    %finds text --- rules don't work without \\XeTeXLinkBox.");
            this.out(outputStream, "                    %Still builds correctly with pdflatex and lualatex");
            this.out(outputStream, "        }");
            this.out(outputStream, "    }");
            this.out(outputStream, "}");
        }
        for (Map.Entry<Color, String> object : this.colornames.entrySet()) {
            this.out(outputStream, this.definecolor(object.getValue(), object.getKey()));
        }
        if (this.scale != 1.0) {
            this.out(outputStream, "\\scalebox{" + this.format(this.scale) + "}{");
        }
        this.out(outputStream, "\\begin{tikzpicture}[yscale=-1]");
        for (String string : this.cmd) {
            this.out(outputStream, string);
        }
        this.out(outputStream, "\\end{tikzpicture}");
        if (this.scale != 1.0) {
            this.out(outputStream, "}");
        }
        if (this.withPreamble) {
            this.out(outputStream, "\\end{document}");
        }
    }

    private String definecolor(String string, Color color) {
        return "\\definecolor{" + string + "}{RGB}{" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "}";
    }

    public void rectangle(double d, double d2, double d3, double d4) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.pendingUrl == null) {
            stringBuilder.append("\\draw[");
            if (this.color != null) {
                stringBuilder.append("color=" + this.getColorName(this.color) + ",");
            }
            if (this.fillcolor != null) {
                stringBuilder.append("fill=" + this.getColorName(this.fillcolor) + ",");
                if (this.color == null) {
                    stringBuilder.append("color=" + this.getColorName(this.fillcolor) + ",");
                }
            }
            stringBuilder.append("line width=" + this.thickness + "pt] ");
            stringBuilder.append(this.couple(d, d2) + " rectangle " + this.couple(d + d3, d2 + d4));
            stringBuilder.append(";");
        } else {
            stringBuilder.append("\\node at " + this.couple(d, d2) + "[draw, ");
            if (this.color != null) {
                stringBuilder.append("color=" + this.getColorName(this.color) + ",");
            }
            if (this.fillcolor != null) {
                stringBuilder.append("fill=" + this.getColorName(this.fillcolor) + ",");
                if (this.color == null) {
                    stringBuilder.append("color=" + this.getColorName(this.fillcolor) + ",");
                }
            }
            stringBuilder.append("line width=" + this.thickness + "pt,");
            stringBuilder.append("below right,");
            stringBuilder.append("inner sep=2ex,");
            stringBuilder.append("minimum width=" + this.format(d3) + "pt,");
            stringBuilder.append("minimum height=" + this.format(d4) + "pt,");
            if (Url.isLatex(this.pendingUrl)) {
                stringBuilder.append("hyperref node=" + TikzGraphics.extractInternalHref(this.pendingUrl));
            } else {
                stringBuilder.append("href node=" + this.pendingUrl);
            }
            stringBuilder.append("] ");
            stringBuilder.append(" {};");
            this.urlIgnoreText = true;
        }
        this.cmd.add(stringBuilder.toString());
    }

    private String couple(double d, double d2) {
        return "(" + this.format(d) + "pt," + this.format(d2) + "pt)";
    }

    private String format(double d) {
        return EpsGraphics.format(d);
    }

    private void out(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes());
        outputStream.write("\n".getBytes());
    }

    public void text(double d, double d2, String string) {
        StringBuilder stringBuilder = new StringBuilder("\\node at " + this.couple(d, d2) + "[below right]{");
        if (this.pendingUrl == null || this.urlIgnoreText) {
            stringBuilder.append(this.protectText(string));
        } else {
            this.appendPendingUrl(stringBuilder);
            stringBuilder.append("{");
            stringBuilder.append(this.protectText(string));
            stringBuilder.append("}");
        }
        stringBuilder.append("};");
        this.cmd.add(stringBuilder.toString());
    }

    private void appendPendingUrl(StringBuilder stringBuilder) {
        if (Url.isLatex(this.pendingUrl)) {
            stringBuilder.append("\\hyperref[");
            stringBuilder.append(TikzGraphics.extractInternalHref(this.pendingUrl));
            stringBuilder.append("]");
        } else {
            stringBuilder.append("\\href{");
            stringBuilder.append(this.pendingUrl);
            stringBuilder.append("}");
        }
    }

    private static String extractInternalHref(String string) {
        if (!Url.isLatex(string)) {
            throw new IllegalArgumentException();
        }
        return string.substring("latex://".length());
    }

    private String protectText(String string) {
        string = string.replaceAll("_", "\\\\_");
        string = string.replaceAll("\u00ab", "\\\\guillemotleft ");
        string = string.replaceAll("\u00bb", "\\\\guillemotright ");
        string = string.replaceAll("<", "\\\\textless ");
        string = string.replaceAll(">", "\\\\textgreater ");
        return string;
    }

    public void line(double d, double d2, double d3, double d4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\\draw[");
        if (this.color != null) {
            stringBuilder.append("color=" + this.getColorName(this.color) + ",");
        }
        stringBuilder.append("line width=" + this.thickness + "pt");
        if (this.dash != null) {
            stringBuilder.append(",dash pattern=" + this.dash);
        }
        stringBuilder.append("] ");
        stringBuilder.append(this.couple(d, d2));
        stringBuilder.append(" -- ");
        stringBuilder.append(this.couple(d3, d4));
        stringBuilder.append(";");
        this.cmd.add(stringBuilder.toString());
    }

    public void polygon(double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder("\\draw[");
        if (this.color != null) {
            stringBuilder.append("color=" + this.getColorName(this.color) + ",");
        }
        if (this.fillcolor != null) {
            stringBuilder.append("fill=" + this.getColorName(this.fillcolor) + ",");
        }
        stringBuilder.append("line width=" + this.thickness + "pt]");
        stringBuilder.append(" ");
        for (int i = 0; i < dArray.length; i += 2) {
            stringBuilder.append(this.couple(dArray[i], dArray[i + 1]));
            stringBuilder.append(" -- ");
        }
        stringBuilder.append("cycle;");
        this.cmd.add(stringBuilder.toString());
    }

    private void round(double d, double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder("\\draw[");
        if (this.color != null) {
            stringBuilder.append("color=" + this.getColorName(this.color) + ",");
        }
        if (this.fillcolor != null) {
            stringBuilder.append("fill=" + this.getColorName(this.fillcolor) + ",");
        }
        stringBuilder.append("line width=" + this.thickness + "pt]");
        stringBuilder.append(" ");
        int n = 0;
        stringBuilder.append(this.couple(dArray[n++], dArray[n++]));
        stringBuilder.append(" arc (180:270:" + this.format(d) + "pt) -- ");
        stringBuilder.append(this.couple(dArray[n++], dArray[n++]));
        stringBuilder.append(" -- ");
        stringBuilder.append(this.couple(dArray[n++], dArray[n++]));
        stringBuilder.append(" arc (270:360:" + this.format(d) + "pt) -- ");
        stringBuilder.append(this.couple(dArray[n++], dArray[n++]));
        stringBuilder.append(" -- ");
        stringBuilder.append(this.couple(dArray[n++], dArray[n++]));
        stringBuilder.append(" arc (0:90:" + this.format(d) + "pt) -- ");
        stringBuilder.append(this.couple(dArray[n++], dArray[n++]));
        stringBuilder.append(" -- ");
        stringBuilder.append(this.couple(dArray[n++], dArray[n++]));
        stringBuilder.append(" arc (90:180:" + this.format(d) + "pt) -- ");
        stringBuilder.append(this.couple(dArray[n++], dArray[n++]));
        stringBuilder.append(" -- ");
        stringBuilder.append("cycle;");
        this.cmd.add(stringBuilder.toString());
    }

    public void rectangleRound(double d, double d2, double d3, double d4, double d5) {
        double[] dArray = new double[]{d, d2 + d5, d + d5, d2, d + d3 - d5, d2, d + d3, d2 + d5, d + d3, d2 + d4 - d5, d + d3 - d5, d2 + d4, d + d5, d2 + d4, d, d2 + d4 - d5};
        this.round(d5, dArray);
    }

    public void upath(double d, double d2, UPath uPath) {
        StringBuilder stringBuilder = new StringBuilder("\\draw[color=" + this.getColorName(this.color) + ",line width=" + this.thickness + "pt] ");
        for (USegment uSegment : uPath) {
            USegmentType uSegmentType = uSegment.getSegmentType();
            double[] dArray = uSegment.getCoord();
            if (uSegmentType == USegmentType.SEG_MOVETO) {
                stringBuilder.append(this.couple(dArray[0] + d, dArray[1] + d2));
                continue;
            }
            if (uSegmentType == USegmentType.SEG_LINETO) {
                stringBuilder.append(" -- ");
                stringBuilder.append(this.couple(dArray[0] + d, dArray[1] + d2));
                continue;
            }
            if (uSegmentType == USegmentType.SEG_QUADTO) {
                throw new UnsupportedOperationException();
            }
            if (uSegmentType == USegmentType.SEG_CUBICTO) {
                stringBuilder.append(" ..controls ");
                stringBuilder.append(this.couple(dArray[0] + d, dArray[1] + d2));
                stringBuilder.append(" and ");
                stringBuilder.append(this.couple(dArray[2] + d, dArray[3] + d2));
                stringBuilder.append(" .. ");
                stringBuilder.append(this.couple(dArray[4] + d, dArray[5] + d2));
                continue;
            }
            if (uSegmentType == USegmentType.SEG_CLOSE) continue;
            Log.println("unknown " + uSegment);
        }
        stringBuilder.append(";");
        this.cmd.add(stringBuilder.toString());
    }

    public void ellipse(double d, double d2, double d3, double d4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\\draw[");
        if (this.color != null) {
            stringBuilder.append("color=" + this.getColorName(this.color) + ",");
        }
        if (this.fillcolor != null) {
            stringBuilder.append("fill=" + this.getColorName(this.fillcolor) + ",");
        }
        stringBuilder.append("line width=" + this.thickness + "pt] " + this.couple(d, d2) + " ellipse (" + this.format(d3) + "pt and " + this.format(d4) + "pt);");
        this.cmd.add(stringBuilder.toString());
    }

    public void drawPathIterator(double d, double d2, PathIterator pathIterator) {
        StringBuilder stringBuilder = new StringBuilder("\\draw[color=" + this.getColorName(this.color) + ",fill=" + this.getColorName(this.color) + "] ");
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            if (n == 0) {
                stringBuilder.append(this.couple(dArray[0] + d, dArray[1] + d2));
            } else if (n == 1) {
                stringBuilder.append(" -- ");
                stringBuilder.append(this.couple(dArray[0] + d, dArray[1] + d2));
            } else if (n == 4) {
                stringBuilder.append(";");
                this.cmd.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                stringBuilder.append("\\draw ");
            } else if (n == 3) {
                stringBuilder.append(" ..controls ");
                stringBuilder.append(this.couple(dArray[0] + d, dArray[1] + d2));
                stringBuilder.append(" and ");
                stringBuilder.append(this.couple(dArray[2] + d, dArray[3] + d2));
                stringBuilder.append(" .. ");
                stringBuilder.append(this.couple(dArray[4] + d, dArray[5] + d2));
            } else if (n == 2) {
                stringBuilder.append(" ..controls ");
                stringBuilder.append(this.couple(dArray[0] + d, dArray[1] + d2));
                stringBuilder.append(" .. ");
                stringBuilder.append(this.couple(dArray[2] + d, dArray[3] + d2));
            } else {
                throw new UnsupportedOperationException("code=" + n);
            }
            pathIterator.next();
        }
    }

    public void setFillColor(Color color) {
        this.fillcolor = color;
        this.addColor(color);
    }

    public void setStrokeColor(Color color) {
        this.color = color;
        this.addColor(color);
    }

    private void addColor(Color color) {
        if (color == null) {
            return;
        }
        if (this.colornames.containsKey(color)) {
            return;
        }
        String string = "plantucolor" + String.format("%04d", this.colornames.size());
        this.colornames.put(color, string);
    }

    public void setStrokeWidth(double d, String string) {
        this.thickness = d;
        this.dash = string;
    }

    public void openLink(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.hasUrl = true;
        this.urlIgnoreText = false;
        this.pendingUrl = string;
    }

    public void closeLink() {
        this.pendingUrl = null;
    }
}

