/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.ant.compress.taskdefs;

import java.io.IOException;
import java.io.OutputStream;
import znaishaded.org.apache.ant.compress.resources.CommonsCompressCompressorResource;
import znaishaded.org.apache.ant.compress.resources.SnappyResource;
import znaishaded.org.apache.ant.compress.taskdefs.PackBase;
import znaishaded.org.apache.ant.compress.util.SnappyStreamFactory;
import znaishaded.org.apache.commons.compress.compressors.CompressorOutputStream;
import znaishaded.org.apache.commons.compress.compressors.snappy.SnappyCompressorOutputStream;
import znaishaded.org.apache.tools.ant.types.Resource;

public final class Snappy
extends PackBase {
    private final InnerSnappyStreamFactory factory = new InnerSnappyStreamFactory();

    public Snappy() {
        super(new PackBase.ResourceWrapper(){

            @Override
            public CommonsCompressCompressorResource wrap(Resource dest) {
                return new SnappyResource(dest);
            }
        });
        this.setFactory(this.factory);
    }

    public void setFramed(boolean framed) {
        this.factory.setFramed(framed);
    }

    private class InnerSnappyStreamFactory
    extends SnappyStreamFactory {
        private InnerSnappyStreamFactory() {
        }

        @Override
        public CompressorOutputStream getCompressorStream(OutputStream stream) throws IOException {
            if (this.isFramed() || Snappy.this.getSrc() == null || Snappy.this.getSrc().getSize() < 0L) {
                return super.getCompressorStream(stream);
            }
            return new SnappyCompressorOutputStream(stream, Snappy.this.getSrc().getSize());
        }
    }
}

