/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.tools.ant.util;

import znaishaded.org.apache.tools.ant.BuildException;
import znaishaded.org.apache.tools.ant.Project;
import znaishaded.org.apache.tools.ant.util.LoaderUtils;
import znaishaded.org.apache.tools.ant.util.ReflectUtil;
import znaishaded.org.apache.tools.ant.util.ScriptFixBSFPath;
import znaishaded.org.apache.tools.ant.util.ScriptRunnerBase;

public class ScriptRunnerCreator {
    private static final String AUTO = "auto";
    private static final String OATAU = "znaishaded.org.apache.tools.ant.util";
    private static final String UTIL_OPT = "znaishaded.org.apache.tools.ant.util.optional";
    private static final String BSF = "bsf";
    private static final String BSF_PACK = "znaishaded.org.apache.bsf";
    private static final String BSF_MANAGER = "znaishaded.org.apache.bsf.BSFManager";
    private static final String BSF_RUNNER = "znaishaded.org.apache.tools.ant.util.optional.ScriptRunner";
    private static final String JAVAX = "javax";
    private static final String JAVAX_MANAGER = "javax.script.ScriptEngineManager";
    private static final String JAVAX_RUNNER = "znaishaded.org.apache.tools.ant.util.optional.JavaxScriptRunner";
    private Project project;
    private String manager;
    private String language;
    private ClassLoader scriptLoader = null;

    public ScriptRunnerCreator(Project project) {
        this.project = project;
    }

    public synchronized ScriptRunnerBase createRunner(String manager, String language, ClassLoader classLoader) {
        this.manager = manager;
        this.language = language;
        this.scriptLoader = classLoader;
        if (language == null) {
            throw new BuildException("script language must be specified");
        }
        if (!(manager.equals(AUTO) || manager.equals(JAVAX) || manager.equals(BSF))) {
            throw new BuildException("Unsupported language prefix " + manager);
        }
        ScriptRunnerBase ret = null;
        ret = this.createRunner(BSF, BSF_MANAGER, BSF_RUNNER);
        if (ret == null) {
            ret = this.createRunner(JAVAX, JAVAX_MANAGER, JAVAX_RUNNER);
        }
        if (ret != null) {
            return ret;
        }
        if (JAVAX.equals(manager)) {
            throw new BuildException("Unable to load the script engine manager (javax.script.ScriptEngineManager)");
        }
        if (BSF.equals(manager)) {
            throw new BuildException("Unable to load the BSF script engine manager (org.apache.bsf.BSFManager)");
        }
        throw new BuildException("Unable to load a script engine manager (org.apache.bsf.BSFManager or javax.script.ScriptEngineManager)");
    }

    private ScriptRunnerBase createRunner(String checkManager, String managerClass, String runnerClass) {
        ScriptRunnerBase runner = null;
        if (!this.manager.equals(AUTO) && !this.manager.equals(checkManager)) {
            return null;
        }
        if (managerClass.equals(BSF_MANAGER)) {
            if (this.scriptLoader.getResource(LoaderUtils.classNameToResource(managerClass)) == null) {
                return null;
            }
            new ScriptFixBSFPath().fixClassLoader(this.scriptLoader, this.language);
        } else {
            try {
                Class.forName(managerClass, true, this.scriptLoader);
            }
            catch (Exception ex) {
                return null;
            }
        }
        try {
            runner = (ScriptRunnerBase)Class.forName(runnerClass, true, this.scriptLoader).newInstance();
            runner.setProject(this.project);
        }
        catch (Exception ex) {
            throw ReflectUtil.toBuildException(ex);
        }
        runner.setLanguage(this.language);
        runner.setScriptClassLoader(this.scriptLoader);
        return runner;
    }
}

