/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.stathissideris.ascii2image.graphics;

import java.awt.geom.GeneralPath;
import znaishaded.org.stathissideris.ascii2image.graphics.DiagramShape;
import znaishaded.org.stathissideris.ascii2image.graphics.ShapePoint;

public class ShapeEdge {
    private static final boolean DEBUG = false;
    private static final int TYPE_HORIZONTAL = 0;
    private static final int TYPE_VERTICAL = 1;
    private static final int TYPE_SLOPED = 2;
    private DiagramShape owner;
    private ShapePoint startPoint;
    private ShapePoint endPoint;

    public ShapeEdge(ShapePoint shapePoint, ShapePoint shapePoint2, DiagramShape diagramShape) {
        this.startPoint = shapePoint;
        this.endPoint = shapePoint2;
        this.owner = diagramShape;
    }

    public ShapeEdge(ShapeEdge shapeEdge) {
        this(new ShapePoint(shapeEdge.startPoint), new ShapePoint(shapeEdge.endPoint), shapeEdge.owner);
    }

    private float getDistanceFromOrigin() {
        int n = this.getType();
        if (n == 2) {
            throw new RuntimeException("Cannot calculate distance of sloped edge from origin");
        }
        if (n == 0) {
            return this.startPoint.y;
        }
        return this.startPoint.x;
    }

    public void moveInwardsBy(float f) {
        int n = this.getType();
        if (n == 2) {
            throw new RuntimeException("Cannot move a sloped egde inwards: " + this);
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        ShapePoint shapePoint = this.getMiddle();
        GeneralPath generalPath = this.owner.makeIntoPath();
        if (n == 0) {
            f2 = 0.0f;
            ShapePoint shapePoint2 = new ShapePoint(shapePoint.x, shapePoint.y - 0.05f);
            ShapePoint shapePoint3 = new ShapePoint(shapePoint.x, shapePoint.y + 0.05f);
            if (generalPath.contains(shapePoint2)) {
                f3 = -f;
            } else if (generalPath.contains(shapePoint3)) {
                f3 = f;
            }
        } else if (n == 1) {
            f3 = 0.0f;
            ShapePoint shapePoint4 = new ShapePoint(shapePoint.x - 0.05f, shapePoint.y);
            ShapePoint shapePoint5 = new ShapePoint(shapePoint.x + 0.05f, shapePoint.y);
            if (generalPath.contains(shapePoint4)) {
                f2 = -f;
            } else if (generalPath.contains(shapePoint5)) {
                f2 = f;
            }
        }
        this.translate(f2, f3);
    }

    public void translate(float f, float f2) {
        this.startPoint.x += f;
        this.startPoint.y += f2;
        this.endPoint.x += f;
        this.endPoint.y += f2;
    }

    public ShapePoint getMiddle() {
        return new ShapePoint((this.startPoint.x + this.endPoint.x) / 2.0f, (this.startPoint.y + this.endPoint.y) / 2.0f);
    }

    private int getType() {
        if (this.isVertical()) {
            return 1;
        }
        if (this.isHorizontal()) {
            return 0;
        }
        return 2;
    }

    public ShapePoint getEndPoint() {
        return this.endPoint;
    }

    public ShapePoint getStartPoint() {
        return this.startPoint;
    }

    public void setEndPoint(ShapePoint shapePoint) {
        this.endPoint = shapePoint;
    }

    public void setStartPoint(ShapePoint shapePoint) {
        this.startPoint = shapePoint;
    }

    public DiagramShape getOwner() {
        return this.owner;
    }

    public void setOwner(DiagramShape diagramShape) {
        this.owner = diagramShape;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShapeEdge)) {
            return false;
        }
        ShapeEdge shapeEdge = (ShapeEdge)object;
        if (this.startPoint.equals(shapeEdge.getStartPoint()) && this.endPoint.equals(shapeEdge.getEndPoint())) {
            return true;
        }
        return this.startPoint.equals(shapeEdge.getEndPoint()) && this.endPoint.equals(shapeEdge.getStartPoint());
    }

    public boolean touchesWith(ShapeEdge shapeEdge) {
        if (this.equals(shapeEdge)) {
            return true;
        }
        if (this.isHorizontal() && shapeEdge.isVertical()) {
            return false;
        }
        if (shapeEdge.isHorizontal() && this.isVertical()) {
            return false;
        }
        if (this.getDistanceFromOrigin() != shapeEdge.getDistanceFromOrigin()) {
            return false;
        }
        ShapeEdge shapeEdge2 = new ShapeEdge(this);
        ShapeEdge shapeEdge3 = new ShapeEdge(shapeEdge);
        if (shapeEdge2.isVertical()) {
            shapeEdge2.changeAxis();
            shapeEdge3.changeAxis();
        }
        shapeEdge2.fixDirection();
        shapeEdge3.fixDirection();
        if (shapeEdge2.startPoint.x > shapeEdge3.startPoint.x) {
            ShapeEdge shapeEdge4 = shapeEdge2;
            shapeEdge2 = shapeEdge3;
            shapeEdge3 = shapeEdge4;
        }
        if (shapeEdge2.endPoint.equals(shapeEdge3.startPoint)) {
            return false;
        }
        if (this.startPoint.isWithinEdge(shapeEdge) || this.endPoint.isWithinEdge(shapeEdge)) {
            return true;
        }
        return shapeEdge.startPoint.isWithinEdge(this) || shapeEdge.endPoint.isWithinEdge(this);
    }

    private void changeAxis() {
        ShapePoint shapePoint = new ShapePoint(this.startPoint);
        this.startPoint = new ShapePoint(this.endPoint.y, this.endPoint.x);
        this.endPoint = new ShapePoint(shapePoint.y, shapePoint.x);
    }

    private void fixDirection() {
        if (this.isHorizontal()) {
            if (this.startPoint.x > this.endPoint.x) {
                this.flipDirection();
            }
        } else if (this.isVertical()) {
            if (this.startPoint.y > this.endPoint.y) {
                this.flipDirection();
            }
        } else {
            throw new RuntimeException("Cannot fix direction of sloped egde");
        }
    }

    private void flipDirection() {
        ShapePoint shapePoint = this.startPoint;
        this.startPoint = this.endPoint;
        this.endPoint = shapePoint;
    }

    public boolean isHorizontal() {
        return this.startPoint.y == this.endPoint.y;
    }

    public boolean isVertical() {
        return this.startPoint.x == this.endPoint.x;
    }

    public String toString() {
        return this.startPoint + " -> " + this.endPoint;
    }
}

