/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.tukaani.xz.rangecoder;

import java.io.DataInputStream;
import java.io.IOException;
import znaishaded.org.tukaani.xz.CorruptedInputException;
import znaishaded.org.tukaani.xz.rangecoder.RangeDecoder;

public final class RangeDecoderFromBuffer
extends RangeDecoder {
    private static final int INIT_SIZE = 5;
    private final byte[] buf;
    private int pos = 0;
    private int end = 0;

    public RangeDecoderFromBuffer(int n) {
        this.buf = new byte[n - 5];
    }

    public void prepareInputBuffer(DataInputStream dataInputStream, int n) throws IOException {
        if (n < 5) {
            throw new CorruptedInputException();
        }
        if (dataInputStream.readUnsignedByte() != 0) {
            throw new CorruptedInputException();
        }
        this.code = dataInputStream.readInt();
        this.range = -1;
        this.pos = 0;
        this.end = n - 5;
        dataInputStream.readFully(this.buf, 0, this.end);
    }

    public boolean isInBufferOK() {
        return this.pos <= this.end;
    }

    public boolean isFinished() {
        return this.pos == this.end && this.code == 0;
    }

    public void normalize() throws IOException {
        if ((this.range & 0xFF000000) == 0) {
            try {
                this.code = this.code << 8 | this.buf[this.pos++] & 0xFF;
                this.range <<= 8;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new CorruptedInputException();
            }
        }
    }
}

