/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.storage;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.enterprise.landing.LandingDocEntriesProvider;
import org.testingisdocumenting.znai.enterprise.landing.LandingDocEntry;
import org.testingisdocumenting.znai.enterprise.storage.DocumentationFileBasedTimestamp;
import org.testingisdocumenting.znai.enterprise.storage.DocumentationStorage;
import org.testingisdocumenting.znai.fs.FsUtils;
import org.testingisdocumenting.znai.server.docpreparation.DocumentationPreparationProgress;
import org.testingisdocumenting.znai.structure.DocMeta;
import org.testingisdocumenting.znai.utils.FileUtils;

public class FileBasedDocumentationStorage
implements DocumentationStorage,
LandingDocEntriesProvider {
    public static final String META_FILE_NAME = "meta.json";
    private final Path storageRoot;
    private final Path docsRoot;
    private final Map<String, DocMeta> docMetaByDocId;

    public FileBasedDocumentationStorage(Path storageRoot, Path docsRootPath) {
        this.storageRoot = storageRoot;
        this.docsRoot = docsRootPath;
        this.docMetaByDocId = this.enumerateDocMetas();
    }

    @Override
    public boolean contains(String docId) {
        Path src = this.storageRoot.resolve(docId).resolve("");
        return Files.exists(src, new LinkOption[0]);
    }

    @Override
    public synchronized void store(String docId, String version, Path generatedDocumentation) {
        Path dest = this.storageRoot.resolve(docId).resolve(version);
        FsUtils.deleteDirectory(dest);
        FsUtils.copyDirectory(generatedDocumentation, dest);
        DocumentationFileBasedTimestamp.store(dest);
        this.docMetaByDocId.put(docId, new DocMeta(FileUtils.fileTextContent(generatedDocumentation.resolve(META_FILE_NAME))));
        ConsoleOutputs.out(new Object[]{"stored ", Color.WHITE, docId, Color.BLUE, " as ", Color.PURPLE, dest});
    }

    @Override
    public synchronized void prepare(String docId, String version, DocumentationPreparationProgress progress) {
        progress.reportProgress("Checking documentation", Collections.emptyMap(), 10);
        Path src = this.storageRoot.resolve(docId).resolve(version);
        Path tempDestRoot = this.creteTempDir();
        Path tempDest = tempDestRoot.resolve(docId).resolve(version);
        Path finalDest = this.docsRoot.resolve(docId).resolve(version);
        FsUtils.deleteDirectory(tempDest);
        FsUtils.copyDirectory(src, tempDest);
        progress.reportProgress("Moved documentation to a temporary location", Collections.emptyMap(), 40);
        progress.reportProgress("Moving documentation to a permanent location", Collections.emptyMap(), 80);
        FsUtils.deleteDirectory(finalDest);
        FsUtils.moveDirectory(tempDest, finalDest);
        FsUtils.deleteDirectory(tempDestRoot);
        progress.reportProgress("Moved documentation to a permanent location", Collections.emptyMap(), 100);
    }

    private Path creteTempDir() {
        try {
            return Files.createTempDirectory(this.docsRoot, "temp", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long lastUpdateTime(String docId, String version) {
        return DocumentationFileBasedTimestamp.read(this.storageRoot.resolve(docId).resolve(version));
    }

    @Override
    public Stream<LandingDocEntry> provide() {
        return this.docMetaByDocId.entrySet().stream().map(entry -> new LandingDocEntry((String)entry.getKey(), ((DocMeta)entry.getValue()).getTitle(), "", ((DocMeta)entry.getValue()).getCategory(), ((DocMeta)entry.getValue()).getDescription()));
    }

    private synchronized Map<String, DocMeta> enumerateDocMetas() {
        if (this.storageRoot == null || !Files.exists(this.storageRoot, new LinkOption[0])) {
            return new HashMap<String, DocMeta>();
        }
        try {
            return Files.list(this.storageRoot).filter(file -> Files.isDirectory(file, new LinkOption[0])).filter(file -> Files.exists(file.resolve(META_FILE_NAME), new LinkOption[0])).map(file -> file.resolve(META_FILE_NAME)).collect(Collectors.toMap(fileMeta -> fileMeta.getParent().getFileName().toString(), fileMeta -> new DocMeta(FileUtils.fileTextContent(fileMeta))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

