/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.upload;

import java.nio.file.Path;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.enterprise.EnterpriseComponentsRegistry;
import org.testingisdocumenting.znai.enterprise.upload.OnUploadFinishedServerHandler;
import org.testingisdocumenting.znai.fs.FsUtils;
import org.testingisdocumenting.znai.server.ZnaiServerConfig;

public class UnzipAndStoreOnUploadFinishedServerHandler
implements OnUploadFinishedServerHandler {
    @Override
    public void onUploadFinished(ZnaiServerConfig config, String docId, Path uploadedPath, String actor) {
        Path unzipDest = config.getDeployRoot().resolve(docId);
        ConsoleOutputs.out(new Object[]{Color.BLUE, "unzipping docs: ", Color.PURPLE, uploadedPath, Color.BLACK, " to ", Color.PURPLE, unzipDest});
        FsUtils.unzip(uploadedPath, unzipDest);
        ConsoleOutputs.out(new Object[]{Color.BLUE, "unzipped docs: ", Color.PURPLE, unzipDest});
        EnterpriseComponentsRegistry.documentationStorage().store(docId, "", unzipDest);
    }
}

