/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.ctreber.acearth.scanbit;

import java.util.Comparator;
import znaishaded.com.ctreber.acearth.projection.Projection;
import znaishaded.com.ctreber.acearth.scanbit.BitGeneratorMap;
import znaishaded.com.ctreber.acearth.scanbit.ScanBuf;
import znaishaded.com.ctreber.acearth.util.EdgeCrossing;
import znaishaded.com.ctreber.acearth.util.Point2D;
import znaishaded.com.ctreber.acearth.util.Point3D;

public class BitGeneratorMapDefault
extends BitGeneratorMap {
    public BitGeneratorMapDefault(Projection projection) {
        super(projection);
    }

    protected Comparator getEdgeXingComparator() {
        return new EdgeXingComparator();
    }

    protected ScanBuf scanOutline() {
        ScanBuf scanBuf = new ScanBuf(this.fImageHeight, this.fImageWidth);
        double d = this.fProjection.finalizeX(-Math.PI);
        double d2 = this.fProjection.finalizeX(Math.PI);
        double d3 = this.fProjection.finalizeY(1000000.0);
        double d4 = this.fProjection.finalizeY(-1000000.0);
        scanBuf.addLine(d2, d3, d, d3);
        scanBuf.addLine(d, d3, d, d4);
        scanBuf.addLine(d, d4, d2, d4);
        scanBuf.addLine(d2, d4, d2, d3);
        return scanBuf;
    }

    protected void scanPolygon(ScanBuf scanBuf, Point3D[] point3DArray, Point2D[] point2DArray, int n) {
        int n2;
        double d;
        Point2D point2D = point2DArray[n];
        int n3 = n - 1 >= 0 ? n - 1 : point2DArray.length - 1;
        Point2D point2D2 = point2DArray[n3];
        double d2 = point2D.getX() - point2D2.getX();
        if (Math.abs(d2) <= Math.PI) {
            scanBuf.addLine(this.fProjection.finalizeX(point2D2.getX()), this.fProjection.finalizeY(point2D2.getY()), this.fProjection.finalizeX(point2D.getX()), this.fProjection.finalizeY(point2D.getY()));
            return;
        }
        double d3 = this.getYMidPoint(point3DArray[n3], point3DArray[n]);
        if (d2 > 0.0) {
            d = -Math.PI;
            n2 = 2;
        } else {
            d = Math.PI;
            n2 = 0;
        }
        scanBuf.addLine(this.fProjection.finalizeX(point2D2.getX()), this.fProjection.finalizeY(point2D2.getY()), this.fProjection.finalizeX(d), this.fProjection.finalizeY(d3));
        this.addEdgeXing(new EdgeCrossing(1, n, d, d3, n2));
        if (d2 > 0.0) {
            d = Math.PI;
            n2 = 0;
        } else {
            d = -Math.PI;
            n2 = 2;
        }
        scanBuf.addLine(this.fProjection.finalizeX(d), this.fProjection.finalizeY(d3), this.fProjection.finalizeX(point2D.getX()), this.fProjection.finalizeY(point2D.getY()));
        this.addEdgeXing(new EdgeCrossing(0, n, d, d3, n2));
    }

    private double getYMidPoint(Point3D point3D, Point3D point3D2) {
        double d;
        double d2;
        double d3;
        if (point3D2.getX() != 0.0) {
            d3 = point3D.getX() / point3D2.getX();
            d2 = point3D.getY() - d3 * point3D2.getY();
            d = point3D.getZ() - d3 * point3D2.getZ();
        } else {
            d2 = point3D2.getY();
            d = point3D2.getZ();
        }
        d3 = Math.sqrt(d2 * d2 + d * d);
        return this.fProjection.projectY(d2 *= (double)(d > 0.0 ? -1 : 1) / d3);
    }

    protected void handleCrossings(ScanBuf scanBuf, EdgeCrossing[] edgeCrossingArray) {
        EdgeCrossing edgeCrossing;
        EdgeCrossing edgeCrossing2;
        int n;
        if (edgeCrossingArray[0].getType() == 1) {
            n = 0;
        } else {
            edgeCrossing2 = edgeCrossingArray[edgeCrossingArray.length - 1];
            edgeCrossing = edgeCrossingArray[0];
            this.addEdgeToScanbuf(scanBuf, edgeCrossing2, edgeCrossing);
            n = 1;
        }
        for (int i = n; i < edgeCrossingArray.length - 1; i += 2) {
            edgeCrossing2 = edgeCrossingArray[i];
            edgeCrossing = edgeCrossingArray[i + 1];
            this.addEdgeToScanbuf(scanBuf, edgeCrossing2, edgeCrossing);
        }
    }

    private void addEdgeToScanbuf(ScanBuf scanBuf, EdgeCrossing edgeCrossing, EdgeCrossing edgeCrossing2) {
        int n = (int)edgeCrossing.getAngle();
        double d = this.fProjection.finalizeX(edgeCrossing.getX());
        double d2 = this.fProjection.finalizeY(edgeCrossing.getY());
        while (n != (int)edgeCrossing2.getAngle()) {
            int n2 = 0;
            double d3 = 0.0;
            double d4 = 0.0;
            switch (n) {
                case 0: {
                    d3 = this.fProjection.finalizeX(Math.PI);
                    d4 = this.fProjection.finalizeY(1000000.0);
                    n2 = 1;
                    break;
                }
                case 1: {
                    d3 = this.fProjection.finalizeX(-Math.PI);
                    d4 = this.fProjection.finalizeY(1000000.0);
                    n2 = 2;
                    break;
                }
                case 2: {
                    d3 = this.fProjection.finalizeX(-Math.PI);
                    d4 = this.fProjection.finalizeY(-1000000.0);
                    n2 = 3;
                    break;
                }
                case 3: {
                    d3 = this.fProjection.finalizeX(Math.PI);
                    d4 = this.fProjection.finalizeY(-1000000.0);
                    n2 = 0;
                }
            }
            scanBuf.addLine(d, d2, d3, d4);
            n = n2;
            d = d3;
            d2 = d4;
        }
        scanBuf.addLine(d, d2, this.fProjection.finalizeX(edgeCrossing2.getX()), this.fProjection.finalizeY(edgeCrossing2.getY()));
    }

    private static class EdgeXingComparator
    implements Comparator {
        private EdgeXingComparator() {
        }

        public int compare(Object object, Object object2) {
            EdgeCrossing edgeCrossing = (EdgeCrossing)object;
            EdgeCrossing edgeCrossing2 = (EdgeCrossing)object2;
            if (edgeCrossing.getAngle() < edgeCrossing2.getAngle()) {
                return -1;
            }
            if (edgeCrossing.getAngle() > edgeCrossing2.getAngle()) {
                return 1;
            }
            if (edgeCrossing.getAngle() == 0.0) {
                return edgeCrossing.getY() < edgeCrossing2.getY() ? -1 : (edgeCrossing.getY() > edgeCrossing2.getY() ? 1 : 0);
            }
            if (edgeCrossing.getAngle() == 2.0) {
                return edgeCrossing.getY() > edgeCrossing2.getY() ? -1 : (edgeCrossing.getY() < edgeCrossing2.getY() ? 1 : 0);
            }
            throw new RuntimeException("No result");
        }
    }
}

