/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.fasterxml.jackson.databind.ObjectMapper;
import znaishaded.io.netty.util.CharsetUtil;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.VertxException;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.json.JsonArray;
import znaishaded.io.vertx.core.json.JsonObject;
import znaishaded.io.vertx.ext.web.RoutingContext;

public class Utils
extends znaishaded.io.vertx.core.impl.Utils {
    private static final Pattern COMMA_SPLITTER = Pattern.compile(" *, *");
    private static final Pattern SEMICOLON_SPLITTER = Pattern.compile(" *; *");
    private static final Pattern EQUAL_SPLITTER = Pattern.compile(" *= *");
    private static final Comparator<String> ACCEPT_X_COMPARATOR = new Comparator<String>(){

        float getQuality(String s) {
            if (s == null) {
                return 0.0f;
            }
            String[] params = SEMICOLON_SPLITTER.split(s);
            for (int i = 1; i < params.length; ++i) {
                String[] q = EQUAL_SPLITTER.split(params[1]);
                if (!"q".equals(q[0])) continue;
                return Float.parseFloat(q[1]);
            }
            return 1.0f;
        }

        @Override
        public int compare(String o1, String o2) {
            float f1 = this.getQuality(o1);
            float f2 = this.getQuality(o2);
            return Float.compare(f2, f1);
        }
    };

    private static int indexOfSlash(CharSequence str, int start) {
        for (int i = start; i < str.length(); ++i) {
            if (str.charAt(i) != '/') continue;
            return i;
        }
        return -1;
    }

    private static boolean matches(CharSequence path2, int start, String what) {
        return Utils.matches(path2, start, what, false);
    }

    private static boolean matches(CharSequence path2, int start, String what, boolean exact) {
        if (exact && path2.length() - start != what.length()) {
            return false;
        }
        if (path2.length() - start >= what.length()) {
            for (int i = 0; i < what.length(); ++i) {
                if (path2.charAt(start + i) == what.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static void decodeUnreserved(StringBuilder path2, int start) {
        if (start + 3 <= path2.length()) {
            int unescaped;
            String escapeSequence = path2.substring(start + 1, start + 3);
            try {
                unescaped = Integer.parseInt(escapeSequence, 16);
                if (unescaped < 0) {
                    throw new IllegalArgumentException("Invalid escape sequence: %" + escapeSequence);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid escape sequence: %" + escapeSequence);
            }
            if (unescaped >= 65 && unescaped <= 90 || unescaped >= 97 && unescaped <= 122 || unescaped >= 48 && unescaped <= 57 || unescaped == 45 || unescaped == 46 || unescaped == 95 || unescaped == 126) {
                path2.setCharAt(start, (char)unescaped);
                path2.delete(start + 1, start + 3);
            }
        } else {
            throw new IllegalArgumentException("Invalid position for escape character: " + start);
        }
    }

    public static String normalizePath(String pathname) {
        if (pathname == null || pathname.length() == 0) {
            return "/";
        }
        StringBuilder ibuf = new StringBuilder(pathname.length() + 1);
        if (pathname.charAt(0) != '/') {
            ibuf.append('/');
        }
        ibuf.append(pathname);
        for (int i = 0; i < ibuf.length(); ++i) {
            if (ibuf.charAt(i) != '%') continue;
            Utils.decodeUnreserved(ibuf, i);
        }
        return Utils.removeDots(ibuf);
    }

    public static String removeDots(CharSequence path2) {
        if (path2 == null) {
            return null;
        }
        StringBuilder obuf = new StringBuilder(path2.length());
        int i = 0;
        while (i < path2.length()) {
            int pos;
            if (Utils.matches(path2, i, "./")) {
                i += 2;
                continue;
            }
            if (Utils.matches(path2, i, "../")) {
                i += 3;
                continue;
            }
            if (Utils.matches(path2, i, "/./")) {
                i += 2;
                continue;
            }
            if (Utils.matches(path2, i, "/.", true)) {
                path2 = "/";
                i = 0;
                continue;
            }
            if (Utils.matches(path2, i, "/../")) {
                i += 3;
                pos = obuf.lastIndexOf("/");
                if (pos == -1) continue;
                obuf.delete(pos, obuf.length());
                continue;
            }
            if (Utils.matches(path2, i, "/..", true)) {
                path2 = "/";
                i = 0;
                pos = obuf.lastIndexOf("/");
                if (pos == -1) continue;
                obuf.delete(pos, obuf.length());
                continue;
            }
            if (Utils.matches(path2, i, ".", true) || Utils.matches(path2, i, "..", true)) break;
            if (path2.charAt(i) == '/') {
                ++i;
                if (obuf.length() == 0 || obuf.charAt(obuf.length() - 1) != '/') {
                    obuf.append('/');
                }
            }
            if ((pos = Utils.indexOfSlash(path2, i)) != -1) {
                obuf.append(path2, i, pos);
                i = pos;
                continue;
            }
            obuf.append(path2, i, path2.length());
            break;
        }
        return obuf.toString();
    }

    public static String urlDecode(String s, boolean plus) {
        if (s == null) {
            return null;
        }
        int size = s.length();
        boolean modified = false;
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            if (c != '%' && (!plus || c != '+')) continue;
            modified = true;
            break;
        }
        if (!modified) {
            return s;
        }
        byte[] buf = new byte[size];
        int pos = 0;
        for (int i = 0; i < size; ++i) {
            int c = s.charAt(i);
            if (c == 37) {
                if (i == size - 1) {
                    throw new IllegalArgumentException("unterminated escape sequence at end of string: " + s);
                }
                if ((c = (int)s.charAt(++i)) == 37) {
                    buf[pos++] = 37;
                    break;
                }
                if (i == size - 1) {
                    throw new IllegalArgumentException("partial escape sequence at end of string: " + s);
                }
                c = Utils.decodeHexNibble((char)c);
                char c2 = Utils.decodeHexNibble(s.charAt(++i));
                if (c == 65535 || c2 == '\uffff') {
                    throw new IllegalArgumentException("invalid escape sequence `%" + s.charAt(i - 1) + s.charAt(i) + "' at index " + (i - 2) + " of: " + s);
                }
                c = (char)(c * 16 + c2);
                buf[pos++] = (byte)c;
                continue;
            }
            buf[pos++] = (byte)(plus && c == 43 ? 32 : c);
        }
        return new String(buf, 0, pos, CharsetUtil.UTF_8);
    }

    private static char decodeHexNibble(char c) {
        if ('0' <= c && c <= '9') {
            return (char)(c - 48);
        }
        if ('a' <= c && c <= 'f') {
            return (char)(c - 97 + 10);
        }
        if ('A' <= c && c <= 'F') {
            return (char)(c - 65 + 10);
        }
        return '\uffff';
    }

    public static ClassLoader getClassLoader() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return tccl == null ? Utils.class.getClassLoader() : tccl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Buffer readResourceToBuffer(String resource) {
        ClassLoader cl = Utils.getClassLoader();
        try {
            Buffer buffer = Buffer.buffer();
            try (InputStream in = cl.getResourceAsStream(resource);){
                int read;
                if (in == null) {
                    Buffer buffer2 = null;
                    return buffer2;
                }
                byte[] data = new byte[4096];
                while ((read = in.read(data, 0, data.length)) != -1) {
                    if (read == data.length) {
                        buffer.appendBytes(data);
                        continue;
                    }
                    byte[] slice = new byte[read];
                    System.arraycopy(data, 0, slice, 0, slice.length);
                    buffer.appendBytes(slice);
                }
                return buffer;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static String readFileToString(Vertx vertx, String resource) {
        return Utils.readFileToString(vertx, resource, StandardCharsets.UTF_8);
    }

    public static String readFileToString(Vertx vertx, String resource, Charset charset) {
        try {
            Buffer buff = vertx.fileSystem().readFileBlocking(resource);
            return buff.toString(charset);
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }

    public static DateFormat createRFC1123DateTimeFormatter() {
        SimpleDateFormat dtf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);
        dtf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dtf;
    }

    public static String pathOffset(String path2, RoutingContext context) {
        String routePath;
        int prefixLen = 0;
        String mountPoint = context.mountPoint();
        if (mountPoint != null) {
            prefixLen = mountPoint.length();
        }
        if ((routePath = context.currentRoute().getPath()) != null) {
            prefixLen += routePath.length();
            if (routePath.charAt(routePath.length() - 1) == '/') {
                --prefixLen;
            }
        }
        return prefixLen != 0 ? path2.substring(prefixLen) : path2;
    }

    public static long secondsFactor(long millis) {
        return millis - millis % 1000L;
    }

    public static JsonNode toJsonNode(String object) {
        try {
            return new ObjectMapper().readTree(object);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JsonNode toJsonNode(JsonObject object) {
        try {
            return new ObjectMapper().readTree(object.encode());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JsonObject toJsonObject(JsonNode node) {
        return new JsonObject(node.toString());
    }

    public static JsonArray toJsonArray(JsonNode node) {
        return new JsonArray(node.toString());
    }

    public static Object toVertxJson(JsonNode node) {
        if (node.isArray()) {
            return Utils.toJsonArray(node);
        }
        if (node.isObject()) {
            return Utils.toJsonObject(node);
        }
        return node.toString();
    }

    public static boolean isJsonContentType(String contentType) {
        return contentType.contains("application/json") || contentType.contains("+json");
    }

    public static boolean isXMLContentType(String contentType) {
        return contentType.contains("application/xml") || contentType.contains("text/xml") || contentType.contains("+xml");
    }
}

