/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.bpm;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileBox;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileCircleStart;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import znaishaded.net.sourceforge.plantuml.bpm.AbstractConnectorPuzzle;
import znaishaded.net.sourceforge.plantuml.bpm.BpmElementType;
import znaishaded.net.sourceforge.plantuml.bpm.ConnectorPuzzle;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorUtils;
import znaishaded.net.sourceforge.plantuml.graphic.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class BpmElement
extends AbstractConnectorPuzzle
implements ConnectorPuzzle {
    private final String id;
    private final BpmElementType type;
    private final Display display;
    private Dimension2D dimension;

    public BpmElement(String string, BpmElementType bpmElementType, String string2) {
        this.id = string;
        this.type = bpmElementType;
        this.display = Display.getWithNewlines(string2);
    }

    public BpmElement(String string, BpmElementType bpmElementType) {
        this(string, bpmElementType, null);
    }

    public String toString() {
        if (this.id == null) {
            return this.type.toString() + "(" + this.display + ")";
        }
        return this.type.toString() + "(" + this.id + ")";
    }

    public BpmElementType getType() {
        return this.type;
    }

    public final Display getDisplay() {
        return this.display;
    }

    public TextBlock toTextBlock(ISkinParam iSkinParam) {
        final TextBlock textBlock = this.toTextBlockInternal(iSkinParam);
        return new TextBlock(){

            public void drawU(UGraphic uGraphic) {
                textBlock.drawU(uGraphic);
                uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.RED));
                for (ConnectorPuzzle.Where where : ConnectorPuzzle.Where.values()) {
                    if (!BpmElement.this.have(where)) continue;
                    BpmElement.this.drawLine(uGraphic, where, textBlock.calculateDimension(uGraphic.getStringBounder()));
                }
            }

            public Rectangle2D getInnerPosition(String string, StringBounder stringBounder, InnerStrategy innerStrategy) {
                return textBlock.getInnerPosition(string, stringBounder, innerStrategy);
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return textBlock.calculateDimension(stringBounder);
            }
        };
    }

    private void drawLine(UGraphic uGraphic, ConnectorPuzzle.Where where, Dimension2D dimension2D) {
        double d = dimension2D.getWidth();
        double d2 = dimension2D.getHeight();
        if (where == ConnectorPuzzle.Where.WEST) {
            uGraphic.apply(new UTranslate(-10.0, d2 / 2.0)).draw(new ULine(10.0, 0.0));
        }
        if (where == ConnectorPuzzle.Where.EAST) {
            uGraphic.apply(new UTranslate(d, d2 / 2.0)).draw(new ULine(10.0, 0.0));
        }
        if (where == ConnectorPuzzle.Where.NORTH) {
            uGraphic.apply(new UTranslate(d / 2.0, -10.0)).draw(new ULine(0.0, 10.0));
        }
        if (where == ConnectorPuzzle.Where.SOUTH) {
            uGraphic.apply(new UTranslate(d / 2.0, d2)).draw(new ULine(0.0, 10.0));
        }
    }

    public TextBlock toTextBlockInternal(ISkinParam iSkinParam) {
        if (this.type == BpmElementType.START) {
            return new FtileCircleStart(iSkinParam, HtmlColorUtils.BLACK, null);
        }
        if (this.type == BpmElementType.MERGE) {
            HtmlColor htmlColor = SkinParamUtils.getColor(iSkinParam, ColorParam.activityBorder, null);
            HtmlColor htmlColor2 = SkinParamUtils.getColor(iSkinParam, ColorParam.activityBackground, null);
            return new FtileDiamond(iSkinParam, htmlColor2, htmlColor, null);
        }
        if (this.type == BpmElementType.DOCKED_EVENT) {
            UFont uFont = UFont.serif(14);
            return new FtileBox(iSkinParam, this.display, uFont, null, BoxStyle.PLAIN);
        }
        UFont uFont = UFont.serif(14);
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.RED, HtmlColorUtils.RED, false);
        if (Display.isNull(this.display)) {
            return Display.getWithNewlines(this.type.toString()).create(fontConfiguration, HorizontalAlignment.LEFT, iSkinParam);
        }
        return this.display.create(fontConfiguration, HorizontalAlignment.LEFT, iSkinParam);
    }

    public Dimension2D getDimension(StringBounder stringBounder, ISkinParam iSkinParam) {
        if (this.dimension == null) {
            this.dimension = this.toTextBlock(iSkinParam).calculateDimension(stringBounder);
        }
        return this.dimension;
    }

    public final String getId() {
        return this.id;
    }
}

