/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.bpm;

import znaishaded.net.sourceforge.plantuml.bpm.BpmElement;
import znaishaded.net.sourceforge.plantuml.bpm.Cell;
import znaishaded.net.sourceforge.plantuml.bpm.Col;
import znaishaded.net.sourceforge.plantuml.bpm.ConnectorPuzzle;
import znaishaded.net.sourceforge.plantuml.bpm.ConnectorPuzzleEmpty;
import znaishaded.net.sourceforge.plantuml.bpm.Grid;
import znaishaded.net.sourceforge.plantuml.bpm.GridCleaner;
import znaishaded.net.sourceforge.plantuml.bpm.Line;
import znaishaded.net.sourceforge.plantuml.bpm.Placeable;

public class CleanerInterleavingLines
implements GridCleaner {
    public boolean clean(Grid grid) {
        boolean bl = false;
        Line line = null;
        for (Line line2 : grid.lines().toList()) {
            if (line != null && this.mergeable(grid, line, line2)) {
                this.mergeLines(grid, line, line2);
                return true;
            }
            line = line2;
        }
        return bl;
    }

    private void mergeLines(Grid grid, Line line, Line line2) {
        for (Col col : grid.cols().toList()) {
            Cell cell2 = grid.getCell(line, col);
            Cell cell3 = grid.getCell(line2, col);
            cell2.setData(this.merge(cell2.getData(), cell3.getData()));
            cell3.setData(null);
        }
        grid.removeLine(line2);
    }

    private boolean mergeable(Grid grid, Line line, Line line2) {
        for (Col col : grid.cols().toList()) {
            Placeable placeable;
            Placeable placeable2 = grid.getCell(line, col).getData();
            if (this.mergeable(placeable2, placeable = grid.getCell(line2, col).getData())) continue;
            return false;
        }
        return true;
    }

    private Placeable merge(Placeable placeable, Placeable placeable2) {
        if (placeable == null) {
            return placeable2;
        }
        if (placeable2 == null) {
            return placeable;
        }
        assert (placeable != null && placeable2 != null);
        if (placeable instanceof BpmElement) {
            return placeable;
        }
        if (placeable2 instanceof BpmElement) {
            ConnectorPuzzleEmpty connectorPuzzleEmpty = (ConnectorPuzzleEmpty)placeable;
            if (connectorPuzzleEmpty.checkDirections("SW")) {
                ((BpmElement)placeable2).remove(ConnectorPuzzle.Where.NORTH);
                ((BpmElement)placeable2).append(ConnectorPuzzle.Where.WEST);
            }
            return placeable2;
        }
        assert (placeable instanceof ConnectorPuzzleEmpty && placeable2 instanceof ConnectorPuzzleEmpty);
        ConnectorPuzzleEmpty connectorPuzzleEmpty = (ConnectorPuzzleEmpty)placeable;
        ConnectorPuzzleEmpty connectorPuzzleEmpty2 = (ConnectorPuzzleEmpty)placeable2;
        return connectorPuzzleEmpty2;
    }

    private boolean mergeable(Placeable placeable, Placeable placeable2) {
        if (placeable == null || placeable2 == null) {
            return true;
        }
        assert (placeable != null && placeable2 != null);
        if (placeable instanceof ConnectorPuzzleEmpty && placeable2 instanceof ConnectorPuzzleEmpty) {
            return this.mergeableCC((ConnectorPuzzleEmpty)placeable, (ConnectorPuzzleEmpty)placeable2);
        }
        if (placeable instanceof ConnectorPuzzleEmpty && placeable2 instanceof BpmElement) {
            boolean bl = this.mergeablePuzzleSingle((ConnectorPuzzleEmpty)placeable, (BpmElement)placeable2);
            return bl;
        }
        if (placeable2 instanceof ConnectorPuzzleEmpty && placeable instanceof BpmElement) {
            boolean bl = this.mergeablePuzzleSingle((BpmElement)placeable, (ConnectorPuzzleEmpty)placeable2);
            return bl;
        }
        return false;
    }

    private boolean mergeablePuzzleSingle(ConnectorPuzzleEmpty connectorPuzzleEmpty, BpmElement bpmElement) {
        if (connectorPuzzleEmpty.checkDirections("NS")) {
            return true;
        }
        return connectorPuzzleEmpty.checkDirections("SW");
    }

    private boolean mergeablePuzzleSingle(BpmElement bpmElement, ConnectorPuzzleEmpty connectorPuzzleEmpty) {
        return connectorPuzzleEmpty.checkDirections("NS");
    }

    private boolean mergeableCC(ConnectorPuzzleEmpty connectorPuzzleEmpty, ConnectorPuzzleEmpty connectorPuzzleEmpty2) {
        if (connectorPuzzleEmpty.checkDirections("NS") && connectorPuzzleEmpty2.checkDirections("NS")) {
            return true;
        }
        if (connectorPuzzleEmpty.checkDirections("NS") && connectorPuzzleEmpty2.checkDirections("NE")) {
            return true;
        }
        return connectorPuzzleEmpty.checkDirections("NS") && connectorPuzzleEmpty2.checkDirections("NW");
    }
}

