/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandControl;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.core.Diagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandMultilinesBracket<S extends Diagram>
implements Command<S> {
    private final Pattern2 starting;

    public CommandMultilinesBracket(String string) {
        if (!string.startsWith("(?i)^") || !string.endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + string);
        }
        this.starting = MyPattern.cmpile(string);
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"BRACKET: " + this.starting.pattern()};
    }

    protected void actionIfCommandValid() {
    }

    protected final Pattern2 getStartingPattern() {
        return this.starting;
    }

    @Override
    public final CommandControl isValid(BlocLines blocLines) {
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        Matcher2 matcher2 = this.starting.matcher(StringUtils.trin(blocLines.getFirst499()));
        if (!matcher2.matches()) {
            return CommandControl.NOT_OK;
        }
        if (blocLines.size() == 1) {
            return CommandControl.OK_PARTIAL;
        }
        int n = 1;
        for (CharSequence charSequence : blocLines.subExtract(1, 0)) {
            String string = StringUtils.trin(charSequence);
            if (!this.isLineConsistent(string, n)) {
                return CommandControl.NOT_OK;
            }
            if (string.endsWith("{")) {
                ++n;
            }
            if (string.endsWith("}")) {
                --n;
            }
            if (n >= 0) continue;
            return CommandControl.NOT_OK;
        }
        if (n != 0) {
            return CommandControl.OK_PARTIAL;
        }
        this.actionIfCommandValid();
        return CommandControl.OK;
    }

    protected abstract boolean isLineConsistent(String var1, int var2);
}

