/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import znaishaded.net.sourceforge.plantuml.graph.SortedCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedCollectionLinked<S extends Comparable<S>>
implements SortedCollection<S> {
    private final List<S> all = new LinkedList<S>();

    @Override
    public Iterator<S> iterator() {
        return this.all.iterator();
    }

    @Override
    public void add(S s) {
        ListIterator<S> listIterator = this.all.listIterator();
        while (listIterator.hasNext()) {
            Comparable comparable = (Comparable)listIterator.next();
            if (comparable.compareTo(s) < 0) continue;
            listIterator.previous();
            listIterator.add(s);
            assert (this.isSorted());
            return;
        }
        this.all.add(s);
        assert (this.isSorted());
    }

    @Override
    public int size() {
        return this.all.size();
    }

    List<S> toList() {
        return new ArrayList<S>(this.all);
    }

    boolean isSorted() {
        Comparable comparable = null;
        for (Comparable comparable2 : this.all) {
            if (comparable != null && comparable2.compareTo(comparable) < 0) {
                return false;
            }
            comparable = comparable2;
        }
        return true;
    }

    @Override
    public boolean contains(S s) {
        return this.all.contains(s);
    }
}

