/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.skin;

import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.skin.ArrowBody;
import znaishaded.net.sourceforge.plantuml.skin.ArrowDecoration;
import znaishaded.net.sourceforge.plantuml.skin.ArrowDirection;
import znaishaded.net.sourceforge.plantuml.skin.ArrowDressing;
import znaishaded.net.sourceforge.plantuml.skin.ArrowHead;
import znaishaded.net.sourceforge.plantuml.skin.ArrowPart;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;

public class ArrowConfiguration {
    private final ArrowBody body;
    private final ArrowDressing dressing1;
    private final ArrowDressing dressing2;
    private final ArrowDecoration decoration1;
    private final ArrowDecoration decoration2;
    private final HtmlColor color;
    private final boolean isSelf;
    private final double thickness;

    private ArrowConfiguration(ArrowBody arrowBody, ArrowDressing arrowDressing, ArrowDressing arrowDressing2, ArrowDecoration arrowDecoration, ArrowDecoration arrowDecoration2, HtmlColor htmlColor, boolean bl, double d) {
        if (arrowBody == null || arrowDressing == null || arrowDressing2 == null) {
            throw new IllegalArgumentException();
        }
        this.thickness = d;
        this.body = arrowBody;
        this.dressing1 = arrowDressing;
        this.dressing2 = arrowDressing2;
        this.decoration1 = arrowDecoration;
        this.decoration2 = arrowDecoration2;
        this.color = htmlColor;
        this.isSelf = bl;
    }

    public String toString() {
        return this.name();
    }

    public String name() {
        return this.body.name() + "(" + this.dressing1.name() + " " + (Object)((Object)this.decoration1) + ")(" + this.dressing2.name() + " " + (Object)((Object)this.decoration2) + ")" + this.isSelf + " " + this.color;
    }

    public static ArrowConfiguration withDirectionNormal() {
        return new ArrowConfiguration(ArrowBody.NORMAL, ArrowDressing.create(), ArrowDressing.create().withHead(ArrowHead.NORMAL), ArrowDecoration.NONE, ArrowDecoration.NONE, null, false, 1.0);
    }

    public static ArrowConfiguration withDirectionBoth() {
        return new ArrowConfiguration(ArrowBody.NORMAL, ArrowDressing.create().withHead(ArrowHead.NORMAL), ArrowDressing.create().withHead(ArrowHead.NORMAL), ArrowDecoration.NONE, ArrowDecoration.NONE, null, false, 1.0);
    }

    public static ArrowConfiguration withDirectionSelf() {
        return new ArrowConfiguration(ArrowBody.NORMAL, ArrowDressing.create().withHead(ArrowHead.NORMAL), ArrowDressing.create().withHead(ArrowHead.NORMAL), ArrowDecoration.NONE, ArrowDecoration.NONE, null, true, 1.0);
    }

    public static ArrowConfiguration withDirectionReverse() {
        return ArrowConfiguration.withDirectionNormal().reverse();
    }

    public ArrowConfiguration reverse() {
        return new ArrowConfiguration(this.body, this.dressing2, this.dressing1, this.decoration2, this.decoration1, this.color, this.isSelf, this.thickness);
    }

    public ArrowConfiguration self() {
        return new ArrowConfiguration(this.body, this.dressing1, this.dressing2, this.decoration1, this.decoration2, this.color, true, this.thickness);
    }

    public ArrowConfiguration withBody(ArrowBody arrowBody) {
        return new ArrowConfiguration(arrowBody, this.dressing1, this.dressing2, this.decoration1, this.decoration2, this.color, this.isSelf, this.thickness);
    }

    public ArrowConfiguration withHead(ArrowHead arrowHead) {
        ArrowDressing arrowDressing = ArrowConfiguration.addHead(this.dressing1, arrowHead);
        ArrowDressing arrowDressing2 = ArrowConfiguration.addHead(this.dressing2, arrowHead);
        return new ArrowConfiguration(this.body, arrowDressing, arrowDressing2, this.decoration1, this.decoration2, this.color, this.isSelf, this.thickness);
    }

    private static ArrowDressing addHead(ArrowDressing arrowDressing, ArrowHead arrowHead) {
        if (arrowDressing.getHead() == ArrowHead.NONE) {
            return arrowDressing;
        }
        return arrowDressing.withHead(arrowHead);
    }

    public ArrowConfiguration withHead1(ArrowHead arrowHead) {
        return new ArrowConfiguration(this.body, this.dressing1.withHead(arrowHead), this.dressing2, this.decoration1, this.decoration2, this.color, this.isSelf, this.thickness);
    }

    public ArrowConfiguration withHead2(ArrowHead arrowHead) {
        return new ArrowConfiguration(this.body, this.dressing1, this.dressing2.withHead(arrowHead), this.decoration1, this.decoration2, this.color, this.isSelf, this.thickness);
    }

    public ArrowConfiguration withPart(ArrowPart arrowPart) {
        if (this.dressing2.getHead() != ArrowHead.NONE) {
            return new ArrowConfiguration(this.body, this.dressing1, this.dressing2.withPart(arrowPart), this.decoration1, this.decoration2, this.color, this.isSelf, this.thickness);
        }
        return new ArrowConfiguration(this.body, this.dressing1.withPart(arrowPart), this.dressing2, this.decoration1, this.decoration2, this.color, this.isSelf, this.thickness);
    }

    public ArrowConfiguration withDecoration1(ArrowDecoration arrowDecoration) {
        return new ArrowConfiguration(this.body, this.dressing1, this.dressing2, arrowDecoration, this.decoration2, this.color, this.isSelf, this.thickness);
    }

    public ArrowConfiguration withDecoration2(ArrowDecoration arrowDecoration) {
        return new ArrowConfiguration(this.body, this.dressing1, this.dressing2, this.decoration1, arrowDecoration, this.color, this.isSelf, this.thickness);
    }

    public ArrowConfiguration withColor(HtmlColor htmlColor) {
        return new ArrowConfiguration(this.body, this.dressing1, this.dressing2, this.decoration1, this.decoration2, htmlColor, this.isSelf, this.thickness);
    }

    public final ArrowDecoration getDecoration1() {
        return this.decoration1;
    }

    public final ArrowDecoration getDecoration2() {
        return this.decoration2;
    }

    public final ArrowDirection getArrowDirection() {
        if (this.isSelf) {
            return ArrowDirection.SELF;
        }
        if (this.dressing1.getHead() == ArrowHead.NONE && this.dressing2.getHead() != ArrowHead.NONE) {
            return ArrowDirection.LEFT_TO_RIGHT_NORMAL;
        }
        if (this.dressing1.getHead() != ArrowHead.NONE && this.dressing2.getHead() == ArrowHead.NONE) {
            return ArrowDirection.RIGHT_TO_LEFT_REVERSE;
        }
        return ArrowDirection.BOTH_DIRECTION;
    }

    public boolean isSelfArrow() {
        return this.getArrowDirection() == ArrowDirection.SELF;
    }

    public boolean isDotted() {
        return this.body == ArrowBody.DOTTED;
    }

    public boolean isHidden() {
        return this.body == ArrowBody.HIDDEN;
    }

    public ArrowHead getHead() {
        if (this.dressing2 != null && this.dressing2.getHead() != ArrowHead.NONE) {
            return this.dressing2.getHead();
        }
        return this.dressing1.getHead();
    }

    public boolean isAsync() {
        return this.dressing1.getHead() == ArrowHead.ASYNC || this.dressing2.getHead() == ArrowHead.ASYNC;
    }

    public final ArrowPart getPart() {
        if (this.dressing2.getHead() != ArrowHead.NONE) {
            return this.dressing2.getPart();
        }
        return this.dressing1.getPart();
    }

    public HtmlColor getColor() {
        return this.color;
    }

    public ArrowDressing getDressing1() {
        return this.dressing1;
    }

    public ArrowDressing getDressing2() {
        return this.dressing2;
    }

    public static UGraphic stroke(UGraphic uGraphic, double d, double d2, double d3) {
        return uGraphic.apply(new UStroke(d, d2, d3));
    }

    public UGraphic applyStroke(UGraphic uGraphic) {
        if (this.isDotted()) {
            return uGraphic.apply(new UStroke(2.0, 2.0, this.thickness));
        }
        return uGraphic.apply(new UStroke(this.thickness));
    }

    public UGraphic applyThicknessOnly(UGraphic uGraphic) {
        return uGraphic.apply(new UStroke(this.thickness));
    }

    public ArrowConfiguration withThickness(double d) {
        return new ArrowConfiguration(this.body, this.dressing1, this.dressing2, this.decoration1, this.decoration2, this.color, this.isSelf, d);
    }
}

