/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.stats;

import java.io.PrintStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;

public class TextTable {
    private static final DateFormat formatter = DateFormat.getDateTimeInstance(3, 2);
    private final List<TextLine> lines = new ArrayList<TextLine>();

    public void addLine(Object ... objectArray) {
        this.lines.add(new DataLine(objectArray));
    }

    public void addSeparator() {
        this.lines.add(new Separator());
    }

    private int[] getColsWidth() {
        int[] nArray = new int[this.getNbCols()];
        for (int i = 0; i < nArray.length; ++i) {
            for (TextLine textLine : this.lines) {
                nArray[i] = Math.max(nArray[i], textLine.getPreferredWidth(i));
            }
        }
        return nArray;
    }

    private int getNbCols() {
        int n = 0;
        for (TextLine textLine : this.lines) {
            n = Math.max(n, textLine.nbCols());
        }
        return n;
    }

    public void printMe(PrintStream printStream) {
        int[] nArray = this.getColsWidth();
        for (TextLine textLine : this.lines) {
            String string = textLine.getPrinted(nArray);
            printStream.println(string);
        }
    }

    public int getLines() {
        return this.lines.size();
    }

    static class DataLine
    implements TextLine {
        private final Object[] cells;

        private DataLine(Object[] objectArray) {
            this.cells = objectArray;
        }

        public int nbCols() {
            return this.cells.length;
        }

        public int getPreferredWidth(int n) {
            if (n < this.cells.length) {
                return this.formatMe(this.cells[n], 0).length();
            }
            return 0;
        }

        public String getPrinted(int[] nArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < nArray.length; ++i) {
                stringBuilder.append('|');
                Object object = this.cells[i];
                stringBuilder.append(' ');
                stringBuilder.append(this.formatMe(object, nArray[i]));
                stringBuilder.append(' ');
            }
            stringBuilder.append('|');
            return stringBuilder.toString();
        }

        private String formatMe(Object object, int n) {
            StringBuilder stringBuilder = new StringBuilder();
            HorizontalAlignment horizontalAlignment = HorizontalAlignment.CENTER;
            if (object instanceof Long) {
                String string = String.format("%,d", object).replaceAll("\u00a0", " ");
                stringBuilder.append(string);
                horizontalAlignment = HorizontalAlignment.RIGHT;
            } else if (object instanceof Date) {
                stringBuilder.append(formatter.format(object));
            } else if (object != null) {
                stringBuilder.append(object.toString());
            }
            while (stringBuilder.length() < n) {
                if (horizontalAlignment == HorizontalAlignment.RIGHT) {
                    stringBuilder.insert(0, " ");
                } else {
                    stringBuilder.append(" ");
                }
                if (horizontalAlignment != HorizontalAlignment.CENTER || stringBuilder.length() >= n) continue;
                stringBuilder.insert(0, " ");
            }
            return stringBuilder.toString();
        }
    }

    static class Separator
    implements TextLine {
        Separator() {
        }

        public int nbCols() {
            return 0;
        }

        public int getPreferredWidth(int n) {
            return 0;
        }

        public String getPrinted(int[] nArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int n : nArray) {
                stringBuilder.append('+');
                for (int i = 0; i < n + 2; ++i) {
                    stringBuilder.append('-');
                }
            }
            stringBuilder.append('+');
            return stringBuilder.toString();
        }
    }

    static interface TextLine {
        public int nbCols();

        public int getPreferredWidth(int var1);

        public String getPrinted(int[] var1);
    }
}

