/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sudoku;

import java.util.Random;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.sudoku.DLXEngine;
import znaishaded.net.sourceforge.plantuml.sudoku.ISudoku;

public class SudokuDLX
implements ISudoku {
    private final String[] tab;
    private final long seed;
    private final long rate;

    public SudokuDLX(Long l) {
        this.seed = l == null ? Math.abs(new Random().nextLong()) : Math.abs(l);
        DLXEngine dLXEngine = new DLXEngine(new Random(this.seed));
        String string = dLXEngine.generate(10000, 100000);
        this.rate = dLXEngine.rate(string.replace("\n", "").trim());
        this.tab = string.split("\\s");
    }

    public long getRatting() {
        return this.rate;
    }

    public long getSeed() {
        return this.seed;
    }

    public int getGiven(int n, int n2) {
        char c = this.tab[n].charAt(n2);
        if (c == '.') {
            return 0;
        }
        return c - 48;
    }

    public void print() {
        for (String string : this.tab) {
            Log.println(string);
        }
        Log.println("Rate=" + this.rate);
        Log.println("Seed=" + StringUtils.goUpperCase(Long.toString(this.seed, 36)));
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < 1; ++i) {
            SudokuDLX sudokuDLX = new SudokuDLX(null);
            sudokuDLX.print();
        }
    }
}

