/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svg;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.StringUtils;

public final class SvgData {
    private String svg;
    private double startX;
    private double startY;
    private double width;
    private double height;

    public static SvgData fromGraphViz(String string) {
        return new SvgData(SvgData.removeSvgXmlHeader1(string));
    }

    private SvgData(String string) {
        this.svg = string;
        this.init();
    }

    private SvgData() {
    }

    private static String removeSvgXmlHeader1(String string) {
        string = string.replaceFirst("(?i)<svg[^>]*>", "<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">");
        return string;
    }

    public SvgData mutateFromSvgTitler(String string, double d, double d2) {
        SvgData svgData = new SvgData();
        svgData.svg = string;
        svgData.startX = this.startX - d2 / 2.0;
        svgData.startY = this.startY;
        svgData.width = this.width + d2;
        svgData.height = this.height + d;
        return svgData;
    }

    public final String getSvg() {
        return this.modifiedSvgXmlHeader();
    }

    private void init() {
        Pattern pattern = Pattern.compile("(?i)<polygon\\s+[^>]*points=\"([^\"]+)\"");
        Matcher matcher = pattern.matcher(this.svg);
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        double d4 = -1.7976931348623157E308;
        if (!matcher.find()) {
            return;
        }
        String string = matcher.group(1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
            double d5 = Double.parseDouble(StringUtils.trin(stringTokenizer2.nextToken()));
            double d6 = Double.parseDouble(StringUtils.trin(stringTokenizer2.nextToken()));
            if (d5 < d) {
                d = d5;
            }
            if (d6 < d2) {
                d2 = d6;
            }
            if (d5 > d3) {
                d3 = d5;
            }
            if (!(d6 > d4)) continue;
            d4 = d6;
        }
        this.width = d3 - d;
        this.height = d4 - d2;
    }

    private String modifiedSvgXmlHeader() {
        StringBuilder stringBuilder = new StringBuilder("<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" ");
        stringBuilder.append("style=\"width:");
        stringBuilder.append(Math.round(this.getWidth()));
        stringBuilder.append(";height:");
        stringBuilder.append(Math.round(this.getHeight()));
        stringBuilder.append(";\" ");
        stringBuilder.append("width=\"" + Math.round(this.getWidth()) + "pt\" ");
        stringBuilder.append("height=\"" + Math.round(this.getHeight()) + "pt\" ");
        stringBuilder.append("viewBox=\"" + Math.round(this.startX) + " " + Math.round(this.startY) + " " + Math.round(this.getWidth()) + " " + Math.round(this.getHeight()) + "\"");
        stringBuilder.append(">");
        return this.svg.replaceFirst("(?i)<svg[^>]*>", stringBuilder.toString());
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }
}

