/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.ant.compress.taskdefs;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipException;
import znaishaded.org.apache.ant.compress.resources.ArFileSet;
import znaishaded.org.apache.ant.compress.resources.CommonsCompressArchiveResource;
import znaishaded.org.apache.ant.compress.resources.CpioFileSet;
import znaishaded.org.apache.ant.compress.resources.SevenZResource;
import znaishaded.org.apache.ant.compress.resources.TarFileSet;
import znaishaded.org.apache.ant.compress.resources.ZipResource;
import znaishaded.org.apache.ant.compress.util.ArchiveStreamFactory;
import znaishaded.org.apache.ant.compress.util.EntryHelper;
import znaishaded.org.apache.ant.compress.util.StreamHelper;
import znaishaded.org.apache.commons.compress.archivers.ArchiveEntry;
import znaishaded.org.apache.commons.compress.archivers.ArchiveOutputStream;
import znaishaded.org.apache.commons.compress.archivers.zip.ExtraFieldUtils;
import znaishaded.org.apache.commons.compress.archivers.zip.ZipShort;
import znaishaded.org.apache.commons.compress.utils.IOUtils;
import znaishaded.org.apache.tools.ant.BuildException;
import znaishaded.org.apache.tools.ant.Task;
import znaishaded.org.apache.tools.ant.types.ArchiveFileSet;
import znaishaded.org.apache.tools.ant.types.EnumeratedAttribute;
import znaishaded.org.apache.tools.ant.types.Resource;
import znaishaded.org.apache.tools.ant.types.ResourceCollection;
import znaishaded.org.apache.tools.ant.types.resources.ArchiveResource;
import znaishaded.org.apache.tools.ant.types.resources.FileResource;
import znaishaded.org.apache.tools.ant.types.resources.MappedResource;
import znaishaded.org.apache.tools.ant.types.resources.Resources;
import znaishaded.org.apache.tools.ant.types.resources.Restrict;
import znaishaded.org.apache.tools.ant.types.resources.TarResource;
import znaishaded.org.apache.tools.ant.types.resources.selectors.Name;
import znaishaded.org.apache.tools.ant.types.resources.selectors.Not;
import znaishaded.org.apache.tools.ant.types.resources.selectors.Or;
import znaishaded.org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import znaishaded.org.apache.tools.ant.util.FileUtils;
import znaishaded.org.apache.tools.ant.util.IdentityMapper;
import znaishaded.org.apache.tools.ant.util.MergingMapper;
import znaishaded.org.apache.tools.ant.util.ResourceUtils;
import znaishaded.org.apache.tools.zip.ZipExtraField;

public abstract class ArchiveBase
extends Task {
    private ArchiveStreamFactory factory;
    private FileSetBuilder fileSetBuilder;
    private EntryBuilder entryBuilder;
    private Resource dest;
    private List<ResourceCollection> sources = new ArrayList<ResourceCollection>();
    private Mode mode = new Mode();
    private String encoding;
    private boolean filesOnly = true;
    private boolean preserve0permissions = false;
    private boolean roundUp = true;
    private boolean preserveLeadingSlashes = false;
    private Duplicate duplicate = new Duplicate();
    private WhenEmpty emptyBehavior = new WhenEmpty();
    private static final String NO_SOURCES_MSG = "No sources, nothing to do.";
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();

    protected ArchiveBase() {
    }

    protected final void setFactory(ArchiveStreamFactory factory) {
        this.factory = factory;
    }

    protected final ArchiveStreamFactory getFactory() {
        return this.factory;
    }

    protected final void setEntryBuilder(EntryBuilder builder) {
        this.entryBuilder = builder;
    }

    protected final EntryBuilder getEntryBuilder() {
        return this.entryBuilder;
    }

    protected final void setFileSetBuilder(FileSetBuilder builder) {
        this.fileSetBuilder = builder;
    }

    protected final FileSetBuilder getFileSetBuilder() {
        return this.fileSetBuilder;
    }

    public void setDestfile(File f) {
        this.setDest(new FileResource(f));
    }

    public void addConfiguredDest(Resources r) {
        Iterator<Resource> it = r.iterator();
        while (it.hasNext()) {
            this.setDest(it.next());
        }
    }

    public void setDest(Resource r) {
        if (this.dest != null) {
            throw new BuildException("Can only have one destination resource for archive.");
        }
        this.dest = r;
    }

    protected Resource getDest() {
        return this.dest;
    }

    public void add(ResourceCollection c) {
        this.sources.add(c);
    }

    public void setMode(Mode m) {
        this.mode = m;
    }

    protected Mode getMode() {
        return this.mode;
    }

    public void setEncoding(String e) {
        this.encoding = e;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setFilesOnly(boolean b) {
        this.filesOnly = b;
    }

    protected boolean isFilesOnly() {
        return this.filesOnly;
    }

    public void setPreserve0permissions(boolean b) {
        this.preserve0permissions = b;
    }

    public void setRoundUp(boolean r) {
        this.roundUp = r;
    }

    public void setPreserveLeadingSlashes(boolean b) {
        this.preserveLeadingSlashes = b;
    }

    public boolean getPreserveLeadingSlashes() {
        return this.preserveLeadingSlashes;
    }

    public void setDuplicate(Duplicate df) {
        this.duplicate = df;
    }

    public void setWhenempty(WhenEmpty we) {
        this.emptyBehavior = we;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute() {
        Collection sourceResources;
        this.validate();
        Resource targetArchive = this.getDest();
        if (!targetArchive.isExists()) {
            this.mode = new Mode();
            this.mode.setValue("force-create");
        }
        try {
            sourceResources = this.findSources();
        }
        catch (IOException ioex) {
            throw new BuildException("Failed to read sources", ioex);
        }
        if (sourceResources.size() == 0) {
            if (!WhenEmpty.SKIP.equals(this.emptyBehavior.getValue())) throw new BuildException(NO_SOURCES_MSG);
            this.log(NO_SOURCES_MSG, 1);
            return;
        }
        File copyOfDest = this.maybeCopyTarget();
        Resource destOrCopy = copyOfDest == null ? targetArchive : new FileResource(copyOfDest);
        ArchiveFileSet existingEntries = this.fileSetBuilder.buildFileSet(destOrCopy);
        existingEntries.setProject(this.getProject());
        try {
            ArrayList toAdd = new ArrayList();
            toAdd.addAll(sourceResources);
            if (this.checkAndLogUpToDate(toAdd, targetArchive, existingEntries)) {
                return;
            }
            this.addResourcesToKeep(toAdd, existingEntries, sourceResources);
            this.sort(toAdd);
            try {
                this.writeArchive(toAdd);
                return;
            }
            catch (IOException ioex) {
                throw new BuildException("Failed to write archive", ioex);
            }
        }
        finally {
            if (copyOfDest != null) {
                FILE_UTILS.tryHardToDelete(copyOfDest);
            }
        }
    }

    protected void validate() throws BuildException {
        if (this.factory == null) {
            throw new BuildException("subclass didn't provide a factory instance");
        }
        if (this.entryBuilder == null) {
            throw new BuildException("subclass didn't provide an entryBuilder instance");
        }
        if (this.fileSetBuilder == null) {
            throw new BuildException("subclass didn't provide a fileSetBuilder instance");
        }
        if (this.getDest() == null) {
            throw new BuildException("must provide a destination resource");
        }
        if (this.sources.size() == 0) {
            throw new BuildException("must provide sources");
        }
    }

    protected Collection findSources() throws IOException {
        ArrayList<ResourceWithFlags> l = new ArrayList<ResourceWithFlags>();
        HashSet<String> addedNames = new HashSet<String>();
        for (ResourceCollection rc : this.sources) {
            ResourceCollectionFlags rcFlags = this.getFlags(rc);
            for (Resource r : rc) {
                boolean isDup;
                ResourceWithFlags rwf;
                String name;
                if (this.isFilesOnly() && r.isDirectory() || "".equals(name = (rwf = new ResourceWithFlags(r, rcFlags, this.getFlags(r))).getName()) || "/".equals(name)) continue;
                boolean bl = isDup = !addedNames.add(name);
                if (isDup && !this.addDuplicate(name)) continue;
                l.add(rwf);
            }
        }
        return l;
    }

    private boolean checkAndLogUpToDate(Collection src, Resource targetArchive, ArchiveFileSet existingEntries) {
        try {
            if (!"force-create".equals(this.getMode().getValue()) && !"force-replace".equals(this.getMode().getValue()) && this.isUpToDate(src, existingEntries)) {
                this.log(targetArchive + " is up-to-date, nothing to do.");
                return true;
            }
        }
        catch (IOException ioex) {
            throw new BuildException("Failed to read target archive", ioex);
        }
        return false;
    }

    protected boolean isUpToDate(Collection src, ArchiveFileSet existingEntries) throws IOException {
        Resource[] srcResources = new Resource[src.size()];
        int index = 0;
        for (ResourceWithFlags r : src) {
            srcResources[index++] = new MappedResource(r.getResource(), new MergingMapper(r.getName()));
        }
        Resource[] outOfDate = ResourceUtils.selectOutOfDateSources(this, srcResources, new IdentityMapper(), existingEntries.getDirectoryScanner(this.getProject()));
        if (outOfDate.length > 0 && "update".equals(this.getMode().getValue())) {
            HashSet<String> oodNames = new HashSet<String>();
            for (int i = 0; i < outOfDate.length; ++i) {
                oodNames.add(outOfDate[i].getName());
            }
            LinkedList copy = new LinkedList(src);
            src.clear();
            for (ResourceWithFlags r : copy) {
                if (!oodNames.contains(r.getName())) continue;
                src.add(r);
            }
        }
        return outOfDate.length == 0;
    }

    private void addResourcesToKeep(Collection toAdd, ArchiveFileSet target, Collection src) {
        if (!"force-create".equals(this.getMode().getValue()) && !"create".equals(this.getMode().getValue())) {
            try {
                toAdd.addAll(this.findUnmatchedTargets(target, src));
            }
            catch (IOException ioex) {
                throw new BuildException("Failed to read target archive", ioex);
            }
        }
    }

    protected Collection findUnmatchedTargets(ArchiveFileSet target, Collection src) throws IOException {
        Object name;
        ArrayList<ResourceWithFlags> l = new ArrayList<ResourceWithFlags>();
        ResourceCollectionFlags rcFlags = this.getFlags(target);
        Restrict res = new Restrict();
        res.setProject(this.getProject());
        res.add(target);
        Not not = new Not();
        Or or = new Or();
        not.add(or);
        for (Object r : src) {
            name = new Name();
            ((Name)name).setName(((ResourceWithFlags)r).getName());
            or.add((ResourceSelector)name);
        }
        res.add(not);
        for (Object r : res) {
            name = ((Resource)r).getName();
            if ("".equals(name) || "/".equals(name) || this.isFilesOnly() && ((Resource)r).isDirectory()) continue;
            l.add(new ResourceWithFlags((Resource)r, rcFlags, this.getFlags((Resource)r)));
        }
        return l;
    }

    protected void sort(List l) {
        Collections.sort(l, new Comparator(){

            public int compare(Object o1, Object o2) {
                ResourceWithFlags r1 = (ResourceWithFlags)o1;
                ResourceWithFlags r2 = (ResourceWithFlags)o2;
                return r1.getName().compareTo(r2.getName());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeArchive(Collection src) throws IOException {
        ArchiveOutputStream out = null;
        HashSet<String> addedDirectories = new HashSet<String>();
        try {
            String enc = "native-encoding".equals(this.getEncoding()) ? null : this.getEncoding();
            out = StreamHelper.getOutputStream(this.factory, this.getDest(), enc);
            if (out == null) {
                out = this.factory.getArchiveStream(new BufferedOutputStream(this.getDest().getOutputStream()), enc);
            }
            for (ResourceWithFlags r : src) {
                if (!this.isFilesOnly()) {
                    this.ensureParentDirs(out, r, addedDirectories);
                }
                ArchiveEntry ent = this.entryBuilder.buildEntry(r);
                out.putArchiveEntry(ent);
                if (!r.getResource().isDirectory()) {
                    try (InputStream in = r.getResource().getInputStream();){
                        IOUtils.copy(in, out);
                    }
                } else {
                    addedDirectories.add(r.getName());
                }
                out.closeArchiveEntry();
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close(out);
    }

    protected void ensureParentDirs(ArchiveOutputStream out, ResourceWithFlags r, Set directoriesAdded) throws IOException {
        String[] parentStack = FileUtils.getPathStack(r.getName());
        String currentParent = "";
        int skip = r.getName().endsWith("/") ? 2 : 1;
        for (int i = 0; i < parentStack.length - skip; ++i) {
            if ("".equals(parentStack[i]) || !directoriesAdded.add(currentParent = currentParent + parentStack[i] + "/")) continue;
            Resource dir = new Resource(currentParent, true, System.currentTimeMillis(), true);
            ResourceWithFlags artifical = new ResourceWithFlags(currentParent, dir, r.getCollectionFlags(), new ResourceFlags());
            ArchiveEntry ent = this.entryBuilder.buildEntry(artifical);
            out.putArchiveEntry(ent);
            out.closeArchiveEntry();
        }
    }

    protected ResourceFlags getFlags(Resource r) throws ZipException {
        if (r instanceof ArchiveResource) {
            if (r instanceof CommonsCompressArchiveResource) {
                if (r instanceof znaishaded.org.apache.ant.compress.resources.TarResource) {
                    znaishaded.org.apache.ant.compress.resources.TarResource tr = (znaishaded.org.apache.ant.compress.resources.TarResource)r;
                    return new ResourceFlags(tr.getMode(), tr.getUid(), tr.getGid(), tr.getUserName(), tr.getGroup());
                }
                if (r instanceof ZipResource) {
                    ZipResource zr = (ZipResource)r;
                    return new ResourceFlags(zr.getMode(), zr.getExtraFields(), zr.getMethod());
                }
                if (r instanceof SevenZResource) {
                    SevenZResource zr = (SevenZResource)r;
                    return new ResourceFlags(zr.getContentMethods());
                }
                CommonsCompressArchiveResource cr = (CommonsCompressArchiveResource)r;
                return new ResourceFlags(cr.getMode(), cr.getUid(), cr.getGid());
            }
            if (r instanceof TarResource) {
                TarResource tr = (TarResource)r;
                return new ResourceFlags(tr.getMode(), tr.getUid(), tr.getGid(), tr.getUserName(), tr.getGroup());
            }
            if (r instanceof znaishaded.org.apache.tools.ant.types.resources.ZipResource) {
                znaishaded.org.apache.tools.ant.types.resources.ZipResource zr = (znaishaded.org.apache.tools.ant.types.resources.ZipResource)r;
                ZipExtraField[] extra = zr.getExtraFields();
                znaishaded.org.apache.commons.compress.archivers.zip.ZipExtraField[] ex = new znaishaded.org.apache.commons.compress.archivers.zip.ZipExtraField[extra == null ? 0 : extra.length];
                if (extra != null && extra.length > 0) {
                    for (int i = 0; i < extra.length; ++i) {
                        try {
                            ex[i] = ExtraFieldUtils.createExtraField(new ZipShort(extra[i].getHeaderId().getValue()));
                        }
                        catch (InstantiationException e) {
                            throw new BuildException(e);
                        }
                        catch (IllegalAccessException e) {
                            throw new BuildException(e);
                        }
                        byte[] b = extra[i].getCentralDirectoryData();
                        ex[i].parseFromCentralDirectoryData(b, 0, b.length);
                        b = extra[i].getLocalFileDataData();
                        ex[i].parseFromLocalFileData(b, 0, b.length);
                    }
                }
                return new ResourceFlags(zr.getMode(), ex, zr.getMethod());
            }
            ArchiveResource ar = (ArchiveResource)r;
            return new ResourceFlags(ar.getMode());
        }
        return new ResourceFlags();
    }

    protected ResourceCollectionFlags getFlags(ResourceCollection rc) {
        if (rc instanceof ArchiveFileSet) {
            if (rc instanceof ArFileSet) {
                ArFileSet ar = (ArFileSet)rc;
                return new ResourceCollectionFlags(ar.getPrefix(this.getProject()), ar.getFullpath(this.getProject()), ar.hasFileModeBeenSet() ? ar.getFileMode(this.getProject()) : -1, ar.hasDirModeBeenSet() ? ar.getDirMode(this.getProject()) : -1, ar.hasUserIdBeenSet() ? ar.getUid() : EntryHelper.UNKNOWN_ID, ar.hasGroupIdBeenSet() ? ar.getGid() : EntryHelper.UNKNOWN_ID);
            }
            if (rc instanceof CpioFileSet) {
                CpioFileSet cr = (CpioFileSet)rc;
                return new ResourceCollectionFlags(cr.getPrefix(this.getProject()), cr.getFullpath(this.getProject()), cr.hasFileModeBeenSet() ? cr.getFileMode(this.getProject()) : -1, cr.hasDirModeBeenSet() ? cr.getDirMode(this.getProject()) : -1, cr.hasUserIdBeenSet() ? cr.getUid() : EntryHelper.UNKNOWN_ID, cr.hasGroupIdBeenSet() ? cr.getGid() : EntryHelper.UNKNOWN_ID);
            }
            if (rc instanceof TarFileSet) {
                TarFileSet tr = (TarFileSet)rc;
                return new ResourceCollectionFlags(tr.getPrefix(this.getProject()), tr.getFullpath(this.getProject()), tr.hasFileModeBeenSet() ? tr.getFileMode(this.getProject()) : -1, tr.hasDirModeBeenSet() ? tr.getDirMode(this.getProject()) : -1, tr.hasUserIdBeenSet() ? tr.getUid() : EntryHelper.UNKNOWN_ID, tr.hasGroupIdBeenSet() ? tr.getGid() : EntryHelper.UNKNOWN_ID, tr.hasUserNameBeenSet() ? tr.getUserName() : null, tr.hasGroupBeenSet() ? tr.getGroup() : null);
            }
            if (rc instanceof znaishaded.org.apache.tools.ant.types.TarFileSet) {
                znaishaded.org.apache.tools.ant.types.TarFileSet tr = (znaishaded.org.apache.tools.ant.types.TarFileSet)rc;
                return new ResourceCollectionFlags(tr.getPrefix(this.getProject()), tr.getFullpath(this.getProject()), tr.hasFileModeBeenSet() ? tr.getFileMode(this.getProject()) : -1, tr.hasDirModeBeenSet() ? tr.getDirMode(this.getProject()) : -1, tr.hasUserIdBeenSet() ? tr.getUid() : EntryHelper.UNKNOWN_ID, tr.hasGroupIdBeenSet() ? tr.getGid() : EntryHelper.UNKNOWN_ID, tr.hasUserNameBeenSet() ? tr.getUserName() : null, tr.hasGroupBeenSet() ? tr.getGroup() : null);
            }
            ArchiveFileSet ar = (ArchiveFileSet)rc;
            return new ResourceCollectionFlags(ar.getPrefix(this.getProject()), ar.getFullpath(this.getProject()), ar.hasFileModeBeenSet() ? ar.getFileMode(this.getProject()) : -1, ar.hasDirModeBeenSet() ? ar.getDirMode(this.getProject()) : -1);
        }
        return new ResourceCollectionFlags();
    }

    protected String bendSlashesForward(String s) {
        if (s != null) {
            s = s.replace('\\', '/');
            if (File.separatorChar != '/' && File.separatorChar != '\\') {
                s = s.replace(File.separatorChar, '/');
            }
            while (!this.preserveLeadingSlashes && s.startsWith("/")) {
                s = s.substring(1);
            }
        }
        return s;
    }

    protected long round(long millis, long granularity) {
        return this.roundUp ? millis + granularity - 1L : millis;
    }

    protected boolean addDuplicate(String name) {
        if (this.duplicate.getValue().equals(Duplicate.PRESERVE)) {
            this.log(name + " already added, skipping.", 2);
            return false;
        }
        if (this.duplicate.getValue().equals(Duplicate.FAIL)) {
            throw new BuildException("Duplicate entry " + name + " was found and the duplicate attribute is 'fail'.");
        }
        this.log("duplicate entry " + name + " found, adding.", 3);
        return true;
    }

    private File maybeCopyTarget() {
        File copyOfDest = null;
        try {
            if (!"force-create".equals(this.getMode().getValue()) && !"create".equals(this.getMode().getValue())) {
                copyOfDest = FILE_UTILS.createTempFile(this.getTaskName(), ".tmp", null, true, false);
                ResourceUtils.copyResource(this.getDest(), new FileResource(copyOfDest));
            }
        }
        catch (IOException ioex) {
            if (copyOfDest != null && copyOfDest.exists()) {
                FILE_UTILS.tryHardToDelete(copyOfDest);
            }
            throw new BuildException("Failed to copy target archive", ioex);
        }
        return copyOfDest;
    }

    public static interface FileSetBuilder {
        public ArchiveFileSet buildFileSet(Resource var1);
    }

    public static interface EntryBuilder {
        public ArchiveEntry buildEntry(ResourceWithFlags var1);
    }

    public class ResourceWithFlags {
        private final Resource r;
        private final ResourceCollectionFlags rcFlags;
        private final ResourceFlags rFlags;
        private final String name;

        public ResourceWithFlags(Resource r, ResourceCollectionFlags rcFlags, ResourceFlags rFlags) {
            this(null, r, rcFlags, rFlags);
        }

        public ResourceWithFlags(String name, Resource r, ResourceCollectionFlags rcFlags, ResourceFlags rFlags) {
            this.r = r;
            this.rcFlags = rcFlags;
            this.rFlags = rFlags;
            if (name == null) {
                name = r.getName();
                if (rcFlags.hasFullpath()) {
                    name = rcFlags.getFullpath();
                } else if (rcFlags.hasPrefix()) {
                    String prefix = rcFlags.getPrefix();
                    if (!prefix.endsWith("/")) {
                        prefix = prefix + "/";
                    }
                    name = prefix + name;
                }
                name = ArchiveBase.this.bendSlashesForward(name);
            }
            if (r.isDirectory() && !name.endsWith("/")) {
                name = name + "/";
            } else if (!r.isDirectory() && name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            this.name = name;
        }

        public Resource getResource() {
            return this.r;
        }

        public ResourceCollectionFlags getCollectionFlags() {
            return this.rcFlags;
        }

        public ResourceFlags getResourceFlags() {
            return this.rFlags;
        }

        public String getName() {
            return this.name;
        }
    }

    public class ResourceCollectionFlags
    extends ResourceFlags {
        private final String prefix;
        private final String fullpath;
        private final int dirMode;

        public ResourceCollectionFlags() {
            this(null, null);
        }

        public ResourceCollectionFlags(String prefix, String fullpath) {
            this(prefix, fullpath, -1, -1);
        }

        public ResourceCollectionFlags(String prefix, String fullpath, int fileMode, int dirMode) {
            this(prefix, fullpath, fileMode, dirMode, EntryHelper.UNKNOWN_ID, EntryHelper.UNKNOWN_ID);
        }

        public ResourceCollectionFlags(String prefix, String fullpath, int fileMode, int dirMode, int uid, int gid) {
            this(prefix, fullpath, fileMode, dirMode, uid, gid, null, null);
        }

        public ResourceCollectionFlags(String prefix, String fullpath, int fileMode, int dirMode, int uid, int gid, String userName, String groupName) {
            super(fileMode, uid, gid, userName, groupName);
            this.dirMode = dirMode;
            this.prefix = ArchiveBase.this.bendSlashesForward(prefix);
            this.fullpath = ArchiveBase.this.bendSlashesForward(fullpath);
        }

        public boolean hasDirModeBeenSet() {
            return this.dirMode >= 0;
        }

        public int getDirMode() {
            return this.dirMode;
        }

        public boolean hasPrefix() {
            return this.prefix != null && !"".equals(this.prefix);
        }

        public String getPrefix() {
            return this.prefix;
        }

        public boolean hasFullpath() {
            return this.fullpath != null && !"".equals(this.fullpath);
        }

        public String getFullpath() {
            return this.fullpath;
        }
    }

    public class ResourceFlags {
        private final int mode;
        private final boolean modeSet;
        private final int gid;
        private final int uid;
        private final znaishaded.org.apache.commons.compress.archivers.zip.ZipExtraField[] extraFields;
        private final String userName;
        private final String groupName;
        private final int compressionMethod;
        private Iterable contentMethods;

        public ResourceFlags() {
            this(-1);
        }

        public ResourceFlags(int mode) {
            this(mode, new znaishaded.org.apache.commons.compress.archivers.zip.ZipExtraField[0], -1);
        }

        public ResourceFlags(int mode, znaishaded.org.apache.commons.compress.archivers.zip.ZipExtraField[] extraFields, int compressionMethod) {
            this(mode, extraFields, EntryHelper.UNKNOWN_ID, EntryHelper.UNKNOWN_ID, null, null, compressionMethod, null);
        }

        public ResourceFlags(int mode, int uid, int gid) {
            this(mode, new znaishaded.org.apache.commons.compress.archivers.zip.ZipExtraField[0], uid, gid, null, null, -1, null);
        }

        public ResourceFlags(int mode, int uid, int gid, String userName, String groupName) {
            this(mode, new znaishaded.org.apache.commons.compress.archivers.zip.ZipExtraField[0], uid, gid, userName, groupName, -1, null);
        }

        public ResourceFlags(Iterable contentMethods) {
            this(-1, new znaishaded.org.apache.commons.compress.archivers.zip.ZipExtraField[0], EntryHelper.UNKNOWN_ID, EntryHelper.UNKNOWN_ID, null, null, -1, contentMethods);
        }

        private ResourceFlags(int mode, znaishaded.org.apache.commons.compress.archivers.zip.ZipExtraField[] extraFields, int uid, int gid, String userName, String groupName, int compressionMethod, Iterable contentMethods) {
            this.mode = mode;
            this.extraFields = extraFields;
            this.gid = gid;
            this.uid = uid;
            this.userName = userName;
            this.groupName = groupName;
            int m = mode & 0xFFF;
            this.modeSet = mode >= 0 && (m > 0 || m == 0 && ArchiveBase.this.preserve0permissions);
            this.compressionMethod = compressionMethod;
            this.contentMethods = contentMethods;
        }

        public boolean hasModeBeenSet() {
            return this.modeSet;
        }

        public int getMode() {
            return this.mode;
        }

        public znaishaded.org.apache.commons.compress.archivers.zip.ZipExtraField[] getZipExtraFields() {
            return this.extraFields;
        }

        public boolean hasUserIdBeenSet() {
            return this.uid != EntryHelper.UNKNOWN_ID;
        }

        public int getUserId() {
            return this.uid;
        }

        public boolean hasGroupIdBeenSet() {
            return this.gid != EntryHelper.UNKNOWN_ID;
        }

        public int getGroupId() {
            return this.gid;
        }

        public boolean hasUserNameBeenSet() {
            return this.userName != null;
        }

        public String getUserName() {
            return this.userName;
        }

        public boolean hasGroupNameBeenSet() {
            return this.groupName != null;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public boolean hasCompressionMethod() {
            return this.compressionMethod >= 0;
        }

        public int getCompressionMethod() {
            return this.compressionMethod;
        }

        public boolean hasContentMethods() {
            return this.contentMethods != null;
        }

        public Iterable getContentMethods() {
            return this.contentMethods;
        }
    }

    public static class WhenEmpty
    extends EnumeratedAttribute {
        private static String FAIL = "fail";
        private static String SKIP = "skip";

        public WhenEmpty() {
            this.setValue(FAIL);
        }

        @Override
        public String[] getValues() {
            return new String[]{FAIL, SKIP};
        }
    }

    public static class Duplicate
    extends EnumeratedAttribute {
        private static String ADD = "add";
        private static String PRESERVE = "preserve";
        private static String FAIL = "fail";

        public Duplicate() {
            this.setValue(FAIL);
        }

        @Override
        public String[] getValues() {
            return new String[]{ADD, PRESERVE, FAIL};
        }
    }

    public static final class Mode
    extends EnumeratedAttribute {
        public static final String CREATE = "create";
        public static final String FORCE_CREATE = "force-create";
        public static final String UPDATE = "update";
        public static final String REPLACE = "replace";
        public static final String FORCE_REPLACE = "force-replace";

        public Mode() {
            this.setValue(CREATE);
        }

        @Override
        public String[] getValues() {
            return new String[]{CREATE, UPDATE, REPLACE, FORCE_CREATE, FORCE_REPLACE};
        }
    }
}

