/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.http.client.protocol;

import java.io.IOException;
import znaishaded.org.apache.commons.logging.Log;
import znaishaded.org.apache.commons.logging.LogFactory;
import znaishaded.org.apache.http.HttpException;
import znaishaded.org.apache.http.HttpRequest;
import znaishaded.org.apache.http.HttpRequestInterceptor;
import znaishaded.org.apache.http.annotation.Contract;
import znaishaded.org.apache.http.annotation.ThreadingBehavior;
import znaishaded.org.apache.http.client.protocol.HttpClientContext;
import znaishaded.org.apache.http.conn.routing.RouteInfo;
import znaishaded.org.apache.http.protocol.HttpContext;
import znaishaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String PROXY_CONN_DIRECTIVE = "Proxy-Connection";

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            request.setHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RouteInfo route2 = clientContext.getHttpRoute();
        if (route2 == null) {
            this.log.debug("Connection route not set in the context");
            return;
        }
        if ((route2.getHopCount() == 1 || route2.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
        if (route2.getHopCount() == 2 && !route2.isTunnelled() && !request.containsHeader(PROXY_CONN_DIRECTIVE)) {
            request.addHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
        }
    }
}

