/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.brotli.dec;

import java.io.IOException;
import java.io.InputStream;
import znaishaded.org.brotli.dec.BrotliRuntimeException;
import znaishaded.org.brotli.dec.IntReader;

final class BitReader {
    private static final int CAPACITY = 1024;
    private static final int SLACK = 16;
    private static final int INT_BUFFER_SIZE = 1040;
    private static final int BYTE_READ_SIZE = 4096;
    private static final int BYTE_BUFFER_SIZE = 4160;
    private final byte[] byteBuffer = new byte[4160];
    private final int[] intBuffer = new int[1040];
    private final IntReader intReader = new IntReader();
    private InputStream input;
    private boolean endOfStreamReached;
    long accumulator;
    int bitOffset;
    private int intOffset;
    private int tailBytes = 0;

    BitReader() {
    }

    static void readMoreInput(BitReader br) {
        int bytesRead;
        if (br.intOffset <= 1015) {
            return;
        }
        if (br.endOfStreamReached) {
            if (BitReader.intAvailable(br) >= -2) {
                return;
            }
            throw new BrotliRuntimeException("No more input");
        }
        int readOffset = br.intOffset << 2;
        System.arraycopy(br.byteBuffer, readOffset, br.byteBuffer, 0, bytesRead);
        br.intOffset = 0;
        try {
            int len;
            for (bytesRead = 4096 - readOffset; bytesRead < 4096; bytesRead += len) {
                len = br.input.read(br.byteBuffer, bytesRead, 4096 - bytesRead);
                if (len > 0) continue;
                br.endOfStreamReached = true;
                br.tailBytes = bytesRead;
                bytesRead += 3;
                break;
            }
        }
        catch (IOException e) {
            throw new BrotliRuntimeException("Failed to read input", e);
        }
        IntReader.convert(br.intReader, bytesRead >> 2);
    }

    static void checkHealth(BitReader br, boolean endOfStream) {
        if (!br.endOfStreamReached) {
            return;
        }
        int byteOffset = (br.intOffset << 2) + (br.bitOffset + 7 >> 3) - 8;
        if (byteOffset > br.tailBytes) {
            throw new BrotliRuntimeException("Read after end");
        }
        if (endOfStream && byteOffset != br.tailBytes) {
            throw new BrotliRuntimeException("Unused bytes after end");
        }
    }

    static void fillBitWindow(BitReader br) {
        if (br.bitOffset >= 32) {
            br.accumulator = (long)br.intBuffer[br.intOffset++] << 32 | br.accumulator >>> 32;
            br.bitOffset -= 32;
        }
    }

    static int readBits(BitReader br, int n) {
        BitReader.fillBitWindow(br);
        int val = (int)(br.accumulator >>> br.bitOffset) & (1 << n) - 1;
        br.bitOffset += n;
        return val;
    }

    static void init(BitReader br, InputStream input) {
        if (br.input != null) {
            throw new IllegalStateException("Bit reader already has associated input stream");
        }
        IntReader.init(br.intReader, br.byteBuffer, br.intBuffer);
        br.input = input;
        br.accumulator = 0L;
        br.bitOffset = 64;
        br.intOffset = 1024;
        br.endOfStreamReached = false;
        BitReader.prepare(br);
    }

    private static void prepare(BitReader br) {
        BitReader.readMoreInput(br);
        BitReader.checkHealth(br, false);
        BitReader.fillBitWindow(br);
        BitReader.fillBitWindow(br);
    }

    static void reload(BitReader br) {
        if (br.bitOffset == 64) {
            BitReader.prepare(br);
        }
    }

    static void close(BitReader br) throws IOException {
        InputStream is = br.input;
        br.input = null;
        if (is != null) {
            is.close();
        }
    }

    static void jumpToByteBoundary(BitReader br) {
        int paddingBits;
        int padding = 64 - br.bitOffset & 7;
        if (padding != 0 && (paddingBits = BitReader.readBits(br, padding)) != 0) {
            throw new BrotliRuntimeException("Corrupted padding bits");
        }
    }

    static int intAvailable(BitReader br) {
        int limit = 1024;
        if (br.endOfStreamReached) {
            limit = br.tailBytes + 3 >> 2;
        }
        return limit - br.intOffset;
    }

    static void copyBytes(BitReader br, byte[] data, int offset, int length) {
        if ((br.bitOffset & 7) != 0) {
            throw new BrotliRuntimeException("Unaligned copyBytes");
        }
        while (br.bitOffset != 64 && length != 0) {
            data[offset++] = (byte)(br.accumulator >>> br.bitOffset);
            br.bitOffset += 8;
            --length;
        }
        if (length == 0) {
            return;
        }
        int copyInts = Math.min(BitReader.intAvailable(br), length >> 2);
        if (copyInts > 0) {
            int readOffset = br.intOffset << 2;
            System.arraycopy(br.byteBuffer, readOffset, data, offset, copyInts << 2);
            offset += copyInts << 2;
            length -= copyInts << 2;
            br.intOffset += copyInts;
        }
        if (length == 0) {
            return;
        }
        if (BitReader.intAvailable(br) > 0) {
            BitReader.fillBitWindow(br);
            while (length != 0) {
                data[offset++] = (byte)(br.accumulator >>> br.bitOffset);
                br.bitOffset += 8;
                --length;
            }
            BitReader.checkHealth(br, false);
            return;
        }
        try {
            while (length > 0) {
                int len = br.input.read(data, offset, length);
                if (len == -1) {
                    throw new BrotliRuntimeException("Unexpected end of input");
                }
                offset += len;
                length -= len;
            }
        }
        catch (IOException e) {
            throw new BrotliRuntimeException("Failed to read input", e);
        }
    }
}

