/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import znaishaded.org.commonmark.Extension;
import znaishaded.org.commonmark.internal.DocumentParser;
import znaishaded.org.commonmark.internal.InlineParserImpl;
import znaishaded.org.commonmark.node.Block;
import znaishaded.org.commonmark.node.Document;
import znaishaded.org.commonmark.node.Node;
import znaishaded.org.commonmark.parser.InlineParser;
import znaishaded.org.commonmark.parser.InlineParserContext;
import znaishaded.org.commonmark.parser.InlineParserFactory;
import znaishaded.org.commonmark.parser.PostProcessor;
import znaishaded.org.commonmark.parser.block.BlockParserFactory;
import znaishaded.org.commonmark.parser.delimiter.DelimiterProcessor;

public class Parser {
    private final List<BlockParserFactory> blockParserFactories;
    private final List<DelimiterProcessor> delimiterProcessors;
    private final InlineParserFactory inlineParserFactory;
    private final List<PostProcessor> postProcessors;

    private Parser(Builder builder) {
        this.blockParserFactories = DocumentParser.calculateBlockParserFactories(builder.blockParserFactories, builder.enabledBlockTypes);
        this.inlineParserFactory = builder.inlineParserFactory;
        this.postProcessors = builder.postProcessors;
        this.delimiterProcessors = builder.delimiterProcessors;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Node parse(String input) {
        InlineParser inlineParser = this.getInlineParser();
        DocumentParser documentParser = new DocumentParser(this.blockParserFactories, inlineParser);
        Document document = documentParser.parse(input);
        return this.postProcess(document);
    }

    public Node parseReader(Reader input) throws IOException {
        InlineParser inlineParser = this.getInlineParser();
        DocumentParser documentParser = new DocumentParser(this.blockParserFactories, inlineParser);
        Document document = documentParser.parse(input);
        return this.postProcess(document);
    }

    private InlineParser getInlineParser() {
        if (this.inlineParserFactory == null) {
            return new InlineParserImpl(this.delimiterProcessors);
        }
        CustomInlineParserContext inlineParserContext = new CustomInlineParserContext(this.delimiterProcessors);
        return this.inlineParserFactory.create(inlineParserContext);
    }

    private Node postProcess(Node document) {
        for (PostProcessor postProcessor : this.postProcessors) {
            document = postProcessor.process(document);
        }
        return document;
    }

    public static interface ParserExtension
    extends Extension {
        public void extend(Builder var1);
    }

    public static class Builder {
        private final List<BlockParserFactory> blockParserFactories = new ArrayList<BlockParserFactory>();
        private final List<DelimiterProcessor> delimiterProcessors = new ArrayList<DelimiterProcessor>();
        private final List<PostProcessor> postProcessors = new ArrayList<PostProcessor>();
        private Set<Class<? extends Block>> enabledBlockTypes = DocumentParser.getDefaultBlockParserTypes();
        private InlineParserFactory inlineParserFactory = null;

        public Parser build() {
            return new Parser(this);
        }

        public Builder extensions(Iterable<? extends Extension> extensions) {
            for (Extension extension : extensions) {
                if (!(extension instanceof ParserExtension)) continue;
                ParserExtension parserExtension = (ParserExtension)extension;
                parserExtension.extend(this);
            }
            return this;
        }

        public Builder enabledBlockTypes(Set<Class<? extends Block>> enabledBlockTypes) {
            this.enabledBlockTypes = enabledBlockTypes;
            return this;
        }

        public Builder customBlockParserFactory(BlockParserFactory blockParserFactory) {
            this.blockParserFactories.add(blockParserFactory);
            return this;
        }

        public Builder customDelimiterProcessor(DelimiterProcessor delimiterProcessor) {
            this.delimiterProcessors.add(delimiterProcessor);
            return this;
        }

        public Builder postProcessor(PostProcessor postProcessor) {
            this.postProcessors.add(postProcessor);
            return this;
        }

        public Builder inlineParserFactory(InlineParserFactory inlineParserFactory) {
            this.inlineParserFactory = inlineParserFactory;
            return this;
        }
    }

    private class CustomInlineParserContext
    implements InlineParserContext {
        private List<DelimiterProcessor> delimiterProcessors;

        CustomInlineParserContext(List<DelimiterProcessor> delimiterProcessors) {
            this.delimiterProcessors = delimiterProcessors;
        }

        @Override
        public List<DelimiterProcessor> getCustomDelimiterProcessors() {
            return this.delimiterProcessors;
        }
    }
}

