/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.jsoup.examples;

import java.io.IOException;
import znaishaded.org.jsoup.Jsoup;
import znaishaded.org.jsoup.helper.Validate;
import znaishaded.org.jsoup.nodes.Document;
import znaishaded.org.jsoup.nodes.Element;
import znaishaded.org.jsoup.select.Elements;

public class ListLinks {
    public static void main(String[] args) throws IOException {
        Validate.isTrue(args.length == 1, "usage: supply url to fetch");
        String url = args[0];
        ListLinks.print("Fetching %s...", url);
        Document doc = Jsoup.connect(url).get();
        Elements links = doc.select("a[href]");
        Elements media = doc.select("[src]");
        Elements imports = doc.select("link[href]");
        ListLinks.print("\nMedia: (%d)", media.size());
        for (Element src : media) {
            if (src.tagName().equals("img")) {
                ListLinks.print(" * %s: <%s> %sx%s (%s)", src.tagName(), src.attr("abs:src"), src.attr("width"), src.attr("height"), ListLinks.trim(src.attr("alt"), 20));
                continue;
            }
            ListLinks.print(" * %s: <%s>", src.tagName(), src.attr("abs:src"));
        }
        ListLinks.print("\nImports: (%d)", imports.size());
        for (Element link : imports) {
            ListLinks.print(" * %s <%s> (%s)", link.tagName(), link.attr("abs:href"), link.attr("rel"));
        }
        ListLinks.print("\nLinks: (%d)", links.size());
        for (Element link : links) {
            ListLinks.print(" * a: <%s>  (%s)", link.attr("abs:href"), ListLinks.trim(link.text(), 35));
        }
    }

    private static void print(String msg, Object ... args) {
        System.out.println(String.format(msg, args));
    }

    private static String trim(String s, int width) {
        if (s.length() > width) {
            return s.substring(0, width - 1) + ".";
        }
        return s;
    }
}

