/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.stathissideris.ascii2image.text;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.org.stathissideris.ascii2image.core.FileUtils;
import znaishaded.org.stathissideris.ascii2image.core.ProcessingOptions;
import znaishaded.org.stathissideris.ascii2image.text.CellSet;
import znaishaded.org.stathissideris.ascii2image.text.GridPattern;
import znaishaded.org.stathissideris.ascii2image.text.GridPatternGroup;
import znaishaded.org.stathissideris.ascii2image.text.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextGrid {
    private static final boolean DEBUG = false;
    private ArrayList<StringBuffer> rows;
    private static char[] boundaries = new char[]{'/', '\\', '|', '-', '*', '=', ':'};
    private static char[] undisputableBoundaries = new char[]{'|', '-', '*', '=', ':'};
    private static char[] horizontalLines = new char[]{'-', '='};
    private static char[] verticalLines = new char[]{'|', ':'};
    private static char[] arrowHeads = new char[]{'<', '>', '^', 'v', 'V'};
    private static char[] cornerChars = new char[]{'\\', '/', '+'};
    private static char[] pointMarkers = new char[]{'*'};
    private static char[] dashedLines = new char[]{':', '~', '='};
    private static char[] entryPoints1 = new char[]{'\\'};
    private static char[] entryPoints2 = new char[]{'|', ':', '+', '\\', '/'};
    private static char[] entryPoints3 = new char[]{'/'};
    private static char[] entryPoints4 = new char[]{'-', '=', '+', '\\', '/'};
    private static char[] entryPoints5 = new char[]{'\\'};
    private static char[] entryPoints6 = new char[]{'|', ':', '+', '\\', '/'};
    private static char[] entryPoints7 = new char[]{'/'};
    private static char[] entryPoints8 = new char[]{'-', '=', '+', '\\', '/'};
    private static HashMap<String, String> humanColorCodes = new HashMap();
    private static HashSet<String> markupTags;

    public void addToMarkupTags(Collection<String> collection) {
        markupTags.addAll(collection);
    }

    public static void main(String[] stringArray) throws Exception {
        TextGrid textGrid = new TextGrid();
        textGrid.loadFrom("tests/text/art10.txt");
        TextGrid textGrid2 = textGrid;
        textGrid2.getClass();
        textGrid.writeStringTo(textGrid2.new Cell(28, 1), "testing");
        textGrid.findMarkupTags();
        textGrid.printDebug();
    }

    public TextGrid() {
        this.rows = new ArrayList();
    }

    public TextGrid(int n, int n2) {
        String string = StringUtils.repeatString(" ", n);
        this.rows = new ArrayList();
        for (int i = 0; i < n2; ++i) {
            this.rows.add(new StringBuffer(string));
        }
    }

    public static TextGrid makeSameSizeAs(TextGrid textGrid) {
        return new TextGrid(textGrid.getWidth(), textGrid.getHeight());
    }

    public TextGrid(TextGrid textGrid) {
        this.rows = new ArrayList();
        for (StringBuffer stringBuffer : textGrid.getRows()) {
            this.rows.add(new StringBuffer(stringBuffer));
        }
    }

    public void clear() {
        String string = StringUtils.repeatString(" ", this.getWidth());
        int n = this.getHeight();
        this.rows.clear();
        for (int i = 0; i < n; ++i) {
            this.rows.add(new StringBuffer(string));
        }
    }

    public char get(int n, int n2) {
        if (n > this.getWidth() - 1 || n2 > this.getHeight() - 1 || n < 0 || n2 < 0) {
            return '\u0000';
        }
        return this.rows.get(n2).charAt(n);
    }

    public char get(Cell cell2) {
        if (cell2.x > this.getWidth() - 1 || cell2.y > this.getHeight() - 1 || cell2.x < 0 || cell2.y < 0) {
            return '\u0000';
        }
        return this.rows.get(cell2.y).charAt(cell2.x);
    }

    public StringBuffer getRow(int n) {
        return this.rows.get(n);
    }

    public TextGrid getSubGrid(int n, int n2, int n3, int n4) {
        TextGrid textGrid = new TextGrid(n3, n4);
        for (int i = 0; i < n4; ++i) {
            textGrid.setRow(i, new StringBuffer(this.getRow(n2 + i).subSequence(n, n + n3)));
        }
        return textGrid;
    }

    public TextGrid getTestingSubGrid(Cell cell2) {
        return this.getSubGrid(cell2.x - 1, cell2.y - 1, 3, 3);
    }

    public String getStringAt(int n, int n2, int n3) {
        return this.getStringAt(new Cell(n, n2), n3);
    }

    public String getStringAt(Cell cell2, int n) {
        int n2 = cell2.x;
        int n3 = cell2.y;
        if (n2 > this.getWidth() - 1 || n3 > this.getHeight() - 1 || n2 < 0 || n3 < 0) {
            return null;
        }
        return this.rows.get(n3).substring(n2, n2 + n);
    }

    public char getNorthOf(int n, int n2) {
        return this.get(n, n2 - 1);
    }

    public char getSouthOf(int n, int n2) {
        return this.get(n, n2 + 1);
    }

    public char getEastOf(int n, int n2) {
        return this.get(n + 1, n2);
    }

    public char getWestOf(int n, int n2) {
        return this.get(n - 1, n2);
    }

    public char getNorthOf(Cell cell2) {
        return this.getNorthOf(cell2.x, cell2.y);
    }

    public char getSouthOf(Cell cell2) {
        return this.getSouthOf(cell2.x, cell2.y);
    }

    public char getEastOf(Cell cell2) {
        return this.getEastOf(cell2.x, cell2.y);
    }

    public char getWestOf(Cell cell2) {
        return this.getWestOf(cell2.x, cell2.y);
    }

    public void writeStringTo(int n, int n2, String string) {
        this.writeStringTo(new Cell(n, n2), string);
    }

    public void writeStringTo(Cell cell2, String string) {
        if (this.isOutOfBounds(cell2)) {
            return;
        }
        this.rows.get(cell2.y).replace(cell2.x, cell2.x + string.length(), string);
    }

    public void set(Cell cell2, char c) {
        this.set(cell2.x, cell2.y, c);
    }

    public void set(int n, int n2, char c) {
        if (n > this.getWidth() - 1 || n2 > this.getHeight() - 1) {
            return;
        }
        StringBuffer stringBuffer = this.rows.get(n2);
        stringBuffer.setCharAt(n, c);
    }

    public void setRow(int n, String string) {
        if (n > this.getHeight() || string.length() != this.getWidth()) {
            throw new IllegalArgumentException("setRow out of bounds or string wrong size");
        }
        this.rows.set(n, new StringBuffer(string));
    }

    public void setRow(int n, StringBuffer stringBuffer) {
        if (n > this.getHeight() || stringBuffer.length() != this.getWidth()) {
            throw new IllegalArgumentException("setRow out of bounds or string wrong size");
        }
        this.rows.set(n, stringBuffer);
    }

    public int getWidth() {
        if (this.rows.size() == 0) {
            return 0;
        }
        return this.rows.get(0).length();
    }

    public int getHeight() {
        return this.rows.size();
    }

    public void printDebug() {
        Iterator<StringBuffer> iterator = this.rows.iterator();
        int n = 0;
        System.out.println("    " + StringUtils.repeatString("0123456789", (int)Math.floor(this.getWidth() / 10) + 1));
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            String string2 = new Integer(n).toString();
            if (n < 10) {
                string2 = " " + string2;
            }
            System.out.println(string2 + " (" + string + ")");
            ++n;
        }
    }

    public String getDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<StringBuffer> iterator = this.rows.iterator();
        int n = 0;
        stringBuffer.append("    " + StringUtils.repeatString("0123456789", (int)Math.floor(this.getWidth() / 10) + 1) + "\n");
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            String string2 = new Integer(n).toString();
            if (n < 10) {
                string2 = " " + string2;
            }
            string = string.replaceAll("\n", "\\\\n");
            string = string.replaceAll("\r", "\\\\r");
            stringBuffer.append(string2 + " (" + string + ")\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getDebugString();
    }

    public boolean add(TextGrid textGrid) {
        if (this.getWidth() != textGrid.getWidth() || this.getHeight() != textGrid.getHeight()) {
            return false;
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (this.get(j, i) != ' ') continue;
                this.set(j, i, textGrid.get(j, i));
            }
        }
        return true;
    }

    public void replaceTypeOnLine() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                char c = this.get(j, i);
                if (!Character.isLetterOrDigit(c)) continue;
                boolean bl = this.isOnHorizontalLine(j, i);
                boolean bl2 = this.isOnVerticalLine(j, i);
                if (bl && bl2) {
                    this.set(j, i, '+');
                    continue;
                }
                if (bl) {
                    this.set(j, i, '-');
                    continue;
                }
                if (!bl2) continue;
                this.set(j, i, '|');
            }
        }
    }

    public void replacePointMarkersOnLine() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                char c = this.get(j, i);
                Cell cell2 = new Cell(j, i);
                if (!StringUtils.isOneOf(c, pointMarkers) || !this.isStarOnLine(cell2)) continue;
                boolean bl = false;
                if (StringUtils.isOneOf(this.get(cell2.getEast()), horizontalLines)) {
                    bl = true;
                }
                if (StringUtils.isOneOf(this.get(cell2.getWest()), horizontalLines)) {
                    bl = true;
                }
                boolean bl2 = false;
                if (StringUtils.isOneOf(this.get(cell2.getNorth()), verticalLines)) {
                    bl2 = true;
                }
                if (StringUtils.isOneOf(this.get(cell2.getSouth()), verticalLines)) {
                    bl2 = true;
                }
                if (bl && bl2) {
                    this.set(j, i, '+');
                    continue;
                }
                if (bl) {
                    this.set(j, i, '-');
                    continue;
                }
                if (!bl2) continue;
                this.set(j, i, '|');
            }
        }
    }

    public CellSet getPointMarkersOnLine() {
        CellSet cellSet = new CellSet();
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                char c = this.get(j, i);
                if (!StringUtils.isOneOf(c, pointMarkers) || !this.isStarOnLine(new Cell(j, i))) continue;
                cellSet.add(new Cell(j, i));
            }
        }
        return cellSet;
    }

    public void replaceHumanColorCodes() {
        int n = this.getHeight();
        for (int i = 0; i < n; ++i) {
            String string = this.rows.get(i).toString();
            for (String string2 : humanColorCodes.keySet()) {
                String string3 = humanColorCodes.get(string2);
                if (string3 == null) continue;
                string2 = "c" + string2;
                string3 = "c" + string3;
                string = string.replaceAll(string2, string3);
                this.rows.set(i, new StringBuffer(string));
                string = this.rows.get(i).toString();
            }
        }
    }

    public void replaceAll(char c, char c2) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                char c3 = this.get(j, i);
                if (c3 != c) continue;
                this.set(j, i, c2);
            }
        }
    }

    public boolean hasBlankCells() {
        CellSet cellSet = new CellSet();
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Cell cell2 = new Cell(j, i);
                if (!this.isBlank(cell2)) continue;
                return true;
            }
        }
        return false;
    }

    public CellSet getAllNonBlank() {
        CellSet cellSet = new CellSet();
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Cell cell2 = new Cell(j, i);
                if (this.isBlank(cell2)) continue;
                cellSet.add(cell2);
            }
        }
        return cellSet;
    }

    public CellSet getAllBoundaries() {
        CellSet cellSet = new CellSet();
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Cell cell2 = new Cell(j, i);
                if (!this.isBoundary(cell2)) continue;
                cellSet.add(cell2);
            }
        }
        return cellSet;
    }

    public CellSet getAllBlanksBetweenCharacters() {
        CellSet cellSet = new CellSet();
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Cell cell2 = new Cell(j, i);
                if (!this.isBlankBetweenCharacters(cell2)) continue;
                cellSet.add(cell2);
            }
        }
        return cellSet;
    }

    public ArrayList<CellStringPair> findStrings() {
        ArrayList<CellStringPair> arrayList = new ArrayList<CellStringPair>();
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (this.isBlank(j, i)) continue;
                Cell cell2 = new Cell(j, i);
                String string = String.valueOf(this.get(j, i));
                char c = this.get(++j, i);
                boolean bl = false;
                while (!bl) {
                    string = string + String.valueOf(c);
                    c = this.get(++j, i);
                    char c2 = this.get(j + 1, i);
                    if (c != ' ' && c != '\u0000' || c2 != ' ' && c2 != '\u0000') continue;
                    bl = true;
                }
                arrayList.add(new CellStringPair(cell2, string));
            }
        }
        return arrayList;
    }

    public boolean hasEntryPoint(Cell cell2, int n) {
        String string = "";
        char c = this.get(cell2);
        if (n == 1) {
            return StringUtils.isOneOf(c, entryPoints1);
        }
        if (n == 2) {
            return StringUtils.isOneOf(c, entryPoints2);
        }
        if (n == 3) {
            return StringUtils.isOneOf(c, entryPoints3);
        }
        if (n == 4) {
            return StringUtils.isOneOf(c, entryPoints4);
        }
        if (n == 5) {
            return StringUtils.isOneOf(c, entryPoints5);
        }
        if (n == 6) {
            return StringUtils.isOneOf(c, entryPoints6);
        }
        if (n == 7) {
            return StringUtils.isOneOf(c, entryPoints7);
        }
        if (n == 8) {
            return StringUtils.isOneOf(c, entryPoints8);
        }
        return false;
    }

    public boolean isBlankBetweenCharacters(Cell cell2) {
        return this.isBlank(cell2) && !this.isBlank(cell2.getEast()) && !this.isBlank(cell2.getWest());
    }

    public void removeNonText() {
        this.removeArrowheads();
        this.removeColorCodes();
        this.removeBoundaries();
        this.removeMarkupTags();
    }

    public void removeArrowheads() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Cell cell2 = new Cell(j, i);
                if (!this.isArrowhead(cell2)) continue;
                this.set(cell2, ' ');
            }
        }
    }

    public void removeColorCodes() {
        Iterator<CellColorPair> iterator = this.findColorCodes().iterator();
        while (iterator.hasNext()) {
            Cell cell2 = iterator.next().cell;
            this.set(cell2, ' ');
            cell2 = cell2.getEast();
            this.set(cell2, ' ');
            cell2 = cell2.getEast();
            this.set(cell2, ' ');
            cell2 = cell2.getEast();
            this.set(cell2, ' ');
        }
    }

    public void removeBoundaries() {
        ArrayList<Cell> arrayList = new ArrayList<Cell>();
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Cell cell2 = new Cell(j, i);
                if (!this.isBoundary(cell2)) continue;
                arrayList.add(cell2);
            }
        }
        for (Cell cell3 : arrayList) {
            this.set(cell3, ' ');
        }
    }

    public ArrayList findArrowheads() {
        ArrayList<Cell> arrayList = new ArrayList<Cell>();
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Cell cell2 = new Cell(j, i);
                if (!this.isArrowhead(cell2)) continue;
                arrayList.add(cell2);
            }
        }
        return arrayList;
    }

    public ArrayList<CellColorPair> findColorCodes() {
        Pattern pattern = Pattern.compile("c[A-F0-9]{3}");
        ArrayList<CellColorPair> arrayList = new ArrayList<CellColorPair>();
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n - 3; ++j) {
                Cell cell2 = new Cell(j, i);
                String string = this.getStringAt(cell2, 4);
                Matcher matcher = pattern.matcher(string);
                if (!matcher.matches()) continue;
                char c = string.charAt(1);
                char c2 = string.charAt(2);
                char c3 = string.charAt(3);
                int n3 = Integer.valueOf(String.valueOf(c), 16) * 17;
                int n4 = Integer.valueOf(String.valueOf(c2), 16) * 17;
                int n5 = Integer.valueOf(String.valueOf(c3), 16) * 17;
                arrayList.add(new CellColorPair(cell2, new Color(n3, n4, n5)));
            }
        }
        return arrayList;
    }

    public ArrayList<CellTagPair> findMarkupTags() {
        Pattern pattern = Pattern.compile("\\{(.+?)\\}");
        ArrayList<CellTagPair> arrayList = new ArrayList<CellTagPair>();
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n - 3; ++j) {
                String string;
                String string2;
                Matcher matcher;
                Cell cell2 = new Cell(j, i);
                char c = this.get(cell2);
                if (c != '{' || !(matcher = pattern.matcher(string2 = this.rows.get(i).substring(j))).find() || !markupTags.contains(string = matcher.group(1))) continue;
                arrayList.add(new CellTagPair(new Cell(j, i), string));
            }
        }
        return arrayList;
    }

    public void removeMarkupTags() {
        for (CellTagPair cellTagPair : this.findMarkupTags()) {
            String string = cellTagPair.tag;
            if (string == null) continue;
            int n = 2 + string.length();
            this.writeStringTo(cellTagPair.cell, StringUtils.repeatString(" ", n));
        }
    }

    public boolean matchesAny(GridPatternGroup gridPatternGroup) {
        return gridPatternGroup.isAnyMatchedBy(this);
    }

    public boolean matchesAll(GridPatternGroup gridPatternGroup) {
        return gridPatternGroup.areAllMatchedBy(this);
    }

    public boolean matches(GridPattern gridPattern) {
        return gridPattern.isMatchedBy(this);
    }

    public boolean isOnHorizontalLine(Cell cell2) {
        return this.isOnHorizontalLine(cell2.x, cell2.y);
    }

    private boolean isOnHorizontalLine(int n, int n2) {
        char c = this.get(n - 1, n2);
        char c2 = this.get(n + 1, n2);
        return TextGrid.isHorizontalLine(c) && TextGrid.isHorizontalLine(c2);
    }

    public boolean isOnVerticalLine(Cell cell2) {
        return this.isOnVerticalLine(cell2.x, cell2.y);
    }

    private boolean isOnVerticalLine(int n, int n2) {
        char c = this.get(n, n2 - 1);
        char c2 = this.get(n, n2 + 1);
        return TextGrid.isVerticalLine(c) && TextGrid.isVerticalLine(c2);
    }

    public static boolean isBoundary(char c) {
        return StringUtils.isOneOf(c, boundaries);
    }

    public boolean isBoundary(int n, int n2) {
        return this.isBoundary(new Cell(n, n2));
    }

    public boolean isBoundary(Cell cell2) {
        char c = this.get(cell2.x, cell2.y);
        if ('\u0000' == c) {
            return false;
        }
        if ('+' == c || '\\' == c || '/' == c) {
            return this.isIntersection(cell2) || this.isCorner(cell2) || this.isStub(cell2) || this.isCrossOnLine(cell2);
        }
        return StringUtils.isOneOf(c, boundaries) && !this.isLoneDiagonal(cell2);
    }

    public boolean isLine(Cell cell2) {
        return this.isHorizontalLine(cell2) || this.isVerticalLine(cell2);
    }

    public static boolean isHorizontalLine(char c) {
        return StringUtils.isOneOf(c, horizontalLines);
    }

    public boolean isHorizontalLine(Cell cell2) {
        return this.isHorizontalLine(cell2.x, cell2.y);
    }

    public boolean isHorizontalLine(int n, int n2) {
        char c = this.get(n, n2);
        if ('\u0000' == c) {
            return false;
        }
        return StringUtils.isOneOf(c, horizontalLines);
    }

    public static boolean isVerticalLine(char c) {
        return StringUtils.isOneOf(c, verticalLines);
    }

    public boolean isVerticalLine(Cell cell2) {
        return this.isVerticalLine(cell2.x, cell2.y);
    }

    public boolean isVerticalLine(int n, int n2) {
        char c = this.get(n, n2);
        if ('\u0000' == c) {
            return false;
        }
        return StringUtils.isOneOf(c, verticalLines);
    }

    public boolean isLinesEnd(int n, int n2) {
        return this.isLinesEnd(new Cell(n, n2));
    }

    public boolean isLinesEnd(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.linesEndCriteria);
    }

    public boolean isVerticalLinesEnd(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.verticalLinesEndCriteria);
    }

    public boolean isHorizontalLinesEnd(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.horizontalLinesEndCriteria);
    }

    public boolean isPointCell(Cell cell2) {
        return this.isCorner(cell2) || this.isIntersection(cell2) || this.isStub(cell2) || this.isLinesEnd(cell2);
    }

    public boolean containsAtLeastOneDashedLine(CellSet cellSet) {
        for (Cell cell2 : cellSet) {
            if (!StringUtils.isOneOf(this.get(cell2), dashedLines)) continue;
            return true;
        }
        return false;
    }

    public boolean exactlyOneNeighbourIsBoundary(Cell cell2) {
        int n = 0;
        if (this.isBoundary(cell2.getNorth())) {
            ++n;
        }
        if (this.isBoundary(cell2.getSouth())) {
            ++n;
        }
        if (this.isBoundary(cell2.getEast())) {
            ++n;
        }
        if (this.isBoundary(cell2.getWest())) {
            ++n;
        }
        return n == 1;
    }

    public boolean isStub(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.stubCriteria);
    }

    public boolean isCrossOnLine(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.crossOnLineCriteria);
    }

    public boolean isHorizontalCrossOnLine(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.horizontalCrossOnLineCriteria);
    }

    public boolean isVerticalCrossOnLine(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.verticalCrossOnLineCriteria);
    }

    public boolean isStarOnLine(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.starOnLineCriteria);
    }

    public boolean isLoneDiagonal(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.loneDiagonalCriteria);
    }

    public boolean isHorizontalStarOnLine(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.horizontalStarOnLineCriteria);
    }

    public boolean isVerticalStarOnLine(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.verticalStarOnLineCriteria);
    }

    public boolean isArrowhead(Cell cell2) {
        return this.isNorthArrowhead(cell2) || this.isSouthArrowhead(cell2) || this.isWestArrowhead(cell2) || this.isEastArrowhead(cell2);
    }

    public boolean isNorthArrowhead(Cell cell2) {
        return this.get(cell2) == '^';
    }

    public boolean isEastArrowhead(Cell cell2) {
        return this.get(cell2) == '>';
    }

    public boolean isWestArrowhead(Cell cell2) {
        return this.get(cell2) == '<';
    }

    public boolean isSouthArrowhead(Cell cell2) {
        return (this.get(cell2) == 'v' || this.get(cell2) == 'V') && this.isVerticalLine(cell2.getNorth());
    }

    public boolean isBullet(int n, int n2) {
        return this.isBullet(new Cell(n, n2));
    }

    public boolean isBullet(Cell cell2) {
        char c = this.get(cell2);
        return (c == 'o' || c == '*') && this.isBlank(cell2.getEast()) && this.isBlank(cell2.getWest()) && Character.isLetterOrDigit(this.get(cell2.getEast().getEast()));
    }

    public void replaceBullets() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Cell cell2 = new Cell(j, i);
                if (!this.isBullet(cell2)) continue;
                this.set(cell2, ' ');
                this.set(cell2.getEast(), '\u2022');
            }
        }
    }

    public boolean isStringsStart(Cell cell2) {
        return !this.isBlank(cell2) && this.isBlank(cell2.getWest());
    }

    public boolean isStringsEnd(Cell cell2) {
        return !this.isBlank(cell2) && this.isBlank(cell2.getEast());
    }

    public int otherStringsStartInTheSameColumn(Cell cell2) {
        if (!this.isStringsStart(cell2)) {
            return 0;
        }
        int n = 0;
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            Cell cell3 = new Cell(cell2.x, i);
            if (cell3.equals(cell2) || !this.isStringsStart(cell3)) continue;
            ++n;
        }
        return n;
    }

    public int otherStringsEndInTheSameColumn(Cell cell2) {
        if (!this.isStringsEnd(cell2)) {
            return 0;
        }
        int n = 0;
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            Cell cell3 = new Cell(cell2.x, i);
            if (cell3.equals(cell2) || !this.isStringsEnd(cell3)) continue;
            ++n;
        }
        return n;
    }

    public boolean isColumnBlank(int n) {
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            if (this.isBlank(n, i)) continue;
            return false;
        }
        return true;
    }

    public CellSet followLine(int n, int n2) {
        return this.followLine(new Cell(n, n2));
    }

    public CellSet followIntersection(Cell cell2) {
        return this.followIntersection(cell2, null);
    }

    public CellSet followIntersection(Cell cell2, Cell cell3) {
        if (!this.isIntersection(cell2)) {
            return null;
        }
        CellSet cellSet = new CellSet();
        Cell cell4 = cell2.getNorth();
        Cell cell5 = cell2.getSouth();
        Cell cell6 = cell2.getEast();
        Cell cell7 = cell2.getWest();
        if (this.hasEntryPoint(cell4, 6)) {
            cellSet.add(cell4);
        }
        if (this.hasEntryPoint(cell5, 2)) {
            cellSet.add(cell5);
        }
        if (this.hasEntryPoint(cell6, 8)) {
            cellSet.add(cell6);
        }
        if (this.hasEntryPoint(cell7, 4)) {
            cellSet.add(cell7);
        }
        if (cellSet.contains(cell3)) {
            cellSet.remove(cell3);
        }
        return cellSet;
    }

    public CellSet followLine(Cell cell2) {
        if (this.isHorizontalLine(cell2)) {
            CellSet cellSet = new CellSet();
            if (this.isBoundary(cell2.getEast())) {
                cellSet.add(cell2.getEast());
            }
            if (this.isBoundary(cell2.getWest())) {
                cellSet.add(cell2.getWest());
            }
            return cellSet;
        }
        if (this.isVerticalLine(cell2)) {
            CellSet cellSet = new CellSet();
            if (this.isBoundary(cell2.getNorth())) {
                cellSet.add(cell2.getNorth());
            }
            if (this.isBoundary(cell2.getSouth())) {
                cellSet.add(cell2.getSouth());
            }
            return cellSet;
        }
        return null;
    }

    public CellSet followLine(Cell cell2, Cell cell3) {
        CellSet cellSet = this.followLine(cell2);
        if (cellSet.contains(cell3)) {
            cellSet.remove(cell3);
        }
        return cellSet;
    }

    public CellSet followCorner(Cell cell2) {
        return this.followCorner(cell2, null);
    }

    public CellSet followCorner(Cell cell2, Cell cell3) {
        if (!this.isCorner(cell2)) {
            return null;
        }
        if (this.isCorner1(cell2)) {
            return this.followCorner1(cell2, cell3);
        }
        if (this.isCorner2(cell2)) {
            return this.followCorner2(cell2, cell3);
        }
        if (this.isCorner3(cell2)) {
            return this.followCorner3(cell2, cell3);
        }
        if (this.isCorner4(cell2)) {
            return this.followCorner4(cell2, cell3);
        }
        return null;
    }

    public CellSet followCorner1(Cell cell2) {
        return this.followCorner1(cell2, null);
    }

    public CellSet followCorner1(Cell cell2, Cell cell3) {
        if (!this.isCorner1(cell2)) {
            return null;
        }
        CellSet cellSet = new CellSet();
        if (!cell2.getSouth().equals(cell3)) {
            cellSet.add(cell2.getSouth());
        }
        if (!cell2.getEast().equals(cell3)) {
            cellSet.add(cell2.getEast());
        }
        return cellSet;
    }

    public CellSet followCorner2(Cell cell2) {
        return this.followCorner2(cell2, null);
    }

    public CellSet followCorner2(Cell cell2, Cell cell3) {
        if (!this.isCorner2(cell2)) {
            return null;
        }
        CellSet cellSet = new CellSet();
        if (!cell2.getSouth().equals(cell3)) {
            cellSet.add(cell2.getSouth());
        }
        if (!cell2.getWest().equals(cell3)) {
            cellSet.add(cell2.getWest());
        }
        return cellSet;
    }

    public CellSet followCorner3(Cell cell2) {
        return this.followCorner3(cell2, null);
    }

    public CellSet followCorner3(Cell cell2, Cell cell3) {
        if (!this.isCorner3(cell2)) {
            return null;
        }
        CellSet cellSet = new CellSet();
        if (!cell2.getNorth().equals(cell3)) {
            cellSet.add(cell2.getNorth());
        }
        if (!cell2.getWest().equals(cell3)) {
            cellSet.add(cell2.getWest());
        }
        return cellSet;
    }

    public CellSet followCorner4(Cell cell2) {
        return this.followCorner4(cell2, null);
    }

    public CellSet followCorner4(Cell cell2, Cell cell3) {
        if (!this.isCorner4(cell2)) {
            return null;
        }
        CellSet cellSet = new CellSet();
        if (!cell2.getNorth().equals(cell3)) {
            cellSet.add(cell2.getNorth());
        }
        if (!cell2.getEast().equals(cell3)) {
            cellSet.add(cell2.getEast());
        }
        return cellSet;
    }

    public CellSet followStub(Cell cell2) {
        return this.followStub(cell2, null);
    }

    public CellSet followStub(Cell cell2, Cell cell3) {
        if (!this.isStub(cell2)) {
            return null;
        }
        CellSet cellSet = new CellSet();
        if (this.isBoundary(cell2.getEast())) {
            cellSet.add(cell2.getEast());
        } else if (this.isBoundary(cell2.getWest())) {
            cellSet.add(cell2.getWest());
        } else if (this.isBoundary(cell2.getNorth())) {
            cellSet.add(cell2.getNorth());
        } else if (this.isBoundary(cell2.getSouth())) {
            cellSet.add(cell2.getSouth());
        }
        if (cellSet.contains(cell3)) {
            cellSet.remove(cell3);
        }
        return cellSet;
    }

    public CellSet followCell(Cell cell2) {
        return this.followCell(cell2, null);
    }

    public CellSet followCell(Cell cell2, Cell cell3) {
        if (this.isIntersection(cell2)) {
            return this.followIntersection(cell2, cell3);
        }
        if (this.isCorner(cell2)) {
            return this.followCorner(cell2, cell3);
        }
        if (this.isLine(cell2)) {
            return this.followLine(cell2, cell3);
        }
        if (this.isStub(cell2)) {
            return this.followStub(cell2, cell3);
        }
        if (this.isCrossOnLine(cell2)) {
            return this.followCrossOnLine(cell2, cell3);
        }
        System.err.println("Umbiguous input at position " + cell2 + ":");
        TextGrid textGrid = this.getTestingSubGrid(cell2);
        textGrid.printDebug();
        throw new RuntimeException("Cannot follow cell " + cell2 + ": cannot determine cell type");
    }

    public String getCellTypeAsString(Cell cell2) {
        if (this.isK(cell2)) {
            return "K";
        }
        if (this.isT(cell2)) {
            return "T";
        }
        if (this.isInverseK(cell2)) {
            return "inverse K";
        }
        if (this.isInverseT(cell2)) {
            return "inverse T";
        }
        if (this.isCorner1(cell2)) {
            return "corner 1";
        }
        if (this.isCorner2(cell2)) {
            return "corner 2";
        }
        if (this.isCorner3(cell2)) {
            return "corner 3";
        }
        if (this.isCorner4(cell2)) {
            return "corner 4";
        }
        if (this.isLine(cell2)) {
            return "line";
        }
        if (this.isStub(cell2)) {
            return "stub";
        }
        if (this.isCrossOnLine(cell2)) {
            return "crossOnLine";
        }
        return "unrecognisable type";
    }

    public CellSet followCrossOnLine(Cell cell2, Cell cell3) {
        CellSet cellSet = new CellSet();
        if (this.isHorizontalCrossOnLine(cell2)) {
            cellSet.add(cell2.getEast());
            cellSet.add(cell2.getWest());
        } else if (this.isVerticalCrossOnLine(cell2)) {
            cellSet.add(cell2.getNorth());
            cellSet.add(cell2.getSouth());
        }
        if (cellSet.contains(cell3)) {
            cellSet.remove(cell3);
        }
        return cellSet;
    }

    public boolean isOutOfBounds(Cell cell2) {
        return cell2.x > this.getWidth() - 1 || cell2.y > this.getHeight() - 1 || cell2.x < 0 || cell2.y < 0;
    }

    public boolean isOutOfBounds(int n, int n2) {
        char c = this.get(n, n2);
        return '\u0000' == c;
    }

    public boolean isBlank(Cell cell2) {
        char c = this.get(cell2);
        if ('\u0000' == c) {
            return false;
        }
        return c == ' ';
    }

    public boolean isBlank(int n, int n2) {
        char c = this.get(n, n2);
        if ('\u0000' == c) {
            return true;
        }
        return c == ' ';
    }

    public boolean isCorner(Cell cell2) {
        return this.isCorner(cell2.x, cell2.y);
    }

    public boolean isCorner(int n, int n2) {
        return this.isNormalCorner(n, n2) || this.isRoundCorner(n, n2);
    }

    public boolean matchesAny(Cell cell2, GridPatternGroup gridPatternGroup) {
        TextGrid textGrid = this.getTestingSubGrid(cell2);
        return textGrid.matchesAny(gridPatternGroup);
    }

    public boolean isCorner1(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.corner1Criteria);
    }

    public boolean isCorner2(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.corner2Criteria);
    }

    public boolean isCorner3(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.corner3Criteria);
    }

    public boolean isCorner4(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.corner4Criteria);
    }

    public boolean isCross(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.crossCriteria);
    }

    public boolean isK(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.KCriteria);
    }

    public boolean isInverseK(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.inverseKCriteria);
    }

    public boolean isT(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.TCriteria);
    }

    public boolean isInverseT(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.inverseTCriteria);
    }

    public boolean isNormalCorner(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.normalCornerCriteria);
    }

    public boolean isNormalCorner(int n, int n2) {
        return this.isNormalCorner(new Cell(n, n2));
    }

    public boolean isRoundCorner(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.roundCornerCriteria);
    }

    public boolean isRoundCorner(int n, int n2) {
        return this.isRoundCorner(new Cell(n, n2));
    }

    public boolean isIntersection(Cell cell2) {
        return this.matchesAny(cell2, GridPatternGroup.intersectionCriteria);
    }

    public boolean isIntersection(int n, int n2) {
        return this.isIntersection(new Cell(n, n2));
    }

    public void copyCellsTo(CellSet cellSet, TextGrid textGrid) {
        for (Cell cell2 : cellSet) {
            textGrid.set(cell2, this.get(cell2));
        }
    }

    public boolean equals(TextGrid textGrid) {
        if (textGrid.getHeight() != this.getHeight() || textGrid.getWidth() != this.getWidth()) {
            return false;
        }
        int n = textGrid.getHeight();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = this.getRow(i).toString();
            if (string2.equals(string = textGrid.getRow(i).toString())) continue;
            return false;
        }
        return true;
    }

    public void fillCellsWith(Iterable iterable, char c) {
        for (Cell cell2 : iterable) {
            this.set(cell2.x, cell2.y, c);
        }
    }

    public CellSet fillContinuousArea(int n, int n2, char c) {
        return this.fillContinuousArea(new Cell(n, n2), c);
    }

    public CellSet fillContinuousArea(Cell cell2, char c) {
        if (this.isOutOfBounds(cell2)) {
            throw new IllegalArgumentException("Attempted to fill area out of bounds: " + cell2);
        }
        return this.seedFillOld(cell2, c);
    }

    private CellSet seedFill(Cell cell2, char c) {
        CellSet cellSet = new CellSet();
        char c2 = this.get(cell2);
        if (c2 == c) {
            return cellSet;
        }
        if (this.isOutOfBounds(cell2)) {
            return cellSet;
        }
        Stack<Cell> stack2 = new Stack<Cell>();
        stack2.push(cell2);
        while (!stack2.isEmpty()) {
            Cell cell3 = (Cell)stack2.pop();
            cellSet.add(cell3);
            Cell cell4 = cell3.getNorth();
            Cell cell5 = cell3.getSouth();
            Cell cell6 = cell3.getEast();
            Cell cell7 = cell3.getWest();
            if (this.get(cell4) == c2 && !cellSet.contains(cell4)) {
                stack2.push(cell4);
            }
            if (this.get(cell5) == c2 && !cellSet.contains(cell5)) {
                stack2.push(cell5);
            }
            if (this.get(cell6) == c2 && !cellSet.contains(cell6)) {
                stack2.push(cell6);
            }
            if (this.get(cell7) != c2 || cellSet.contains(cell7)) continue;
            stack2.push(cell7);
        }
        return cellSet;
    }

    private CellSet seedFillOld(Cell cell2, char c) {
        CellSet cellSet = new CellSet();
        char c2 = this.get(cell2);
        if (c2 == c) {
            return cellSet;
        }
        if (this.isOutOfBounds(cell2)) {
            return cellSet;
        }
        Stack<Cell> stack2 = new Stack<Cell>();
        stack2.push(cell2);
        while (!stack2.isEmpty()) {
            Cell cell3 = (Cell)stack2.pop();
            this.set(cell3, c);
            cellSet.add(cell3);
            Cell cell4 = cell3.getNorth();
            Cell cell5 = cell3.getSouth();
            Cell cell6 = cell3.getEast();
            Cell cell7 = cell3.getWest();
            if (this.get(cell4) == c2) {
                stack2.push(cell4);
            }
            if (this.get(cell5) == c2) {
                stack2.push(cell5);
            }
            if (this.get(cell6) == c2) {
                stack2.push(cell6);
            }
            if (this.get(cell7) != c2) continue;
            stack2.push(cell7);
        }
        return cellSet;
    }

    public CellSet findBoundariesExpandingFrom(Cell cell2) {
        CellSet cellSet = new CellSet();
        char c = this.get(cell2);
        if (this.isOutOfBounds(cell2)) {
            return cellSet;
        }
        char c2 = '\u0001';
        Stack<Cell> stack2 = new Stack<Cell>();
        stack2.push(cell2);
        while (!stack2.isEmpty()) {
            Cell cell3 = (Cell)stack2.pop();
            this.set(cell3, c2);
            Cell cell4 = cell3.getNorth();
            Cell cell5 = cell3.getSouth();
            Cell cell6 = cell3.getEast();
            Cell cell7 = cell3.getWest();
            if (this.get(cell4) == c) {
                stack2.push(cell4);
            } else if (this.get(cell4) == '*') {
                cellSet.add(cell4);
            }
            if (this.get(cell5) == c) {
                stack2.push(cell5);
            } else if (this.get(cell5) == '*') {
                cellSet.add(cell5);
            }
            if (this.get(cell6) == c) {
                stack2.push(cell6);
            } else if (this.get(cell6) == '*') {
                cellSet.add(cell6);
            }
            if (this.get(cell7) == c) {
                stack2.push(cell7);
                continue;
            }
            if (this.get(cell7) != '*') continue;
            cellSet.add(cell7);
        }
        return cellSet;
    }

    private CellSet seedFillLine(Cell cell2, char c) {
        CellSet cellSet = new CellSet();
        Stack<LineSegment> stack2 = new Stack<LineSegment>();
        char c2 = this.get(cell2);
        if (c2 == c) {
            return cellSet;
        }
        if (this.isOutOfBounds(cell2)) {
            return cellSet;
        }
        stack2.push(new LineSegment(cell2.x, cell2.x, cell2.y, 1));
        stack2.push(new LineSegment(cell2.x, cell2.x, cell2.y + 1, -1));
        while (!stack2.isEmpty()) {
            boolean bl;
            int n;
            LineSegment lineSegment = (LineSegment)stack2.pop();
            for (n = lineSegment.x1; n >= 0 && this.get(n, lineSegment.y) == c2; --n) {
                this.set(n, lineSegment.y, c);
                cellSet.add(new Cell(n, lineSegment.y));
            }
            int n2 = cell2.getEast().x;
            boolean bl2 = bl = n > lineSegment.x1;
            if (n2 < lineSegment.x1) {
                stack2.push(new LineSegment(n, n2, lineSegment.y - 1, -lineSegment.dy));
            }
            n = lineSegment.x1 + 1;
            do {
                if (!bl) {
                    while (n < this.getWidth() && this.get(n, lineSegment.y) == c2) {
                        this.set(n, lineSegment.y, c);
                        cellSet.add(new Cell(n, lineSegment.y));
                        ++n;
                    }
                    stack2.push(new LineSegment(n2, n - 1, lineSegment.y, lineSegment.dy));
                    if (n > lineSegment.x2 + 1) {
                        stack2.push(new LineSegment(lineSegment.x2 + 1, n - 1, lineSegment.y, -lineSegment.dy));
                    }
                }
                bl = false;
                ++n;
                while (n <= lineSegment.x2 && this.get(n, lineSegment.y) != c2) {
                    ++n;
                }
                n2 = n;
            } while (n < lineSegment.x2);
        }
        return cellSet;
    }

    public boolean cellContainsDashedLineChar(Cell cell2) {
        char c = this.get(cell2);
        return StringUtils.isOneOf(c, dashedLines);
    }

    public boolean loadFrom(String string) throws FileNotFoundException, IOException {
        return this.loadFrom(string, null);
    }

    public boolean loadFrom(String string, ProcessingOptions processingOptions) throws IOException {
        String string2 = processingOptions == null ? null : processingOptions.getCharacterEncoding();
        ArrayList<StringBuffer> arrayList = new ArrayList<StringBuffer>();
        String[] stringArray = FileUtils.readFile(new File(string), string2).split("(\r)?\n");
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(new StringBuffer(stringArray[i]));
        }
        return this.initialiseWithLines(arrayList, processingOptions);
    }

    public boolean initialiseWithText(String string, ProcessingOptions processingOptions) throws UnsupportedEncodingException {
        ArrayList<StringBuffer> arrayList = new ArrayList<StringBuffer>();
        String[] stringArray = string.split("(\r)?\n");
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(new StringBuffer(stringArray[i]));
        }
        return this.initialiseWithLines(arrayList, processingOptions);
    }

    public boolean initialiseWithLines(ArrayList<StringBuffer> arrayList, ProcessingOptions processingOptions) throws UnsupportedEncodingException {
        Object object;
        Object object2;
        boolean bl = false;
        int n = arrayList.size() - 1;
        while (!bl) {
            StringBuffer stringBuffer = arrayList.get(n);
            if (!StringUtils.isBlank(stringBuffer.toString())) {
                bl = true;
            }
            --n;
        }
        this.rows = new ArrayList<StringBuffer>(arrayList.subList(0, n + 2));
        if (processingOptions != null) {
            this.fixTabs(processingOptions.getTabSize());
        } else {
            this.fixTabs(8);
        }
        int n2 = 2;
        int n3 = 0;
        int n4 = 0;
        String string = null;
        Iterator<StringBuffer> iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next().toString();
            if (string != null) {
                object = ((String)object2).getBytes();
                object2 = new String((byte[])object, string);
            }
            if (((String)object2).length() > n3) {
                n3 = ((String)object2).length();
            }
            this.rows.set(n4, new StringBuffer((String)object2));
            ++n4;
        }
        iterator = this.rows.iterator();
        object2 = new ArrayList();
        object = new StringBuffer(StringUtils.repeatString(" ", n3 + n2 * 2));
        ((ArrayList)object2).add(object);
        ((ArrayList)object2).add(object);
        while (iterator.hasNext()) {
            StringBuffer stringBuffer = iterator.next();
            if (stringBuffer.length() < n3) {
                String string2 = StringUtils.repeatString(" ", n2);
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(string2);
                stringBuffer2.append(stringBuffer);
                stringBuffer2.append(StringUtils.repeatString(" ", n3 - stringBuffer.length()));
                stringBuffer2.append(string2);
                ((ArrayList)object2).add(stringBuffer2);
                continue;
            }
            ((ArrayList)object2).add(new StringBuffer("  ").append(stringBuffer).append("  "));
        }
        ((ArrayList)object2).add(object);
        ((ArrayList)object2).add(object);
        this.rows = object2;
        this.replaceBullets();
        this.replaceHumanColorCodes();
        return true;
    }

    private void fixTabs(int n) {
        int n2 = 0;
        Iterator<StringBuffer> iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '\t') {
                    int n3 = n - stringBuffer.length() % n;
                    String string2 = StringUtils.repeatString(" ", n3);
                    stringBuffer.append(string2);
                    continue;
                }
                String string3 = Character.toString(cArray[i]);
                stringBuffer.append(string3);
            }
            this.rows.set(n2, stringBuffer);
            ++n2;
        }
    }

    protected ArrayList<StringBuffer> getRows() {
        return this.rows;
    }

    static {
        humanColorCodes.put("GRE", "9D9");
        humanColorCodes.put("BLU", "55B");
        humanColorCodes.put("PNK", "FAA");
        humanColorCodes.put("RED", "E32");
        humanColorCodes.put("YEL", "FF3");
        humanColorCodes.put("BLK", "000");
        markupTags = new HashSet();
        markupTags.add("d");
        markupTags.add("s");
        markupTags.add("io");
        markupTags.add("c");
        markupTags.add("mo");
        markupTags.add("tr");
        markupTags.add("o");
    }

    private class LineSegment {
        int x1;
        int x2;
        int y;
        int dy;

        public LineSegment(int n, int n2, int n3, int n4) {
            this.x1 = n;
            this.x2 = n2;
            this.y = n3;
            this.dy = n4;
        }
    }

    public class Cell {
        public int x;
        public int y;

        public Cell(Cell cell2) {
            this(cell2.x, cell2.y);
        }

        public Cell(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        public Cell getNorth() {
            return new Cell(this.x, this.y - 1);
        }

        public Cell getSouth() {
            return new Cell(this.x, this.y + 1);
        }

        public Cell getEast() {
            return new Cell(this.x + 1, this.y);
        }

        public Cell getWest() {
            return new Cell(this.x - 1, this.y);
        }

        public Cell getNW() {
            return new Cell(this.x - 1, this.y - 1);
        }

        public Cell getNE() {
            return new Cell(this.x + 1, this.y - 1);
        }

        public Cell getSW() {
            return new Cell(this.x - 1, this.y + 1);
        }

        public Cell getSE() {
            return new Cell(this.x + 1, this.y + 1);
        }

        public CellSet getNeighbours4() {
            CellSet cellSet = new CellSet();
            cellSet.add(this.getNorth());
            cellSet.add(this.getSouth());
            cellSet.add(this.getWest());
            cellSet.add(this.getEast());
            return cellSet;
        }

        public CellSet getNeighbours8() {
            CellSet cellSet = new CellSet();
            cellSet.add(this.getNorth());
            cellSet.add(this.getSouth());
            cellSet.add(this.getWest());
            cellSet.add(this.getEast());
            cellSet.add(this.getNW());
            cellSet.add(this.getNE());
            cellSet.add(this.getSW());
            cellSet.add(this.getSE());
            return cellSet;
        }

        public boolean isNorthOf(Cell cell2) {
            return this.y < cell2.y;
        }

        public boolean isSouthOf(Cell cell2) {
            return this.y > cell2.y;
        }

        public boolean isWestOf(Cell cell2) {
            return this.x < cell2.x;
        }

        public boolean isEastOf(Cell cell2) {
            return this.x > cell2.x;
        }

        public boolean equals(Object object) {
            Cell cell2 = (Cell)object;
            if (cell2 == null) {
                return false;
            }
            return this.x == cell2.x && this.y == cell2.y;
        }

        public int hashCode() {
            return this.x << 16 | this.y;
        }

        public boolean isNextTo(int n, int n2) {
            if (Math.abs(n - this.x) == 1 && Math.abs(n2 - this.y) == 1) {
                return false;
            }
            if (Math.abs(n - this.x) == 1 && n2 == this.y) {
                return true;
            }
            return Math.abs(n2 - this.y) == 1 && n == this.x;
        }

        public boolean isNextTo(Cell cell2) {
            if (cell2 == null) {
                throw new IllegalArgumentException("cell cannot be null");
            }
            return this.isNextTo(cell2.x, cell2.y);
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }

        public void scale(int n) {
            this.x *= n;
            this.y *= n;
        }
    }

    public class CellTagPair {
        public Cell cell;
        public String tag;

        public CellTagPair(Cell cell2, String string) {
            this.cell = cell2;
            this.tag = string;
        }
    }

    public class CellStringPair {
        public Cell cell;
        public String string;

        public CellStringPair(Cell cell2, String string) {
            this.cell = cell2;
            this.string = string;
        }
    }

    public class CellColorPair {
        public Color color;
        public Cell cell;

        public CellColorPair(Cell cell2, Color color) {
            this.cell = cell2;
            this.color = color;
        }
    }
}

