/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.client;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.testingisdocumenting.znai.client.OnUploadFinishedClientHandler;
import org.testingisdocumenting.znai.client.ZipTask;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.file.AsyncFile;
import znaishaded.io.vertx.core.file.FileProps;
import znaishaded.io.vertx.core.file.FileSystem;
import znaishaded.io.vertx.core.file.OpenOptions;
import znaishaded.io.vertx.core.http.HttpClient;
import znaishaded.io.vertx.core.http.HttpClientOptions;
import znaishaded.io.vertx.core.http.HttpClientRequest;
import znaishaded.io.vertx.core.streams.Pump;

public class DocumentationUploadClient {
    private final Vertx vertx = Vertx.vertx();
    private final String docId;
    private final Path deployRoot;
    private final String host;
    private final int port;

    public DocumentationUploadClient(String docId, Path deployRoot, String host, int port2) {
        this.docId = docId;
        this.deployRoot = deployRoot;
        this.host = host;
        this.port = port2;
    }

    public void upload(OnUploadFinishedClientHandler onUploadFinish) {
        this.upload(false, onUploadFinish);
    }

    public void uploadWithSsl(OnUploadFinishedClientHandler onUploadFinish) {
        this.upload(true, onUploadFinish);
    }

    private void upload(boolean useSsl, OnUploadFinishedClientHandler onUploadFinish) {
        Path zipPath = this.zipDocs(this.deployRoot);
        this.upload(zipPath, useSsl, onUploadFinish);
    }

    private Path zipDocs(Path dirToZip) {
        ConsoleOutputs.out(new Object[]{Color.BLUE, "zipping: ", Color.PURPLE, dirToZip});
        Path zipDestination = Paths.get(this.docId + ".zip", new String[0]);
        zipDestination.toFile().deleteOnExit();
        ZipTask zipTask = new ZipTask(dirToZip, zipDestination);
        zipTask.execute();
        return zipDestination;
    }

    private void upload(Path path2, boolean useSsl, OnUploadFinishedClientHandler onUploadFinish) {
        ConsoleOutputs.out(new Object[]{Color.BLUE, "uploading documentation: ", Color.GREEN, path2, Color.BLACK, " to ", Color.PURPLE, this.fullUrl(this.docId)});
        HttpClient client = this.vertx.createHttpClient(new HttpClientOptions().setSsl(useSsl));
        HttpClientRequest req = client.put(this.port, this.host, "/upload/" + this.docId, resp -> this.handleUploadFinish(resp.statusCode(), onUploadFinish));
        FileSystem fs = this.vertx.fileSystem();
        fs.props(path2.toString(), ah -> {
            FileProps props = (FileProps)ah.result();
            long size = props.size();
            req.headers().set("content-length", String.valueOf(size));
            fs.open(path2.toString(), new OpenOptions(), oh -> {
                AsyncFile file = (AsyncFile)oh.result();
                Pump pump = Pump.pump(file, req);
                file.endHandler(v -> req.end());
                pump.start();
            });
        });
    }

    private String fullUrl(String docId) {
        return this.host + (this.port != 80 && this.port != 443 ? ":" + this.port : "") + "/" + docId;
    }

    private void handleUploadFinish(int statusCode, OnUploadFinishedClientHandler onUploadFinish) {
        if (statusCode == 200) {
            ConsoleOutputs.out(new Object[]{Color.BLUE, "upload finished"});
        } else {
            ConsoleOutputs.err("upload failed ", statusCode);
        }
        onUploadFinish.onUpload(statusCode);
        this.vertx.close();
    }
}

