/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.image;

import java.awt.image.BufferedImage;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.structure.DocStructure;
import org.testingisdocumenting.znai.utils.FileUtils;
import org.testingisdocumenting.znai.utils.JsonUtils;

public class ImageIncludePlugin
implements IncludePlugin {
    private Path annotationsPath;
    private Path slidesPath;
    private ResourcesResolver resourceResolver;
    private AuxiliaryFile auxiliaryFile;

    @Override
    public String id() {
        return "image";
    }

    @Override
    public IncludePlugin create() {
        return new ImageIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.resourceResolver = componentsRegistry.resourceResolver();
        DocStructure docStructure = componentsRegistry.docStructure();
        String imagePath = pluginParams.getFreeParam();
        this.auxiliaryFile = this.resourceResolver.runtimeAuxiliaryFile(imagePath);
        String annotationsPathValue = (String)pluginParams.getOpts().get("annotationsPath");
        String slidesPathValue = (String)pluginParams.getOpts().get("slidesPath");
        Double scaleRatio = pluginParams.getOpts().get("scaleRatio", 1.0);
        this.annotationsPath = annotationsPathValue != null ? this.resourceResolver.fullPath(annotationsPathValue) : null;
        this.slidesPath = slidesPathValue != null ? this.resourceResolver.fullPath(slidesPathValue) : null;
        Map<String, ?> annotations = this.annotationsPath == null ? null : JsonUtils.deserializeAsMap(FileUtils.fileTextContent(this.annotationsPath));
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(pluginParams.getOpts().toMap());
        props.put("imageSrc", docStructure.fullUrl(this.auxiliaryFile.getDeployRelativePath().toString()));
        props.put("timestamp", componentsRegistry.timeService().fileModifiedTimeMillis(this.auxiliaryFile.getPath()));
        props.put("shapes", annotations != null ? annotations.get("shapes") : Collections.emptyList());
        this.setWidthHeight(props, scaleRatio, annotations, imagePath);
        return PluginResult.docElement("AnnotatedImage", props);
    }

    private void setWidthHeight(Map<String, Object> props, Double scaleRatio, Map<String, ?> annotations, String imagePathValue) {
        Integer pixelRatio = annotations == null || !annotations.containsKey("pixelRatio") ? (Number)1 : (Number)((Number)annotations.get("pixelRatio"));
        BufferedImage bufferedImage = this.resourceResolver.imageContent(imagePathValue);
        props.put("width", scaleRatio * (double)bufferedImage.getWidth() / ((Number)pixelRatio).doubleValue());
        props.put("height", scaleRatio * (double)bufferedImage.getHeight() / ((Number)pixelRatio).doubleValue());
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.concat(Stream.of(this.auxiliaryFile), this.annotationsPath != null ? Stream.of(AuxiliaryFile.builtTime(this.annotationsPath)) : Stream.empty());
    }
}

