/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.server.auth;

import java.util.Set;
import org.testingisdocumenting.znai.server.auth.AuthorizationHandler;
import org.testingisdocumenting.znai.utils.ServiceLoaderUtils;

public class AuthorizationHandlers {
    private static final Set<AuthorizationHandler> handlers = ServiceLoaderUtils.load(AuthorizationHandler.class);

    public static boolean isAuthorized(String userId, String docId) {
        if (handlers.isEmpty()) {
            return true;
        }
        return handlers.stream().anyMatch(h2 -> h2.isAuthorized(userId, docId));
    }

    public static void add(AuthorizationHandler handler) {
        handlers.add(handler);
    }

    public static void remove(AuthorizationHandler handler) {
        handlers.remove(handler);
    }
}

