/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.structure;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testingisdocumenting.znai.utils.JsonUtils;

public class DocMeta {
    public static final String META_FILE_NAME = "meta.json";
    private String id;
    private final String type;
    private final String title;
    private final String category;
    private final String description;
    private final List<String> allowedUsers;
    private final List<String> allowedGroups;
    private boolean previewEnabled;
    private final Map<String, ?> docMetaMap;

    public DocMeta(String metaJson) {
        this(JsonUtils.deserializeAsMap(metaJson));
    }

    public DocMeta(Map<String, ?> docMetaMap) {
        this.id = DocMeta.stringValue(docMetaMap, "id", "");
        this.type = DocMeta.stringValue(docMetaMap, "type", "no-type");
        this.title = DocMeta.stringValue(docMetaMap, "title", "no-title");
        this.category = DocMeta.stringValue(docMetaMap, "category", "Un-categorized");
        this.description = DocMeta.stringValue(docMetaMap, "description", "no description");
        this.allowedUsers = DocMeta.stringList(docMetaMap, "allowedUsers");
        this.allowedGroups = DocMeta.stringList(docMetaMap, "allowedGroups");
        this.docMetaMap = docMetaMap;
    }

    public DocMeta cloneWithNewJson(String docMetaJson) {
        DocMeta clone = new DocMeta(docMetaJson);
        clone.setId(this.id);
        clone.setPreviewEnabled(this.previewEnabled);
        return clone;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getAllowedUsers() {
        return this.allowedUsers;
    }

    public List<String> getAllowedGroups() {
        return this.allowedGroups;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", this.id);
        result.put("previewEnabled", this.previewEnabled);
        result.putAll(this.docMetaMap);
        return result;
    }

    public boolean isPreviewEnabled() {
        return this.previewEnabled;
    }

    public void setPreviewEnabled(boolean previewEnabled) {
        this.previewEnabled = previewEnabled;
    }

    private static String stringValue(Map<String, ?> docMetaMap, String key, String defaultValue) {
        return docMetaMap.containsKey(key) ? docMetaMap.get(key).toString() : defaultValue;
    }

    private static List<String> stringList(Map<String, ?> docMetaMap, String key) {
        Object value = docMetaMap.get(key);
        return value != null ? (List)value : Collections.emptyList();
    }
}

