/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.ctreber.acearth.util;

import java.io.IOException;
import java.io.Writer;
import znaishaded.com.ctreber.acearth.util.Point3D;
import znaishaded.com.ctreber.acearth.util.Toolkit;

public class Coordinate {
    private static final double MEAN_OBLIQUITY = 0.4091155090166427;
    private double fLat;
    private double fLong;

    public Coordinate() {
    }

    public Coordinate(double d, double d2) {
        this.fLat = d;
        this.fLong = d2;
    }

    public void renderAsXML(Writer writer) throws IOException {
        writer.write("<Coordinate>\n");
        writer.write("  <latitude>" + this.fLat + "</latitude>\n");
        writer.write("  <longitude>" + this.fLong + "</longitude>\n");
        writer.write("</Coordinate>\n");
    }

    public Point3D getPoint3D() {
        double d = Toolkit.degsToRads(this.fLat);
        double d2 = Toolkit.degsToRads(this.fLong);
        double d3 = Math.cos(d) * Math.sin(d2);
        double d4 = Math.sin(d);
        double d5 = Math.cos(d) * Math.cos(d2);
        return new Point3D(d3, d4, d5);
    }

    public Point3D getPoint3DRads() {
        double d = Math.cos(this.fLat) * Math.sin(this.fLong);
        double d2 = Math.sin(this.fLat);
        double d3 = Math.cos(this.fLat) * Math.cos(this.fLong);
        return new Point3D(d, d2, d3);
    }

    public Coordinate eclipticToEquatorial() {
        double d = Math.sin(0.4091155090166427);
        double d2 = Math.cos(0.4091155090166427);
        double d3 = Math.atan2(Math.sin(this.fLong) * d2 - Math.tan(this.fLat) * d, Math.cos(this.fLong));
        double d4 = Math.asin(Math.sin(this.fLat) * d2 + Math.cos(this.fLat) * d * Math.sin(this.fLong));
        return new Coordinate(d4, d3);
    }

    public void add(Coordinate coordinate) {
        this.fLat += coordinate.fLat;
        this.fLong += coordinate.fLong;
        this.wrap();
    }

    public void wrap() {
        if (this.fLat > 90.0) {
            this.fLat = 180.0 - this.fLat;
            this.fLong += 180.0;
        } else if (this.fLat < -90.0) {
            this.fLat = -180.0 - this.fLat;
            this.fLong += 180.0;
        }
        if (this.fLong > 180.0) {
            do {
                this.fLong -= 360.0;
            } while (this.fLong > 180.0);
        } else if (this.fLong < -180.0) {
            do {
                this.fLong += 360.0;
            } while (this.fLong < -180.0);
        }
    }

    public double getLat() {
        return this.fLat;
    }

    public double getDE() {
        return this.fLat;
    }

    public double getLong() {
        return this.fLong;
    }

    public double getRA() {
        return this.fLong;
    }

    public boolean check() {
        return -90.0 <= this.fLat && this.fLat <= 90.0 && -180.0 <= this.fLong && this.fLong <= 180.0;
    }

    public String toString() {
        return "lat: " + this.fLat + ", long: " + this.fLong;
    }
}

