/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core;

import java.util.Objects;
import znaishaded.io.vertx.codegen.annotations.DataObject;
import znaishaded.io.vertx.core.VertxOptionsConverter;
import znaishaded.io.vertx.core.dns.AddressResolverOptions;
import znaishaded.io.vertx.core.eventbus.EventBusOptions;
import znaishaded.io.vertx.core.impl.cpu.CpuCoreSensor;
import znaishaded.io.vertx.core.json.JsonObject;
import znaishaded.io.vertx.core.metrics.MetricsOptions;
import znaishaded.io.vertx.core.spi.cluster.ClusterManager;

@DataObject(generateConverter=true, publicConverter=false)
public class VertxOptions {
    public static final int DEFAULT_EVENT_LOOP_POOL_SIZE = 2 * CpuCoreSensor.availableProcessors();
    public static final int DEFAULT_WORKER_POOL_SIZE = 20;
    public static final int DEFAULT_INTERNAL_BLOCKING_POOL_SIZE = 20;
    public static final boolean DEFAULT_CLUSTERED = false;
    public static final String DEFAULT_CLUSTER_HOST = "localhost";
    public static final int DEFAULT_CLUSTER_PORT = 0;
    public static final String DEFAULT_CLUSTER_PUBLIC_HOST = null;
    public static final int DEFAULT_CLUSTER_PUBLIC_PORT = -1;
    public static final long DEFAULT_CLUSTER_PING_INTERVAL = 20000L;
    public static final long DEFAULT_CLUSTER_PING_REPLY_INTERVAL = 20000L;
    public static final long DEFAULT_BLOCKED_THREAD_CHECK_INTERVAL = 1000L;
    public static final long DEFAULT_MAX_EVENT_LOOP_EXECUTE_TIME = 2000000000L;
    public static final long DEFAULT_MAX_WORKER_EXECUTE_TIME = 60000000000L;
    public static final int DEFAULT_QUORUM_SIZE = 1;
    public static final String DEFAULT_HA_GROUP = "__DEFAULT__";
    public static final boolean DEFAULT_HA_ENABLED = false;
    public static final boolean DEFAULT_FILE_CACHING_ENABLED = !Boolean.getBoolean("vertx.disableFileCaching");
    public static final boolean DEFAULT_PREFER_NATIVE_TRANSPORT = false;
    private static final long DEFAULT_WARNING_EXCEPTION_TIME = 5000000000L;
    private int eventLoopPoolSize = DEFAULT_EVENT_LOOP_POOL_SIZE;
    private int workerPoolSize = 20;
    private int internalBlockingPoolSize = 20;
    private long blockedThreadCheckInterval = 1000L;
    private long maxEventLoopExecuteTime = 2000000000L;
    private long maxWorkerExecuteTime = 60000000000L;
    private ClusterManager clusterManager;
    private boolean haEnabled = false;
    private int quorumSize = 1;
    private String haGroup = "__DEFAULT__";
    private MetricsOptions metricsOptions = new MetricsOptions();
    private long warningExceptionTime = 5000000000L;
    private EventBusOptions eventBusOptions = new EventBusOptions();
    private AddressResolverOptions addressResolverOptions = new AddressResolverOptions();
    private boolean fileResolverCachingEnabled = DEFAULT_FILE_CACHING_ENABLED;
    private boolean preferNativeTransport = false;

    public VertxOptions() {
    }

    public VertxOptions(VertxOptions other) {
        this.eventLoopPoolSize = other.getEventLoopPoolSize();
        this.workerPoolSize = other.getWorkerPoolSize();
        this.blockedThreadCheckInterval = other.getBlockedThreadCheckInterval();
        this.maxEventLoopExecuteTime = other.getMaxEventLoopExecuteTime();
        this.maxWorkerExecuteTime = other.getMaxWorkerExecuteTime();
        this.internalBlockingPoolSize = other.getInternalBlockingPoolSize();
        this.clusterManager = other.getClusterManager();
        this.haEnabled = other.isHAEnabled();
        this.quorumSize = other.getQuorumSize();
        this.haGroup = other.getHAGroup();
        this.metricsOptions = other.getMetricsOptions() != null ? new MetricsOptions(other.getMetricsOptions()) : null;
        this.warningExceptionTime = other.warningExceptionTime;
        this.eventBusOptions = new EventBusOptions(other.eventBusOptions);
        this.addressResolverOptions = other.addressResolverOptions != null ? new AddressResolverOptions() : null;
        this.fileResolverCachingEnabled = other.fileResolverCachingEnabled;
    }

    public VertxOptions(JsonObject json) {
        this();
        VertxOptionsConverter.fromJson(json, this);
    }

    public int getEventLoopPoolSize() {
        return this.eventLoopPoolSize;
    }

    public VertxOptions setEventLoopPoolSize(int eventLoopPoolSize) {
        if (eventLoopPoolSize < 1) {
            throw new IllegalArgumentException("eventLoopPoolSize must be > 0");
        }
        this.eventLoopPoolSize = eventLoopPoolSize;
        return this;
    }

    public int getWorkerPoolSize() {
        return this.workerPoolSize;
    }

    public VertxOptions setWorkerPoolSize(int workerPoolSize) {
        if (workerPoolSize < 1) {
            throw new IllegalArgumentException("workerPoolSize must be > 0");
        }
        this.workerPoolSize = workerPoolSize;
        return this;
    }

    public boolean isClustered() {
        return this.eventBusOptions.isClustered();
    }

    public VertxOptions setClustered(boolean clustered) {
        this.eventBusOptions.setClustered(clustered);
        return this;
    }

    public String getClusterHost() {
        return this.eventBusOptions.getHost();
    }

    public VertxOptions setClusterHost(String clusterHost) {
        this.eventBusOptions.setHost(clusterHost);
        return this;
    }

    public String getClusterPublicHost() {
        return this.getEventBusOptions().getClusterPublicHost();
    }

    public VertxOptions setClusterPublicHost(String clusterPublicHost) {
        this.getEventBusOptions().setClusterPublicHost(clusterPublicHost);
        return this;
    }

    public int getClusterPort() {
        return this.eventBusOptions.getPort();
    }

    public VertxOptions setClusterPort(int clusterPort) {
        this.eventBusOptions.setPort(clusterPort);
        return this;
    }

    public int getClusterPublicPort() {
        return this.eventBusOptions.getClusterPublicPort();
    }

    public VertxOptions setClusterPublicPort(int clusterPublicPort) {
        this.getEventBusOptions().setClusterPublicPort(clusterPublicPort);
        return this;
    }

    public long getClusterPingInterval() {
        return this.getEventBusOptions().getClusterPingInterval();
    }

    public VertxOptions setClusterPingInterval(long clusterPingInterval) {
        this.eventBusOptions.setClusterPingInterval(clusterPingInterval);
        return this;
    }

    public long getClusterPingReplyInterval() {
        return this.eventBusOptions.getClusterPingReplyInterval();
    }

    public VertxOptions setClusterPingReplyInterval(long clusterPingReplyInterval) {
        this.eventBusOptions.setClusterPingReplyInterval(clusterPingReplyInterval);
        return this;
    }

    public long getBlockedThreadCheckInterval() {
        return this.blockedThreadCheckInterval;
    }

    public VertxOptions setBlockedThreadCheckInterval(long blockedThreadCheckInterval) {
        if (blockedThreadCheckInterval < 1L) {
            throw new IllegalArgumentException("blockedThreadCheckInterval must be > 0");
        }
        this.blockedThreadCheckInterval = blockedThreadCheckInterval;
        return this;
    }

    public long getMaxEventLoopExecuteTime() {
        return this.maxEventLoopExecuteTime;
    }

    public VertxOptions setMaxEventLoopExecuteTime(long maxEventLoopExecuteTime) {
        if (maxEventLoopExecuteTime < 1L) {
            throw new IllegalArgumentException("maxEventLoopExecuteTime must be > 0");
        }
        this.maxEventLoopExecuteTime = maxEventLoopExecuteTime;
        return this;
    }

    public long getMaxWorkerExecuteTime() {
        return this.maxWorkerExecuteTime;
    }

    public VertxOptions setMaxWorkerExecuteTime(long maxWorkerExecuteTime) {
        if (maxWorkerExecuteTime < 1L) {
            throw new IllegalArgumentException("maxWorkerpExecuteTime must be > 0");
        }
        this.maxWorkerExecuteTime = maxWorkerExecuteTime;
        return this;
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public VertxOptions setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
        return this;
    }

    public int getInternalBlockingPoolSize() {
        return this.internalBlockingPoolSize;
    }

    public VertxOptions setInternalBlockingPoolSize(int internalBlockingPoolSize) {
        if (internalBlockingPoolSize < 1) {
            throw new IllegalArgumentException("internalBlockingPoolSize must be > 0");
        }
        this.internalBlockingPoolSize = internalBlockingPoolSize;
        return this;
    }

    public boolean isHAEnabled() {
        return this.haEnabled;
    }

    public VertxOptions setHAEnabled(boolean haEnabled) {
        this.haEnabled = haEnabled;
        return this;
    }

    public int getQuorumSize() {
        return this.quorumSize;
    }

    public VertxOptions setQuorumSize(int quorumSize) {
        if (quorumSize < 1) {
            throw new IllegalArgumentException("quorumSize should be >= 1");
        }
        this.quorumSize = quorumSize;
        return this;
    }

    public String getHAGroup() {
        return this.haGroup;
    }

    public VertxOptions setHAGroup(String haGroup) {
        Objects.requireNonNull(haGroup, "ha group cannot be null");
        this.haGroup = haGroup;
        return this;
    }

    public MetricsOptions getMetricsOptions() {
        return this.metricsOptions;
    }

    public VertxOptions setMetricsOptions(MetricsOptions metrics) {
        this.metricsOptions = metrics;
        return this;
    }

    public long getWarningExceptionTime() {
        return this.warningExceptionTime;
    }

    public VertxOptions setWarningExceptionTime(long warningExceptionTime) {
        if (warningExceptionTime < 1L) {
            throw new IllegalArgumentException("warningExceptionTime must be > 0");
        }
        this.warningExceptionTime = warningExceptionTime;
        return this;
    }

    public EventBusOptions getEventBusOptions() {
        return this.eventBusOptions;
    }

    public VertxOptions setEventBusOptions(EventBusOptions options) {
        Objects.requireNonNull(options);
        this.eventBusOptions = options;
        return this;
    }

    public AddressResolverOptions getAddressResolverOptions() {
        return this.addressResolverOptions;
    }

    public VertxOptions setAddressResolverOptions(AddressResolverOptions addressResolverOptions) {
        this.addressResolverOptions = addressResolverOptions;
        return this;
    }

    public boolean isFileResolverCachingEnabled() {
        return this.fileResolverCachingEnabled;
    }

    public VertxOptions setFileResolverCachingEnabled(boolean fileResolverCachingEnabled) {
        this.fileResolverCachingEnabled = fileResolverCachingEnabled;
        return this;
    }

    public boolean getPreferNativeTransport() {
        return this.preferNativeTransport;
    }

    public VertxOptions setPreferNativeTransport(boolean preferNativeTransport) {
        this.preferNativeTransport = preferNativeTransport;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VertxOptions that = (VertxOptions)o;
        if (this.eventLoopPoolSize != that.eventLoopPoolSize) {
            return false;
        }
        if (this.workerPoolSize != that.workerPoolSize) {
            return false;
        }
        if (this.internalBlockingPoolSize != that.internalBlockingPoolSize) {
            return false;
        }
        if (this.blockedThreadCheckInterval != that.blockedThreadCheckInterval) {
            return false;
        }
        if (this.maxEventLoopExecuteTime != that.maxEventLoopExecuteTime) {
            return false;
        }
        if (this.maxWorkerExecuteTime != that.maxWorkerExecuteTime) {
            return false;
        }
        if (this.haEnabled != that.haEnabled) {
            return false;
        }
        if (this.quorumSize != that.quorumSize) {
            return false;
        }
        if (this.warningExceptionTime != that.warningExceptionTime) {
            return false;
        }
        if (this.clusterManager != null ? !this.clusterManager.equals(that.clusterManager) : that.clusterManager != null) {
            return false;
        }
        if (this.haGroup != null ? !this.haGroup.equals(that.haGroup) : that.haGroup != null) {
            return false;
        }
        if (this.eventBusOptions != null ? !this.eventBusOptions.equals(that.eventBusOptions) : that.eventBusOptions != null) {
            return false;
        }
        if (this.addressResolverOptions != null ? !this.addressResolverOptions.equals(that.addressResolverOptions) : that.addressResolverOptions != null) {
            return false;
        }
        if (this.fileResolverCachingEnabled != that.fileResolverCachingEnabled) {
            return false;
        }
        if (this.preferNativeTransport != that.preferNativeTransport) {
            return false;
        }
        return !(this.metricsOptions == null ? that.metricsOptions != null : !this.metricsOptions.equals(that.metricsOptions));
    }

    public int hashCode() {
        int result = this.eventLoopPoolSize;
        result = 31 * result + this.workerPoolSize;
        result = 31 * result + this.internalBlockingPoolSize;
        result = 31 * result + (int)(this.blockedThreadCheckInterval ^ this.blockedThreadCheckInterval >>> 32);
        result = 31 * result + (int)(this.maxEventLoopExecuteTime ^ this.maxEventLoopExecuteTime >>> 32);
        result = 31 * result + (int)(this.maxWorkerExecuteTime ^ this.maxWorkerExecuteTime >>> 32);
        result = 31 * result + (this.clusterManager != null ? this.clusterManager.hashCode() : 0);
        result = 31 * result + (this.haEnabled ? 1 : 0);
        result = 31 * result + (this.fileResolverCachingEnabled ? 1 : 0);
        result = 31 * result + (this.preferNativeTransport ? 1 : 0);
        result = 31 * result + this.quorumSize;
        result = 31 * result + (this.haGroup != null ? this.haGroup.hashCode() : 0);
        result = 31 * result + (this.metricsOptions != null ? this.metricsOptions.hashCode() : 0);
        result = 31 * result + (this.eventBusOptions != null ? this.eventBusOptions.hashCode() : 0);
        result = 31 * result + (this.addressResolverOptions != null ? this.addressResolverOptions.hashCode() : 0);
        result = 31 * result + (int)(this.warningExceptionTime ^ this.warningExceptionTime >>> 32);
        return result;
    }

    public String toString() {
        return "VertxOptions{eventLoopPoolSize=" + this.eventLoopPoolSize + ", workerPoolSize=" + this.workerPoolSize + ", internalBlockingPoolSize=" + this.internalBlockingPoolSize + ", blockedThreadCheckInterval=" + this.blockedThreadCheckInterval + ", maxEventLoopExecuteTime=" + this.maxEventLoopExecuteTime + ", maxWorkerExecuteTime=" + this.maxWorkerExecuteTime + ", clusterManager=" + this.clusterManager + ", haEnabled=" + this.haEnabled + ", fileCachingEnabled=" + this.fileResolverCachingEnabled + ", preferNativeTransport=" + this.preferNativeTransport + ", quorumSize=" + this.quorumSize + ", haGroup='" + this.haGroup + '\'' + ", metrics=" + this.metricsOptions + ", addressResolver=" + this.addressResolverOptions.toJson() + ", addressResolver=" + this.addressResolverOptions.toJson() + ", eventbus=" + this.eventBusOptions.toJson() + ", warningExceptionTime=" + this.warningExceptionTime + '}';
    }
}

