/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.impl.launcher.commands;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.DeploymentOptions;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.VertxOptions;
import znaishaded.io.vertx.core.cli.annotations.Description;
import znaishaded.io.vertx.core.cli.annotations.Option;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.core.spi.launcher.DefaultCommand;

public abstract class ClasspathHandler
extends DefaultCommand {
    protected static final String PATH_SEP = System.getProperty("path.separator");
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected List<String> classpath;
    protected Object manager;
    private ClassLoader classloader;

    @Option(shortName="cp", longName="classpath", argName="classpath")
    @Description(value="Provides an extra classpath to be used for the verticle deployment.")
    public void setClasspath(String classpath) {
        if (classpath == null || classpath.isEmpty()) {
            this.classloader = ClasspathHandler.class.getClassLoader();
            this.classpath = Collections.emptyList();
        } else {
            this.classpath = Arrays.asList(classpath.split(PATH_SEP));
            this.classloader = this.createClassloader();
        }
    }

    protected synchronized ClassLoader createClassloader() {
        URL[] urls = (URL[])this.classpath.stream().map(path2 -> {
            File file = new File((String)path2);
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }).toArray(URL[]::new);
        return new URLClassLoader(urls, this.getClass().getClassLoader());
    }

    protected synchronized Object newInstance() {
        try {
            this.classloader = this.classpath == null || this.classpath.isEmpty() ? ClasspathHandler.class.getClassLoader() : this.createClassloader();
            Class<?> clazz = this.classloader.loadClass("znaishaded.io.vertx.core.impl.launcher.commands.VertxIsolatedDeployer");
            return clazz.newInstance();
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to load or instantiate the isolated deployer", e);
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Vertx create(VertxOptions options) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader != null ? this.classloader : this.getClass().getClassLoader());
            Vertx vertx = Vertx.vertx(options);
            return vertx;
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to create the vert.x instance", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void create(VertxOptions options, Handler<AsyncResult<Vertx>> resultHandler) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader != null ? this.classloader : this.getClass().getClassLoader());
            Vertx.clusteredVertx(options, resultHandler);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to create the vert.x instance", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deploy(String verticle, Vertx vertx, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        if (this.manager == null) {
            this.manager = this.newInstance();
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            Method method = this.manager.getClass().getMethod("deploy", String.class, Vertx.class, DeploymentOptions.class, Handler.class);
            method.invoke(this.manager, verticle, vertx, options, completionHandler);
        }
        catch (InvocationTargetException e) {
            this.log.error((Object)("Failed to deploy verticle " + verticle), e.getCause());
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to deploy verticle " + verticle), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

