/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.net.impl.transport;

import java.net.InetSocketAddress;
import java.util.concurrent.ThreadFactory;
import znaishaded.io.netty.bootstrap.Bootstrap;
import znaishaded.io.netty.bootstrap.ServerBootstrap;
import znaishaded.io.netty.channel.Channel;
import znaishaded.io.netty.channel.EventLoopGroup;
import znaishaded.io.netty.channel.ServerChannel;
import znaishaded.io.netty.channel.epoll.Epoll;
import znaishaded.io.netty.channel.epoll.EpollChannelOption;
import znaishaded.io.netty.channel.epoll.EpollDatagramChannel;
import znaishaded.io.netty.channel.epoll.EpollDomainSocketChannel;
import znaishaded.io.netty.channel.epoll.EpollEventLoopGroup;
import znaishaded.io.netty.channel.epoll.EpollServerDomainSocketChannel;
import znaishaded.io.netty.channel.epoll.EpollServerSocketChannel;
import znaishaded.io.netty.channel.epoll.EpollSocketChannel;
import znaishaded.io.netty.channel.socket.DatagramChannel;
import znaishaded.io.netty.channel.socket.InternetProtocolFamily;
import znaishaded.io.netty.channel.unix.DomainSocketAddress;
import znaishaded.io.vertx.core.datagram.DatagramSocketOptions;
import znaishaded.io.vertx.core.net.ClientOptionsBase;
import znaishaded.io.vertx.core.net.NetServerOptions;
import znaishaded.io.vertx.core.net.SocketAddress;
import znaishaded.io.vertx.core.net.impl.transport.Transport;

class EpollTransport
extends Transport {
    private static volatile int pendingFastOpenRequestsThreshold = 256;

    public static int getPendingFastOpenRequestsThreshold() {
        return pendingFastOpenRequestsThreshold;
    }

    public static void setPendingFastOpenRequestsThreshold(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Invalid " + value);
        }
        pendingFastOpenRequestsThreshold = value;
    }

    EpollTransport() {
    }

    @Override
    public java.net.SocketAddress convert(SocketAddress address, boolean resolved) {
        if (address.path() != null) {
            return new DomainSocketAddress(address.path());
        }
        if (resolved) {
            return new InetSocketAddress(address.host(), address.port());
        }
        return InetSocketAddress.createUnresolved(address.host(), address.port());
    }

    @Override
    public boolean isAvailable() {
        return Epoll.isAvailable();
    }

    @Override
    public Throwable unavailabilityCause() {
        return Epoll.unavailabilityCause();
    }

    @Override
    public EventLoopGroup eventLoopGroup(int nThreads, ThreadFactory threadFactory, int ioRatio) {
        EpollEventLoopGroup eventLoopGroup = new EpollEventLoopGroup(nThreads, threadFactory);
        eventLoopGroup.setIoRatio(ioRatio);
        return eventLoopGroup;
    }

    @Override
    public DatagramChannel datagramChannel() {
        return new EpollDatagramChannel();
    }

    @Override
    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        return new EpollDatagramChannel();
    }

    @Override
    public Class<? extends Channel> channelType(boolean domain) {
        if (domain) {
            return EpollDomainSocketChannel.class;
        }
        return EpollSocketChannel.class;
    }

    @Override
    public Class<? extends ServerChannel> serverChannelType(boolean domain) {
        if (domain) {
            return EpollServerDomainSocketChannel.class;
        }
        return EpollServerSocketChannel.class;
    }

    @Override
    public void configure(DatagramChannel channel2, DatagramSocketOptions options) {
        channel2.config().setOption(EpollChannelOption.SO_REUSEPORT, options.isReusePort());
        super.configure(channel2, options);
    }

    @Override
    public void configure(NetServerOptions options, ServerBootstrap bootstrap) {
        bootstrap.option(EpollChannelOption.SO_REUSEPORT, options.isReusePort());
        if (options.isTcpFastOpen()) {
            bootstrap.option(EpollChannelOption.TCP_FASTOPEN, options.isTcpFastOpen() ? pendingFastOpenRequestsThreshold : 0);
        }
        bootstrap.childOption(EpollChannelOption.TCP_QUICKACK, options.isTcpQuickAck());
        bootstrap.childOption(EpollChannelOption.TCP_CORK, options.isTcpCork());
        super.configure(options, bootstrap);
    }

    @Override
    public void configure(ClientOptionsBase options, Bootstrap bootstrap) {
        if (options.isTcpFastOpen()) {
            bootstrap.option(EpollChannelOption.TCP_FASTOPEN_CONNECT, options.isTcpFastOpen());
        }
        bootstrap.option(EpollChannelOption.TCP_QUICKACK, options.isTcpQuickAck());
        bootstrap.option(EpollChannelOption.TCP_CORK, options.isTcpCork());
        super.configure(options, bootstrap);
    }
}

