/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.handler.impl;

import znaishaded.io.vertx.ext.auth.AuthProvider;
import znaishaded.io.vertx.ext.auth.User;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.Session;
import znaishaded.io.vertx.ext.web.handler.UserSessionHandler;
import znaishaded.io.vertx.ext.web.handler.impl.UserHolder;

public class UserSessionHandlerImpl
implements UserSessionHandler {
    private static final String SESSION_USER_HOLDER_KEY = "__vertx.userHolder";
    private final AuthProvider authProvider;

    public UserSessionHandlerImpl(AuthProvider authProvider) {
        this.authProvider = authProvider;
    }

    @Override
    public void handle(RoutingContext routingContext) {
        Session session = routingContext.session();
        if (session != null) {
            User user = null;
            UserHolder holder = (UserHolder)session.get(SESSION_USER_HOLDER_KEY);
            if (holder != null) {
                RoutingContext prevContext = holder.context;
                if (prevContext != null) {
                    user = prevContext.user();
                } else if (holder.user != null) {
                    user = holder.user;
                    user.setAuthProvider(this.authProvider);
                    holder.context = routingContext;
                    holder.user = null;
                }
                holder.context = routingContext;
            } else {
                routingContext.addHeadersEndHandler(v -> {
                    if (routingContext.user() != null) {
                        session.put(SESSION_USER_HOLDER_KEY, new UserHolder(routingContext));
                    }
                });
            }
            if (user != null) {
                routingContext.setUser(user);
            }
        }
        routingContext.next();
    }
}

