/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.Branch;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileAssemblySimple;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileMinWidth;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.MergeStrategy;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.UGraphicInterceptorOneSwimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfWithLinks;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside2;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.Rainbow;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.svek.ConditionStyle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FtileIfLongHorizontal
extends AbstractFtile {
    private final double xSeparation = 20.0;
    private final List<Ftile> tiles;
    private final Ftile tile2;
    private final List<Ftile> diamonds;
    private final List<Ftile> couples = new ArrayList<Ftile>();
    private final Rainbow arrowColor;

    private FtileIfLongHorizontal(List<Ftile> list, List<Double> list2, List<Ftile> list3, Ftile ftile, Rainbow rainbow) {
        super(list3.get(0).skinParam());
        if (list.size() != list3.size()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < list.size(); ++i) {
            Ftile ftile2 = list.get(i);
            FtileAssemblySimple ftileAssemblySimple = new FtileAssemblySimple(ftile2, list3.get(i));
            this.couples.add(FtileUtils.addHorizontalMargin(ftileAssemblySimple, list2.get(i), 0.0));
        }
        this.tile2 = ftile;
        this.diamonds = new ArrayList<Ftile>(list);
        this.tiles = new ArrayList<Ftile>(list3);
        this.arrowColor = rainbow;
    }

    private static List<Ftile> alignDiamonds(List<Ftile> list, StringBounder stringBounder) {
        double d = 0.0;
        for (Ftile ftile : list) {
            d = Math.max(d, ftile.calculateDimension(stringBounder).getOutY());
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            Ftile ftile = list.get(i);
            double d2 = d - ftile.calculateDimension(stringBounder).getOutY();
            assert (d2 >= 0.0);
            ftile = FtileUtils.addVerticalMargin(ftile, d2 / 2.0, 20.0);
            arrayList.add(ftile);
        }
        return arrayList;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        if (this.getSwimlaneIn() != null) {
            hashSet.add(this.getSwimlaneIn());
        }
        for (Ftile ftile : this.couples) {
            hashSet.addAll(ftile.getSwimlanes());
        }
        hashSet.addAll(this.tile2.getSwimlanes());
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.couples.get(0).getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    static Ftile create(Swimlane swimlane, HtmlColor htmlColor, HtmlColor htmlColor2, Rainbow rainbow, FtileFactory ftileFactory, ConditionStyle conditionStyle, List<Branch> list, Branch branch, FontConfiguration fontConfiguration, LinkRendering linkRendering, LinkRendering linkRendering2) {
        Object object;
        TextBlock textBlock;
        Ftile rainbow4;
        Object object2;
        TextBlock textBlock2;
        if (linkRendering2 == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Ftile> arrayList = new ArrayList<Ftile>();
        for (Branch list22 : list) {
            arrayList.add(new FtileMinWidth(list22.getFtile(), 30.0));
        }
        FtileMinWidth ftileMinWidth = new FtileMinWidth(branch.getFtile(), 30.0);
        ArrayList<Ftile> arrayList2 = new ArrayList<Ftile>();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        for (Branch branch2 : list) {
            textBlock2 = branch2.getLabelPositive().create(fontConfiguration, HorizontalAlignment.LEFT, ftileFactory.skinParam());
            object2 = branch2.getLabelTest().create(fontConfiguration, HorizontalAlignment.LEFT, ftileFactory.skinParam());
            HtmlColor rainbow3 = branch2.getColor() == null ? htmlColor2 : branch2.getColor();
            rainbow4 = new FtileDiamondInside2(branch2.skinParam(), rainbow3, htmlColor, swimlane, (TextBlock)object2);
            textBlock = null;
            if (Display.isNull(branch2.getInlabel())) {
                arrayList3.add(0.0);
            } else {
                textBlock = branch2.getInlabel().create(fontConfiguration, HorizontalAlignment.LEFT, ftileFactory.skinParam());
                arrayList3.add(textBlock.calculateDimension(ftileFactory.getStringBounder()).getWidth());
                rainbow4 = ((FtileDiamondInside2)rainbow4).withWest(textBlock);
            }
            rainbow4 = ((FtileDiamondInside2)rainbow4).withNorth(textBlock2);
            arrayList2.add(rainbow4);
        }
        TextBlock textBlock3 = branch.getLabelPositive().create(fontConfiguration, HorizontalAlignment.LEFT, ftileFactory.skinParam());
        int n = arrayList2.size() - 1;
        arrayList2.set(n, ((FtileDiamondInside2)arrayList2.get(n)).withEast(textBlock3));
        List<Ftile> list2 = FtileIfLongHorizontal.alignDiamonds(arrayList2, ftileFactory.getStringBounder());
        textBlock2 = new FtileIfLongHorizontal(list2, arrayList3, arrayList, ftileMinWidth, rainbow);
        object2 = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            rainbow4 = (Ftile)arrayList.get(i);
            textBlock = list2.get(i);
            object = FtileIfWithLinks.getInColor(list.get(i), rainbow);
            Branch branch3 = list.get(i);
            Rainbow rainbow2 = branch3.getInlinkRenderingColorAndStyle();
            TextBlock textBlock4 = textBlock2;
            textBlock4.getClass();
            object2.add((FtileIfLongHorizontal)textBlock4.new ConnectionVerticalIn((Ftile)textBlock, rainbow4, (Rainbow)(((Rainbow)object).size() == 0 ? rainbow : object)));
            TextBlock textBlock5 = textBlock2;
            textBlock5.getClass();
            object2.add((FtileIfLongHorizontal)textBlock5.new ConnectionVerticalOut(rainbow4, rainbow2.size() == 0 ? rainbow : rainbow2));
        }
        Rainbow rainbow3 = linkRendering.getRainbow(rainbow);
        for (int i = 0; i < list2.size() - 1; ++i) {
            textBlock = list2.get(i);
            object = list2.get(i + 1);
            TextBlock textBlock6 = textBlock2;
            textBlock6.getClass();
            object2.add((FtileIfLongHorizontal)textBlock6.new ConnectionHorizontal((Ftile)textBlock, (Ftile)object, rainbow));
        }
        TextBlock textBlock7 = textBlock2;
        textBlock7.getClass();
        object2.add((FtileIfLongHorizontal)textBlock7.new ConnectionIn(rainbow3));
        TextBlock textBlock8 = textBlock2;
        textBlock8.getClass();
        object2.add((FtileIfLongHorizontal)textBlock8.new ConnectionLastElseIn(FtileIfWithLinks.getInColor(branch, rainbow)));
        TextBlock textBlock9 = textBlock2;
        textBlock9.getClass();
        object2.add((FtileIfLongHorizontal)textBlock9.new ConnectionLastElseOut(rainbow));
        Rainbow rainbow5 = linkRendering2.getRainbow(rainbow);
        TextBlock textBlock10 = textBlock2;
        textBlock10.getClass();
        object2.add((FtileIfLongHorizontal)textBlock10.new ConnectionHline(rainbow5));
        return FtileUtils.addConnection((Ftile)textBlock2, (Collection<Connection>)object2);
    }

    private static double getYdiamontOutToLeft(FtileGeometry ftileGeometry, StringBounder stringBounder) {
        return (ftileGeometry.getInY() + ftileGeometry.getOutY()) / 2.0;
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        ArrayList<Ftile> arrayList = new ArrayList<Ftile>(this.tiles);
        arrayList.add(this.tile2);
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        if (ftile == this.tile2) {
            return this.getTranslate2(stringBounder);
        }
        if (this.couples.contains(ftile)) {
            return this.getTranslateCouple1(ftile, stringBounder);
        }
        if (this.tiles.contains(ftile)) {
            return this.getTranslate1(ftile, stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    private UTranslate getTranslate2(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry2 = this.tile2.calculateDimension(stringBounder);
        double d = ((Dimension2D)ftileGeometry).getWidth() - ((Dimension2D)ftileGeometry2).getWidth();
        double d2 = (((Dimension2D)ftileGeometry).getHeight() - 0.0 - ((Dimension2D)ftileGeometry2).getHeight()) / 2.0 + 0.0;
        return new UTranslate(d, d2);
    }

    private UTranslate getTranslateDiamond1(Ftile ftile, StringBounder stringBounder) {
        int n = this.diamonds.indexOf(ftile);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        UTranslate uTranslate = this.getTranslateCouple1(this.couples.get(n), stringBounder);
        UTranslate uTranslate2 = this.couples.get(n).getTranslateFor(ftile, stringBounder);
        return uTranslate.compose(uTranslate2);
    }

    public UTranslate getTranslate1(Ftile ftile, StringBounder stringBounder) {
        int n = this.tiles.indexOf(ftile);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        UTranslate uTranslate = this.getTranslateCouple1(this.couples.get(n), stringBounder);
        UTranslate uTranslate2 = this.couples.get(n).getTranslateFor(ftile, stringBounder);
        return uTranslate.compose(uTranslate2);
    }

    private UTranslate getTranslateCouple1(Ftile ftile, StringBounder stringBounder) {
        double d = 0.0;
        for (Ftile ftile2 : this.couples) {
            FtileGeometry ftileGeometry = ftile2.calculateDimension(stringBounder);
            if (ftile2 == ftile) {
                return new UTranslate(d, 25.0);
            }
            d += ftileGeometry.getWidth() + 20.0;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        for (Ftile ftile : this.couples) {
            uGraphic.apply(this.getTranslateCouple1(ftile, stringBounder)).draw(ftile);
        }
        uGraphic.apply(this.getTranslate2(stringBounder)).draw(this.tile2);
    }

    private FtileGeometry calculateDimensionInternal(StringBounder stringBounder) {
        Dimension2D dimension2D = new Dimension2DDouble(0.0, 0.0);
        for (Ftile ftile : this.couples) {
            dimension2D = Dimension2DDouble.mergeLR(dimension2D, ftile.calculateDimension(stringBounder));
        }
        FtileGeometry ftileGeometry = this.tile2.calculateDimension(stringBounder);
        dimension2D = Dimension2DDouble.mergeLR(dimension2D, ftileGeometry);
        dimension2D = Dimension2DDouble.delta(dimension2D, 20.0 * (double)this.couples.size(), 100.0);
        return new FtileGeometry(dimension2D, dimension2D.getWidth() / 2.0, 0.0);
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.calculateDimensionInternal(stringBounder);
        ArrayList<Ftile> arrayList = new ArrayList<Ftile>(this.tiles);
        arrayList.add(this.tile2);
        for (Ftile ftile : arrayList) {
            if (!ftile.calculateDimension(stringBounder).hasPointOut()) continue;
            return new FtileGeometry(ftileGeometry, ((Dimension2D)ftileGeometry).getWidth() / 2.0, 0.0, ((Dimension2D)ftileGeometry).getHeight());
        }
        return new FtileGeometry(ftileGeometry, ((Dimension2D)ftileGeometry).getWidth() / 2.0, 0.0);
    }

    class ConnectionHline
    extends AbstractConnection {
        private final Rainbow arrowColor;

        public ConnectionHline(Rainbow rainbow) {
            super(null, null);
            this.arrowColor = rainbow;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            FtileGeometry ftileGeometry = FtileIfLongHorizontal.this.calculateDimensionInternal(stringBounder);
            Swimlane swimlane = uGraphic instanceof UGraphicInterceptorOneSwimlane ? ((UGraphicInterceptorOneSwimlane)uGraphic).getSwimlane() : null;
            ArrayList<Ftile> arrayList = new ArrayList<Ftile>(FtileIfLongHorizontal.this.couples);
            arrayList.add(FtileIfLongHorizontal.this.tile2);
            double d = ((Dimension2D)ftileGeometry).getWidth() / 2.0;
            double d2 = ((Dimension2D)ftileGeometry).getWidth() / 2.0;
            boolean bl = false;
            for (Ftile ftile : arrayList) {
                if (!ftile.calculateDimension(stringBounder).hasPointOut() || swimlane != null && !ftile.getSwimlanes().contains(swimlane) || swimlane != null && ftile.getSwimlaneOut() != swimlane) continue;
                bl = true;
                UTranslate uTranslate = FtileIfLongHorizontal.this.getTranslateFor(ftile, stringBounder);
                double d3 = ftile.calculateDimension(stringBounder).translate(uTranslate).getLeft();
                d = Math.min(d, d3);
                d2 = Math.max(d2, d3);
            }
            if (!bl) {
                return;
            }
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor);
            snake.goUnmergeable(MergeStrategy.NONE);
            double d4 = ((Dimension2D)ftileGeometry).getHeight();
            snake.addPoint(d, d4);
            snake.addPoint(d2, d4);
            uGraphic.draw(snake);
        }
    }

    class ConnectionVerticalOut
    extends AbstractConnection {
        private final Rainbow color;

        public ConnectionVerticalOut(Ftile ftile, Rainbow rainbow) {
            super(ftile, null);
            this.color = rainbow;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            double d = FtileIfLongHorizontal.this.calculateDimensionInternal(stringBounder).getHeight();
            Point2D point2D = this.getP1(stringBounder);
            if (point2D == null) {
                return;
            }
            Point2D.Double double_ = new Point2D.Double(point2D.getX(), d);
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.color, Arrows.asToDown());
            snake.addPoint(point2D);
            snake.addPoint(double_);
            uGraphic.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            if (!ftileGeometry.hasPointOut()) {
                return null;
            }
            Point2D point2D = ftileGeometry.getPointOut();
            return FtileIfLongHorizontal.this.getTranslate1(this.getFtile1(), stringBounder).getTranslated(point2D);
        }
    }

    class ConnectionVerticalIn
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow color;

        public ConnectionVerticalIn(Ftile ftile, Ftile ftile2, Rainbow rainbow) {
            super(ftile, ftile2);
            this.color = rainbow;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.color, Arrows.asToDown());
            snake.addPoint(point2D);
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            Point2D point2D = this.getFtile1().calculateDimension(stringBounder).getPointOut();
            return FtileIfLongHorizontal.this.getTranslateDiamond1(this.getFtile1(), stringBounder).getTranslated(point2D);
        }

        private Point2D getP2(StringBounder stringBounder) {
            Point2D point2D = this.getFtile2().calculateDimension(stringBounder).getPointIn();
            return FtileIfLongHorizontal.this.getTranslate1(this.getFtile2(), stringBounder).getTranslated(point2D);
        }

        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            Point2D point2D = this.getP1(uGraphic.getStringBounder());
            Point2D point2D2 = this.getP2(uGraphic.getStringBounder());
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.color, Arrows.asToDown());
            Point2D point2D3 = uTranslate.getTranslated(point2D);
            Point2D point2D4 = uTranslate2.getTranslated(point2D2);
            double d = point2D3.getY() + 4.0;
            snake.addPoint(point2D3);
            snake.addPoint(point2D3.getX(), d);
            snake.addPoint(point2D4.getX(), d);
            snake.addPoint(point2D4);
            uGraphic.draw(snake);
        }
    }

    class ConnectionLastElseOut
    extends AbstractConnection {
        private final Rainbow arrowColor;

        public ConnectionLastElseOut(Rainbow rainbow) {
            super(FtileIfLongHorizontal.this.tile2, null);
            this.arrowColor = rainbow;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            UTranslate uTranslate = FtileIfLongHorizontal.this.getTranslate2(stringBounder);
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            if (!ftileGeometry.hasPointOut()) {
                return;
            }
            Point2D point2D = uTranslate.getTranslated(ftileGeometry.getPointOut());
            double d = FtileIfLongHorizontal.this.calculateDimensionInternal(stringBounder).getHeight();
            Point2D.Double double_ = new Point2D.Double(point2D.getX(), d);
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            snake.addPoint(point2D);
            snake.addPoint(double_);
            uGraphic.draw(snake);
        }
    }

    class ConnectionLastElseIn
    extends AbstractConnection {
        private final Rainbow arrowColor;

        public ConnectionLastElseIn(Rainbow rainbow) {
            super((Ftile)FtileIfLongHorizontal.this.diamonds.get(FtileIfLongHorizontal.this.diamonds.size() - 1), FtileIfLongHorizontal.this.tile2);
            this.arrowColor = rainbow;
        }

        public void drawU(UGraphic uGraphic) {
            Point2D point2D = this.getP1(uGraphic.getStringBounder());
            UTranslate uTranslate = FtileIfLongHorizontal.this.getTranslate2(uGraphic.getStringBounder());
            Point2D point2D2 = uTranslate.getTranslated(this.getFtile2().calculateDimension(uGraphic.getStringBounder()).getPointIn());
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            snake.addPoint(point2D);
            snake.addPoint(point2D2.getX(), point2D.getY());
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            Point2D.Double double_ = new Point2D.Double(ftileGeometry.getLeft() * 2.0, FtileIfLongHorizontal.getYdiamontOutToLeft(ftileGeometry, stringBounder));
            return FtileIfLongHorizontal.this.getTranslateDiamond1(this.getFtile1(), stringBounder).getTranslated(double_);
        }
    }

    class ConnectionIn
    extends AbstractConnection {
        private final Rainbow arrowColor;

        public ConnectionIn(Rainbow rainbow) {
            super(null, (Ftile)FtileIfLongHorizontal.this.diamonds.get(0));
            this.arrowColor = rainbow;
        }

        public void drawU(UGraphic uGraphic) {
            UTranslate uTranslate = FtileIfLongHorizontal.this.getTranslateDiamond1(this.getFtile2(), uGraphic.getStringBounder());
            Point2D point2D = uTranslate.getTranslated(this.getFtile2().calculateDimension(uGraphic.getStringBounder()).getPointIn());
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            Point2D point2D2 = FtileIfLongHorizontal.this.calculateDimensionInternal(uGraphic.getStringBounder()).getPointIn();
            snake.addPoint(point2D2);
            snake.addPoint(point2D.getX(), point2D2.getY());
            snake.addPoint(point2D);
            uGraphic.draw(snake);
        }
    }

    class ConnectionHorizontal
    extends AbstractConnection {
        private final Rainbow color;

        public ConnectionHorizontal(Ftile ftile, Ftile ftile2, Rainbow rainbow) {
            super(ftile, ftile2);
            this.color = rainbow;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.color, Arrows.asToRight());
            snake.addPoint(point2D);
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            Point2D.Double double_ = new Point2D.Double(ftileGeometry.getLeft() * 2.0, FtileIfLongHorizontal.getYdiamontOutToLeft(ftileGeometry, stringBounder));
            return FtileIfLongHorizontal.this.getTranslateDiamond1(this.getFtile1(), stringBounder).getTranslated(double_);
        }

        private Point2D getP2(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = this.getFtile2().calculateDimension(stringBounder);
            Point2D.Double double_ = new Point2D.Double(0.0, FtileIfLongHorizontal.getYdiamontOutToLeft(ftileGeometry, stringBounder));
            return FtileIfLongHorizontal.this.getTranslateDiamond1(this.getFtile2(), stringBounder).getTranslated(double_);
        }
    }
}

