/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.asciiart.AbstractComponentText;
import znaishaded.net.sourceforge.plantuml.asciiart.UmlCharArea;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextParticipant
extends AbstractComponentText {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final FileFormat fileFormat;

    public ComponentTextParticipant(ComponentType componentType, Display display, FileFormat fileFormat) {
        this.type = componentType;
        this.stringsToDisplay = display;
        this.fileFormat = fileFormat;
    }

    public void drawU(UGraphic uGraphic, Area area, Context2D context2D) {
        Dimension2D dimension2D = area.getDimensionToUse();
        UmlCharArea umlCharArea = ((UGraphicTxt)uGraphic).getCharArea();
        int n = (int)dimension2D.getWidth();
        int n2 = (int)dimension2D.getHeight();
        umlCharArea.fillRect(' ', 0, 0, n, n2);
        if (this.fileFormat == FileFormat.UTXT) {
            umlCharArea.drawBoxSimpleUnicode(0, 0, n, n2);
            if (this.type == ComponentType.PARTICIPANT_TAIL) {
                umlCharArea.drawChar('\u2534', (n - 1) / 2, 0);
            }
            if (this.type == ComponentType.PARTICIPANT_HEAD) {
                umlCharArea.drawChar('\u252c', (n - 1) / 2, n2 - 1);
            }
        } else {
            umlCharArea.drawBoxSimple(0, 0, n, n2);
            if (this.type == ComponentType.PARTICIPANT_TAIL) {
                umlCharArea.drawChar('+', (n - 1) / 2, 0);
            }
            if (this.type == ComponentType.PARTICIPANT_HEAD) {
                umlCharArea.drawChar('+', (n - 1) / 2, n2 - 1);
            }
        }
        umlCharArea.drawStringsLR(this.stringsToDisplay.as(), 1, 1);
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + 2;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWidth(this.stringsToDisplay) + 2;
    }
}

