/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.code;

import java.io.IOException;
import znaishaded.net.sourceforge.plantuml.code.ArobaseStringCompressor;
import znaishaded.net.sourceforge.plantuml.code.AsciiEncoder;
import znaishaded.net.sourceforge.plantuml.code.Compression;
import znaishaded.net.sourceforge.plantuml.code.CompressionHuffman;
import znaishaded.net.sourceforge.plantuml.code.StringCompressor;
import znaishaded.net.sourceforge.plantuml.code.StringCompressorNone;
import znaishaded.net.sourceforge.plantuml.code.Transcoder;
import znaishaded.net.sourceforge.plantuml.code.URLEncoder;

public class TranscoderImpl
implements Transcoder {
    private final Compression compression;
    private final URLEncoder urlEncoder;
    private final StringCompressor stringCompressor;

    public TranscoderImpl() {
        this(new AsciiEncoder(), new StringCompressorNone(), new CompressionHuffman());
    }

    public TranscoderImpl(URLEncoder uRLEncoder, Compression compression) {
        this(uRLEncoder, new ArobaseStringCompressor(), compression);
    }

    public TranscoderImpl(URLEncoder uRLEncoder, StringCompressor stringCompressor, Compression compression) {
        this.compression = compression;
        this.urlEncoder = uRLEncoder;
        this.stringCompressor = stringCompressor;
    }

    public String encode(String string) throws IOException {
        String string2 = this.stringCompressor.compress(string);
        byte[] byArray = string2.getBytes("UTF-8");
        byte[] byArray2 = this.compression.compress(byArray);
        return this.urlEncoder.encode(byArray2);
    }

    public String decode(String string) throws IOException {
        byte[] byArray = this.urlEncoder.decode(string);
        byte[] byArray2 = this.compression.decompress(byArray);
        return this.stringCompressor.decompress(new String(byArray2, "UTF-8"));
    }
}

