/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole;

import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.creole.Command;
import znaishaded.net.sourceforge.plantuml.creole.StripeSimple;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;

public class CommandCreoleMonospaced
implements Command {
    public static final String MONOSPACED = "monospaced";
    private final Pattern2 pattern;
    private final String monospacedFamily;

    public static Command create(String string) {
        return new CommandCreoleMonospaced("^(?i)([%g][%g](.*?)[%g][%g])", string);
    }

    private CommandCreoleMonospaced(String string, String string2) {
        this.pattern = MyPattern.cmpile(string);
        this.monospacedFamily = string2;
    }

    public int matchingSize(String string) {
        Matcher2 matcher2 = this.pattern.matcher(string);
        if (!matcher2.find()) {
            return 0;
        }
        return matcher2.group(1).length();
    }

    public String executeAndGetRemaining(String string, StripeSimple stripeSimple) {
        Matcher2 matcher2 = this.pattern.matcher(string);
        if (!matcher2.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fontConfiguration = stripeSimple.getActualFontConfiguration();
        FontConfiguration fontConfiguration2 = fontConfiguration.changeFamily(this.monospacedFamily);
        stripeSimple.setActualFontConfiguration(fontConfiguration2);
        stripeSimple.analyzeAndAdd(matcher2.group(2));
        stripeSimple.setActualFontConfiguration(fontConfiguration);
        return string.substring(matcher2.group(1).length());
    }
}

