/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.CreoleParser;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Member;
import znaishaded.net.sourceforge.plantuml.cucadiagram.MemberImpl;
import znaishaded.net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockVertical2;
import znaishaded.net.sourceforge.plantuml.svek.Ports;
import znaishaded.net.sourceforge.plantuml.svek.WithPorts;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BodyEnhanced
extends AbstractTextBlock
implements TextBlock,
WithPorts {
    private TextBlock area2;
    private final FontConfiguration titleConfig;
    private final List<String> rawBody;
    private final FontParam fontParam;
    private final ISkinParam skinParam;
    private final boolean lineFirst;
    private final HorizontalAlignment align;
    private final boolean manageHorizontalLine;
    private final boolean manageModifier;
    private final List<Url> urls = new ArrayList<Url>();
    private final Stereotype stereotype;
    private final ILeaf entity;

    public BodyEnhanced(List<String> list, FontParam fontParam, ISkinParam iSkinParam, boolean bl, Stereotype stereotype, ILeaf iLeaf) {
        this.rawBody = new ArrayList<String>(list);
        this.stereotype = stereotype;
        this.fontParam = fontParam;
        this.skinParam = iSkinParam;
        this.titleConfig = new FontConfiguration(iSkinParam, fontParam, stereotype);
        this.lineFirst = true;
        this.align = iSkinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT);
        this.manageHorizontalLine = true;
        this.manageModifier = bl;
        this.entity = iLeaf;
    }

    public BodyEnhanced(Display display, FontParam fontParam, ISkinParam iSkinParam, HorizontalAlignment horizontalAlignment, Stereotype stereotype, boolean bl, boolean bl2, ILeaf iLeaf) {
        this.entity = iLeaf;
        this.stereotype = stereotype;
        this.rawBody = new ArrayList<String>();
        for (CharSequence charSequence : display) {
            this.rawBody.add(charSequence.toString());
        }
        this.fontParam = fontParam;
        this.skinParam = iSkinParam;
        this.titleConfig = new FontConfiguration(iSkinParam, fontParam, stereotype);
        this.lineFirst = false;
        this.align = iSkinParam.getDefaultTextAlignment(horizontalAlignment);
        this.manageHorizontalLine = bl;
        this.manageModifier = bl2;
    }

    private TextBlock decorate(StringBounder stringBounder, TextBlock textBlock, char c, TextBlock textBlock2) {
        if (c == '\u0000') {
            return textBlock;
        }
        if (textBlock2 == null) {
            return new TextBlockLineBefore(TextBlockUtils.withMargin(textBlock, 6.0, 4.0), c);
        }
        Dimension2D dimension2D = textBlock2.calculateDimension(stringBounder);
        TextBlockLineBefore textBlockLineBefore = new TextBlockLineBefore(TextBlockUtils.withMargin(textBlock, 6.0, 6.0, dimension2D.getHeight() / 2.0, 4.0), c, textBlock2);
        return TextBlockUtils.withMargin(textBlockLineBefore, 0.0, 0.0, dimension2D.getHeight() / 2.0, 0.0);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.getArea(stringBounder).calculateDimension(stringBounder);
    }

    private TextBlock getArea(StringBounder stringBounder) {
        if (this.area2 != null) {
            return this.area2;
        }
        this.urls.clear();
        ArrayList<TextBlock> arrayList = new ArrayList<TextBlock>();
        char c = this.lineFirst ? (char)'_' : '\u0000';
        TextBlock textBlock = null;
        ArrayList<Member> arrayList2 = new ArrayList<Member>();
        ListIterator<String> listIterator = this.rawBody.listIterator();
        while (listIterator.hasNext()) {
            Object object;
            String string = listIterator.next();
            if (this.manageHorizontalLine && BodyEnhanced.isBlockSeparator(string)) {
                arrayList.add(this.decorate(stringBounder, new MethodsOrFieldsArea(arrayList2, this.fontParam, this.skinParam, this.align, this.stereotype, this.entity), c, textBlock));
                c = string.charAt(0);
                textBlock = this.getTitle(string, this.skinParam);
                arrayList2 = new ArrayList();
                continue;
            }
            if (CreoleParser.isTreeStart(string)) {
                if (arrayList2.size() > 0) {
                    arrayList.add(this.decorate(stringBounder, new MethodsOrFieldsArea(arrayList2, this.fontParam, this.skinParam, this.align, this.stereotype, this.entity), c, textBlock));
                }
                arrayList2 = new ArrayList();
                object = BodyEnhanced.buildAllTree(string, listIterator);
                TextBlock textBlock2 = Display.create((Collection<? extends CharSequence>)object).create(this.fontParam.getFontConfiguration(this.skinParam), this.align, (ISkinSimple)this.skinParam, CreoleMode.FULL);
                arrayList.add(textBlock2);
                continue;
            }
            object = new MemberImpl(string, MemberImpl.isMethod(string), this.manageModifier);
            arrayList2.add((Member)object);
            if (object.getUrl() == null) continue;
            this.urls.add(object.getUrl());
        }
        arrayList.add(this.decorate(stringBounder, new MethodsOrFieldsArea(arrayList2, this.fontParam, this.skinParam, this.align, this.stereotype, this.entity), c, textBlock));
        this.area2 = arrayList.size() == 1 ? (TextBlock)arrayList.get(0) : new TextBlockVertical2(arrayList, this.align);
        return this.area2;
    }

    private static List<String> buildAllTree(String string, ListIterator<String> listIterator) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        while (listIterator.hasNext()) {
            String string2 = listIterator.next();
            if (CreoleParser.isTreeStart(StringUtils.trinNoTrace(string2))) {
                arrayList.add(string2);
                continue;
            }
            listIterator.previous();
            return arrayList;
        }
        return arrayList;
    }

    public static boolean isBlockSeparator(String string) {
        if (string.startsWith("--") && string.endsWith("--")) {
            return true;
        }
        if (string.startsWith("==") && string.endsWith("==")) {
            return true;
        }
        if (string.startsWith("..") && string.endsWith("..") && !string.equals("...")) {
            return true;
        }
        return string.startsWith("__") && string.endsWith("__");
    }

    private TextBlock getTitle(String string, ISkinSimple iSkinSimple) {
        if (string.length() <= 4) {
            return null;
        }
        string = StringUtils.trin(string.substring(2, string.length() - 2));
        return Display.getWithNewlines(string).create(this.titleConfig, HorizontalAlignment.LEFT, iSkinSimple);
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        TextBlock textBlock = this.getArea(stringBounder);
        if (textBlock instanceof WithPorts) {
            return ((WithPorts)((Object)textBlock)).getPorts(stringBounder);
        }
        return new Ports();
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        this.getArea(uGraphic.getStringBounder()).drawU(uGraphic);
    }

    public List<Url> getUrls() {
        return Collections.unmodifiableList(this.urls);
    }

    @Override
    public Rectangle2D getInnerPosition(String string, StringBounder stringBounder, InnerStrategy innerStrategy) {
        return this.getArea(stringBounder).getInnerPosition(string, stringBounder, innerStrategy);
    }
}

